#!/usr/bin/perl
################################################################################

package gterm::ascii;

#######################################
#                                     #
#     Termal Ascii String Handeling   #
#                                     #
#    (C) 2020 Domero                  #
#                                     #
#######################################

use strict;
use warnings;
use Exporter;
use vars qw($VERSION @ISA @EXPORT @EXPORT_OK);

$VERSION     = '2.0.1';
@ISA         = qw(Exporter);
@EXPORT      = qw();
@EXPORT_OK   = qw();

my $TERMASCII;
my $PAGES   = {};

use Carp;
use POSIX;
use open qw/:std :utf8/;
use Term::ANSIColor qw(:constants :constants256);
use Unicode::String qw(utf8);
use Term::Cap qw();
use gterm::base qw(ascii_id id_ascii id_mouseevent);
use glib qw(dechex xchr nchr);
use gerr;

################################################################################
# my $ascii = term::ascii->new() ;

sub new {
    my ($class)=@_;
    if (!defined $TERMASCII) {
        $TERMASCII = {class => $class};
        bless $TERMASCII;
        $TERMASCII->init();
    }
    return $TERMASCII
}

################################################################################
# Term :: Cap

sub cap {
    if (-t) {
        my ($self)=@_;
        if (!$self->{ios}) { 
            $self->{ios} = new POSIX::Termios;
            $self->{ios}->getattr;
        }
        if (!$self->{cap}) { 
            my $ospeed = $self->{ios}->getospeed;
            $self->{cap} = Tgetent Term::Cap { TERM => undef, OSPEED => $ospeed };
        }
        return $self->{cap}
    }
    return undef
}

sub Tputs { my $self=shift(); my $cap=$self->cap(); return defined $cap ? $cap->Tputs(@_) : undef }
# dl cl
sub dl { my ($self)=@_; return $self->Tputs('dl', my $count = 1) }
sub cl { my ($self)=@_; return $self->Tputs('cl') }

# 0,0 = ^[.27.1B, [.91.5B, 1.49.31, ;.59.3B, 1.49.31, H.72.48
# w,h = ^[.27.1B, [.91.5B, 5.53.35, 6.54.36, ;.59.3B, 2.50.32, 3.51.33, 9.57.39, H.72.48
sub goto { my $self=shift(); my $cap=$self->cap(); return defined $cap ? $cap->Tgoto(@_) : undef }
sub cm {
    my ($self,$x,$y,$w,$h)=@_;
    if (!defined $x) { die ("Column Not Defined") }
    if (!defined $y) { die ("Row Out of Range") }
    if ($x < 0 || defined $w && $x > $w) { die ("Column Out of Range") }
    if ($y < 0 || defined $h && $y > $h) { die ("Row Out of Range") }
    #return $self->goto("cm", $x, $y) || ""
    return $self->at($x, $y)
}

# returns Position String
#   "00-1,000" : "\u001b.27 , [.91 , 0.48 , ;.59 , 1.49 , H.72",
sub at { 
    my ($self, $x, $y)=@_; my $c="";
    if (!eval('$c="\\x{001B}['.($y+1).';'.($x+1).'H"; return 1')) { die $@ }
    return $c
}

################################################################################
#
#   Terminal Codes
#
#   Codes from 0 to 127 are encoded into a single byte. (from 0x00 to 0x7F)
#
################################################################################

sub pagemap {
    my ($page,$index)=@_;
    if (!defined $page) { return $PAGES }
    if (!defined $index) { return $PAGES->{$page} }
    if (!defined $PAGES->{$page}) {
        if ($page > 216) { die ("Page Number $page Too High for UTF-8 Unicode Support") }
        for (my $i=0;$i<256;$i++) { $PAGES->{$page}[$i]=nchr($i) }
    }
    return $PAGES->{$page}[$index]
}


sub A_Z      { my ($self,$l)=@_; $l>=65 && $l<=90 ? chr($l) : undef } # 'A-Z',            #  41-5A  65-90 A-Z Capital Letters
sub a_z      { my ($self,$l)=@_; $l>=97 && $l<=122 ? chr($l) : undef } # 'a-z',            #  61-7A  97-122 a-z LowerCase Letters

# \x{20E3} #  ⃣
# #⃣ 0⃣ 1⃣ 2⃣ 3⃣ 4⃣ 5⃣ 6⃣ 7⃣ 8⃣ 9⃣
sub capture { # combining enclosing keycap # char <= 0xFF
    my($self,$ch)=@_;
    return xchr(dechex(ord($ch),2)."E283A3")
}
# Flags
#   🇳🇱  U+1F1E6(+26) U+1F1E6(+26)  regional indicator symbol letters a & z
sub flag { # E6 = 230
    my ($self,$code)=@_;
    my ($a,$b)=split(//,lc($code));
    return xchr("01F1".dechex(230+ord($a)-97,2)).xchr("01F1".dechex(230+ord($b)-97,2));
}

################################################################################

sub init {
    my ($self)=@_;
    $self->{map}=[pagemap(0)];
    return $self
}

sub map { 
    my($self,$page,$char)=@_; 
    return defined $self->{map} && 
        defined $page && 
        defined $self->{map}[$page] &&
        defined $self->{map}[$page][$char] ? $self->{map}[$page][$char]
        : ""
}

################################################################################
# Check Character Set

sub linux_unicode {
  my @m=`locale charmap`;
  for (my $l=0;$l<$#m;$l++) {
    if ($m[$l] =~ /UTF\-8/){ return 1 }
  }
  return 0
}

################################################################################
# in Length
sub sl { defined $_[0] ? $_[0] x (defined $_[1] && int($_[1]||0) > 0 ? $_[1]:1) : "" }

################################################################################
# ASCII By Name

################################################################################
# Class Function
sub n { my $self=shift(); return ascii_id(@_) }
sub un { utf8(n(@_)) }
sub html { glib::encode_entities(un(@_)) }
################################################################################

################################################################################
new();1; # EOF gterm::ascii (c) 2020 OnEhIppY, Groningen, Domero
################################################################################
