#!/usr/bin/perl
################################################################################

################################################################################
#
#	use gterm::cntrl;
#	use gterm::box;
#
#	my $row=gterm::box::row->new( e => 'dotted', c => 'green', l=>0, t=>0, w=>cols(), h=>rows() );
#	$row->line(0," Text Line ");
#
################################################################################

package gterm::box;

use gerr;
use gterm::cntrl;

################################################################################

sub new {
	my ($class,$parent)=@_;
	my $box={p=>$parent,l=>[]};
	bless $box;
	return $box->init();
}

sub init {
	my ($self)=@_;
	# Box Edge
	if ($self->{p}{e}) {
		$self->{p}{il}=$self->{p}{l}+1;
		$self->{p}{iw}=$self->{p}{w}-2;
		$self->{p}{it}=$self->{p}{t}+1;
		$self->{p}{ih}=$self->{p}{h}-2;
	}else{
		$self->{p}{il}=$self->{p}{l};
		$self->{p}{iw}=$self->{p}{w};
		$self->{p}{it}=$self->{p}{t};
		$self->{p}{ih}=$self->{p}{h};
	}
	# Right Bottom Position
	$self->{p}{r}=$self->{p}{l}+$self->{p}{w};
	$self->{p}{b}=$self->{p}{t}+$self->{p}{h};
	# Column Rows
	$self->{p}{childs}=[];
	return $self->draw()
}

################################################################################

sub draw {
	my ($box)=@_;
	drawbox($box->{p}{e},$box->{p}{l},$box->{p}{t},$box->{p}{w},$box->{p}{h},$box->{p}{c},1);
	if ($box->{p}{e} && $box->{p}{c}) {$box->title()}
	return $box->write()
}

sub title {
	my ($box)=@_;
	if ($box->{p}{title}) {
		prat($box->{p}{il},$box->{p}{t},tc($box->{p}{c}[0]).tc('on_'.$box->{p}{c}[1])."[ $box->{p}{title} ]".tc('reset'));
	}
	return $box
}

sub write {
	my ($box)=@_;
	for my $line (0..$#{$box->{l}}) { $box->write_line($line) }
	return $box
}

sub write_line {
	my ($box,$line)=@_;
	if ($line < $box->{p}{ih} && defined $box->{l}[$line]) {
		prat(
			$box->{p}{il},
			$box->{p}{it} + $line,
			($box->{p}{c} ? tc('on_'.$box->{p}{c}[1]) :'') . $box->{l}[$line],
			$box->{p}{iw}
		);
	}
	return $box
}

sub line { my ($box,$line,$text)=@_; $box->{l}[$line]=$text; return $box->write_line($line) }

sub vline {
	my ($self,$col,$prc,$color)=@_;
	my $size=$self->{p}{ih};
	#print STDOUT tc('clear_screen').tc('restore_terminal').gparse::str({size=>$size,prc=>$prc,,args=>[@_]});
	#exit 1;
	my $vbar = vbar($size,$prc);
	for my $line (0..($size-1)) {
		prat(
			$self->{p}{il} + $col,
			$self->{p}{it} + ( $self->{p}{ih} - 1 - $line ),
			$color . $vbar->[$line] . tc('reset')
		);
	}
}

sub hline {}


################################################################################
################################################################################

sub row {
	my ($self,%options)=@_;
	my $row=gterm::box::row->new(parent=>$self->{p},%options);
	push @{$self->{p}{childs}}, $row;
	return $row
}

sub col {
	my ($self,%options)=@_;
	my $col=gterm::box::col->new(parent=>$self->{p},%options);
	push @{$self->{p}{childs}}, $col;
	return $col
}

sub table {
	my ($self,%options)=@_;
	my $table=gterm::box::table->new(parent=>$self->{p},%options);
	push @{$self->{p}{childs}}, $table;
	return $table
}

################################################################################
################################################################################

package gterm::box::row;

use gterm::cntrl qw(cols);

################################################################################

sub new {
	my ($class,%options)=@_;
	my $self=\%options;
	bless $self;
	# Init Row
	$self->{l} = $self->{l} || (!$self->{parent} ? 0 : $self->{parent}{il});
	$self->{t} >>=0;
	$self->{w} = $self->{w} || (!$self->{parent} ? cols() : $self->{parent}{iw});
	$self->{h} >>=0;
	# Row Box & Lines
	$self->{box}=gterm::box->new($self);

	return $self
}

sub box { my ($self)=@_; return $self->{box} }

################################################################################
################################################################################

package gterm::box::col;

use gterm::cntrl qw(rows);

################################################################################

sub new {
	my ($class,%options)=@_;
	my $self=\%options;
	bless $self;
	# Init Column
	$self->{l} >>= 0;
	$self->{t} = $self->{t} || (!$self->{parent} ? 0 : $self->{parent}{it});
	$self->{w} >>= 0;
	$self->{h} = $self->{h} || (!$self->{parent} ? rows() : $self->{parent}{ih});
	# Box Edge
	$self->{box} = gterm::box->new($self);
	return $self
}

sub box { my ($self)=@_; return $self->{box} }

################################################################################
################################################################################

package gterm::box::table;

use gterm::cntrl qw(rows cols);

################################################################################

sub new {
	my ($class,%options)=@_;
	my $self=\%options;
	bless $self;
	# Init Table
	$self->{l} = defined $self->{l} ? $self->{l}>>0 : !$self->{parent} ? 1 : $self->{parent}{il}+1;
	$self->{w} = defined $self->{w} ? $self->{w}>>0 : !$self->{parent} ? cols()-2 : $self->{parent}{iw}-2;
	$self->{t} = defined $self->{t} ? $self->{t}>>0 : !$self->{parent} ? 0 : $self->{parent}{it};
	$self->{h} = defined $self->{h} ? $self->{h}>>0 : !$self->{parent} ? rows() : $self->{parent}{ih};
	# Column Box & Lines
	$self->{box}=gterm::box->new($self);
	return $self
}

sub box { my ($self)=@_; return $self->{box} }

# $col->table->data( [ [ text, text, .. ], [ .. ], .. ] )

sub data {
	my ($self,$data) = @_;
	my $nr = ($#{$data}+1);
	my $rn = 0;
	for my $r (@{$data}) {
		if ($rn < $self->{ih}) {
			my $row = $self->{childs}[$rn] || $self->box->row(
				l => $self->{il},
				w => $self->{iw},
				t => $self->{it}+$rn,
				h => 1
			);
			my $cn = 0;
			my $nc = ($#{$r}+1);
			my $cw = ($self->{iw} / $nc)>>0;
			for my $c (@{$r}) {
				my $col = $row->{childs}[$cn] || $row->box->col(
					t => $row->{it},
					h => $row->{ih},
					l => $row->{il}+($cn*$cw),
					w => $cw
				);
				$col->box->line(0,$c);
				$cn++
			}
		}
		$rn++
	}
}

################################################################################
################################################################################
1 # EOF gterm::box (C) 2022 OnEhIppY, Domero, Groningen
