#!/bin/sh

#
#	MacOSx Installation steps.
#
#	1. Give the Terminal Full Disc Access. (by Hand)
#		a. [Apple] > System Settings > Privacy & Security > Full Disk Access > + > Terminal
#		b. Enable Terminal in the list of Full Disk Access
#		c. Reboot to activate disk access.
#	2. Install Xcode Development Layer. (by Hand)
#		a. Open your App Store and search for 'Xcode'.
#		b. Install or update Xcode.
#	3. Install MacPorts Package Manager. (by Hand)
#		a. download for your MacOS version from https://macports.org/install.php
#		b. follow their installation instructions.
#	4. Download and Unpack FCC (zip).
#		a. download from: https://factorialcoin.nl/download/mac
#		b. Unpack to your desired destination (~/Desktop, ~/Documents ?).
#	5. Run FCC/FCC_Install.sh from either the file browser or directly in the terminal.
#		a. this will install HomeBrew Package Manager (Automatic),
#		b. Installs Perl. (Automatic) if not yet installed (Check in the terminal with: perl -v).
#			a. Open Terminal
#			b. enter: curl -L https://xrl.us/installperlosx | bash
#		c. this will build and install gcc, make, tar, zlib, bzip2, mc, screen and all the Perl dependencies.
#	6. Run FCC_Wallet.sh | FCC_Miner.sh | FCC_Node.sh (for running your part you desire).
#
#	You could skip step 5, as step 6 will check if FCC_Install has already run or not, and will run FCC_install if installation was still needed.
#

# Local Binaries
export PATH=$PATH:./bin/

echo ### Checking Homebrew Package Manager ###
pm='brew';
upd='update';
inst='install';
if ! type $pm > /dev/null 2>&1; then
  	echo "### Installing Homebrew Package Manager ###\n\n"
  	bash -c "$(curl -fsSL https://raw.githubusercontent.com/Homebrew/install/HEAD/install.sh)"
fi
if type $pm > /dev/null 2>&1; then
  	echo ### Updating HomeBrew Repository ###
  	cmd="$pm $upd"; eval $cmd
  	echo "\n\n"
else
  	echo ### Error Installing Homebrew Package Manager !!!
  	read -p "Press any key to continue... " -n1 -s
  	exit
fi

echo ### Checking GCC compiler ###
cc='gcc';
if type $cc > /dev/null 2>&1; then
  echo ### Installing GCC compiler ###
  cmd="$pm $inst gcc"; eval $cmd
  echo "\n\n"
else
	echo ### GCC already installed !!!
fi
if type $cc > /dev/null 2>&1; then
  	echo ### Error Installing GCC Compiler !!!
  	read -p "Press any key to continue... " -n1 -s
  	exit
fi

echo ### Checking MAKE ###
mk='make';
if type $mk > /dev/null 2>&1; then
  	echo ### Installing Make ###
  	cmd="$pm $inst make"; eval $cmd
  	echo "\n\n"
else
	echo ### Make already installed !!!
fi
if type $mk > /dev/null 2>&1; then
  	echo ### Error Installing Make !!!
  	read -p "Press any key to continue... " -n1 -s
  	exit
fi

echo ### Checking tar support ###
tar='tar';
if type $tar > /dev/null 2>&1; then
  	echo ### Installing/Updating tar support ###
  	cmd="$pm $inst gnu-tar"; eval $cmd
  	echo "\n\n"
else
	echo ### Tar already installed !!!
fi
if type $tar > /dev/null 2>&1; then
  	echo ### Error Installing Tar !!!
  	read -p "Press any key to continue... " -n1 -s
  	exit
fi

echo ### Checking zlib support ###
zlib='zlib';
if type $zlib > /dev/null 2>&1; then
  	echo ### Installing/Updating zlib support ###
  	cmd="$pm $inst zlib"; eval $cmd
  	echo "\n\n"
else
	echo ### Zlib already installed !!!
fi
if type $zlib > /dev/null 2>&1; then
  	echo ### Error Installing Zlib !!!
  	read -p "Press any key to continue... " -n1 -s
  	exit
else
	export LDFLAGS="-L/opt/homebrew/opt/zlib/lib"
	export CPPFLAGS="-I/opt/homebrew/opt/zlib/include"
fi

echo ### Checking Bzip2 support ###
bzip2='bzip2';
if type $bzip2 > /dev/null 2>&1; then
  	echo ### Installing/Updating Bzip2 support ###
  	cmd="$pm $inst bzip2"; eval $cmd
  	echo "\n\n"
else
	echo ### Bzip2 already installed !!!
fi
if type $bzip2 > /dev/null 2>&1; then
  	echo ### Error Installing Bzip2 !!!
  	read -p "Press any key to continue... " -n1 -s
  	exit
fi


### Xcode ###
echo "\n\n### Checking Xcode Developement Layer ###\n"
xc='xcode-select';
if ! type $xc > /dev/null 2>&1; then
  	echo "!!! Please first Install Xcode Development Layer!!!\n\n"
  	read -p "Press any key to continue... " -n1 -s
else
	echo "\n\n### Installing MacOS Xcode Developement Perl Dependencies ###\n"
	xcode-select --install

  	### MacPorts ###
	echo "\n\n### Checking MacPorts Package Manager ###\n\n"
	pt='port';
	if ! type $pt > /dev/null 2>&1; then
	  	echo "!!! Please first Install MacPorts Package Manager !!!\n\n\tDownload from https://macports.org/install.php\n\n"
	  	read -p "Press any key to continue... " -n1 -s
	else
		echo ### Installing Terminal Explorer tool Midnight Commander (mc) ###
		sudo port install mc
		echo ### Installing background Screen functionality for loop support (screen) ###
		sudo port install screen

	  echo "### Checking Perl ###\n\n"
	  if ! type "perl" &> /dev/null 2>&1; then
			curl -L https://raw.githubusercontent.com/ranguard/installing-perl/master/scripts/install_perl_on_osx.sh | bash
	  fi
	  if type "perl" &> /dev/null 2>&1; then
			echo "\n\n### Exporting Xcode Library dependencies for Perl Extentions ###\n\n"
			perl_version = $(perl-version)
			export CPATH = "/Library/Developer/CommandLineTools/SDKs/MacOSX.sdk/Library/Perl/${perl_version%%$'\n'*}/darwin-thread-multi-2level/CORE"

			echo "\n\n### Installing CPAN dependencies for FCC Perl Modules ###\n\n"

			# Port Perl5 Installation Modules

			# Time::HiRes
			sudo port install p5-time-hires
			# Compress::Raw::Zlib
			sudo port install p5-compress-raw-zlib
			# Compress::Bzip2
			sudo port install p5-compress-bzip2
			# Compress::Raw::Bzip2
			sudo port install p5-compress-raw-bzip2
			# Browser::Open
			sudo port install p5-browser-open
			# IO::Compress
			sudo port install p5-io-compress
			# IO::Socket::IP
			sudo port install p5-io-socket-ip
			# IO::Socket::SSL
			sudo port install p5-io-socket-ssl
			# IO::Zlib Compress::Zlib
			sudo port install p5-io-zlib

			# General CPAN Modules
			sudo cpan install App::cpanminus Crypt::Ed25519 Digest::MD5 Digest::SHA Digest::SHA1 HTTP::Date IO::Socket JSON MIME::QuotedPrint Term::Size::Any URI::Encode URL::Encode Unicode::LineBreak XML::Simple
			sudo cpanm install Gzip::Faster --force

			echo ### Installing FCC Coin Modules ###
			echo "\n\n"
			sudo perl ./install/install.cgi

			echo ### FCC is succesfully installed !!!
			echo ### Open 'FCC_Wallet' to create your first wallet.
			echo ### Open 'FCC_Miner' to mint and earn your first coins.
			echo ### Open 'FCC_Node' to earn your shared transaction fee as you serve the network of core Nodes.
			echo "\n\n"
			echo 1 > installed.fcc
	  else
			echo "Please install Perl first by entering the following command in your terminal shell:"
			echo "curl -L https://xrl.us/installperlosx | bash"
			read -p "Press any key to continue... " -n1 -s
	  fi
	fi
fi

echo "\n"
