#!/usr/bin/perl
#########################################################################################################################################
# ╔═══════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════╗ #
# ║     Domero Terminal Ascii Control                                                                                                 ║ #
# ╠─┄┄┄┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┄┄┄─╣ #
# ║     (C) 2020 OnEhIppY, Groningen, Domero                                                                                          ║ #
# ╚═══════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════╝ #
package gterm::cntrl;
# ╔════════════════════════╤══════════════════════════════════════════════════════════════════════════════════════════════════════════╗ #
# ║  Class                 │  domero/gterm/cntrl.pm                                                                                   ║ #
# ╠════════════════════════╪══════════════════════════════════════════════════════════════════════════════════════════════════════════╣ #
# ║  Version               │  1.0.1                                                                                                   ║ #
# ╠════════════════════════╪══════════════════════════════════════════════════════════════════════════════════════════════════════════╣ #
# ║  Upgrade               │  1                                                                                                       ║ #
# ╠════════════════════════╪══════════════════════════════════════════════════════════════════════════════════════════════════════════╣ #
# ║  Update                │  0                                                                                                       ║ #
# ╠════════════════════════╪══════════════════════════════════════════════════════════════════════════════════════════════════════════╣ #
# ║  Debug                 │  1                                                                                                       ║ #
# ╚════════════════════════╧══════════════════════════════════════════════════════════════════════════════════════════════════════════╝ #
#########################################################################################################################################
# ╔═══════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════╗ #
# ║                                                                                                                                   ║ #

use strict; no strict 'refs';
use warnings; no warnings qw<uninitialized>;
use Exporter;
use vars qw($VERSION @ISA @EXPORT @EXPORT_OK);
use gfio;
use glib qw(xchr echr dechex strlength);
use Term::Cap;
use Term::Size::Any qw(chars);
use utf8;
use Encode;

$VERSION     = '1.0.1';
@ISA         = qw(Exporter);
@EXPORT      = qw(term_ctrl tc size cols rows pr prat barat hbar vbar);
@EXPORT_OK   = qw();

# ║                                                                                                                                   ║ #
# ╚═══════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════╝ #
#########################################################################################################################################
# ╔═══════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════╗ #
# ║ ASCII CONTROL DATA FILE LOCATION                                                                                                  ║ #
# ╠═══════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════╣ #
my $gtermcntrl='gterm/cntrl.pm';
#print STDOUT "[LIB]".$INC{$gtermcntrl}."[/LIB]\n";
my $_gtermcntrl = (defined $INC{$gtermcntrl} && $INC{$gtermcntrl} =~ /^(.+\/)cntrl\.pm$/gs ? $1.'data/term.cntrl' : "/perl/domero/gterm/data/term.cntrl");
our $cangtermcntrl=-f $_gtermcntrl; if (!$cangtermcntrl) { print STDOUT "\n\n[gterm::cntrl][$gtermcntrl][not found]\n" }
$::GTCNTRL_LIB = $_gtermcntrl; #                                                                                                      ║ #
if ($^O =~ /win/gsi) { $::GTCNTRL_LIB =~ s/\//\\/gs }
# ╚═══════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════╝ #
#########################################################################################################################################
# ╔═══════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════╗ #
# ║ Terminal size : [Columns, Rows]                                                                                                   ║ #
# ╠═══════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════╣ #
sub size { return chars() }
sub cols { return @{[chars()]}[0] }
sub rows { return @{[chars()]}[1] }
# ╚═══════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════╝ #
#########################################################################################################################################
sub pr {
    my (@S)=@_;
    binmode STDOUT, ":encoding(UTF-8)";
    #for (my $i=0;$i<=$#S;$i++) { 
        #$S[$i]=utf8($S[$i]);
        #Encode::_utf8_on($S[$i]);
    #}
    print STDOUT join('',@S);
    binmode(STDOUT);
}
sub prat {
    my($x,$y,$t,$w,$c)=@_;
    pr(tc('cursor_save_attr').tc('cursor_pos',$x,$y).$t.($w && strlength($t)-$w > 0 ? (($c||" ")x(strlength($t)-$w)):"") .tc('cursor_restore_attr'));
}

sub barat {
    my ($x,$y,$w,$h,$fg,$bg,$t,$center)=@_;    #pr("\n\n\nBARAT[$x,$y,$w,$h,$fg,$bg,$t,$center]\n");
    my $tw=int(length($t));                    #pr("TW[$tw]\n");
    my $l=($w-$tw)>>1;                         #pr("L[$l]\n");
    my $r=($w-$tw-$l);                         #pr("R[$r]\n");
    if ($l<0 || $l>$w) { $l="" }else{ $l=" "x$l }
    if ($r<0 || $r>$w) { $r="" }else{ $r=" "x$r }
    if ($w<0) { $b="" }else{ $b=" "x$w }
    for my $yy (0..($h-1)) {
        if ($yy!=($h>>1)) {
            prat ($x,$y+$yy,tc($fg).tc("on_$bg").$b);
        } else {
            prat ($x,$y+$yy,tc($fg).tc("on_$bg").(
                !defined $center || $center==1 ? $l.$t.$r :
                $center==2 ? $l.$r.$t :
                $t.$l.$r
            ))
        }
    }
}

sub hbar {
    my ($w,$prc)=@_;
    my $p=($w/100)*$prc;
    my $lp=$p;
    my $ip=int($lp);
    my $dp=$lp-$ip;
    my $cw=int(8*$dp);
    if ($cw>=0 && $cw<=8 ) { $ip-- }
    my $ln=[];
    for my $i (0..$ip) { push @$ln, tc('hbar_8'); $w-- }
    if ($cw >=0 && $cw <=8 && $w>1 ) { push @$ln, tc('hbar_'.$cw); $w-- }
    while ($w>0) { push @$ln, ' '; $w-- }
    return $ln
}

sub vbar {
    my ($w,$prc)=@_;
    my $p=($w/100)*$prc;
    my $lp=$p;
    my $ip=int($lp);
    my $dp=abs($lp-$ip);
    my $cw=int(8*$dp);
    if ($cw>=0 && $cw<=8 ) { $ip-- }
    my $ln=[];
    for my $i (0..$ip) { push @$ln, tc('vbar_8'); $w-- }
    if ($cw>=0 && $cw<=8 ) { push @$ln, tc('vbar_'.$cw); $w-- }
    while ($w>0) { push @$ln, ' '; $w-- }
    return $ln
}

#########################################################################################################################################
# ╔═══════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════╗ #
# ║ Terminal Control Codes                                                                                                            ║ #
# ╠═══════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════╣ #
sub tc { 
# ╔═══════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════╗ #
# ║ Initalize to be able to check for CharStrings                                                                                     ║ #
# ║ Load the term.cntrl library file & create byte search maps for gterm::key                                                         ║ #
# ╠═══════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════╣ #
#########################################################################################################################################
    if (-f $::GTCNTRL_LIB && !defined $::GTCNTRL) {
        #print STDOUT "Open Term Lib [$::GTCNTRL_LIB]\n";
        eval('$::GTCNTRL = '.gfio::content($::GTCNTRL_LIB));
        $::GTCNTRL_ID = {}; 
        for my $nm (keys %{$::GTCNTRL}) { 
            my $chrs=$::GTCNTRL->{$nm};
            if (ref($chrs) ne 'CODE') { $::GTCNTRL_ID->{$chrs} = $nm } 
        }
    }
#########################################################################################################################################
# ╚═══════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════╝ #
#########################################################################################################################################
    term_ctrl(@_) 
}    # (alias)
################################################################################
sub term_ctrl { 
    my $name = shift();
    if (!defined $name) { die "Name is not defined term_cntrl call" }
    if (!defined $::GTCNTRL) { die ("TERM CNTRL Librabry Not Loaded,\n  missing ".(!-d $::DOMERO_LIB ? "DOMERO_LIB directory : [$::DOMERO_LIB]" : !-f $::GTCNTRL_LIB ? "GTCNTRL_LIB file : [$::GTCNTRL_LIB] " : " what??")) }
    if (ref($::GTCNTRL) ne 'HASH') { die ("TERM CNTRL Librabry Not a HASH Referece") }
    if ($name =~ /\,/gsi) { return tc(split(/\,/,$name),@_) }
    if (!defined $::GTCNTRL->{$name}) { die "Name [$name] is not defined in term.cntrl" }
    return value_cntrl($::GTCNTRL->{$name},@_)
}
# ║                                                                                                                                   ║ #
# ╚═══════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════╝ #
#########################################################################################################################################
# ╔═══════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════╗ #
# ║ Terminal Control Codes Reference control                                                                                          ║ #
# ╠═══════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════╣ #
sub value_cntrl {
    my $o = shift();
    if (ref($o) eq 'CODE') { return &{$o}(@_) }
    if (ref($o) eq 'HASH') { return hash_cntrl($o,@_) }
    if (ref($o) eq 'ARRAY') { return array_cntrl($o,@_) }
    return $o
}

sub hash_cntrl {
    my $hash = shift();
    my $key = shift();
    if (!defined $key) { return $hash }
    if (!defined $hash->{$key}) { error ("Ref ($key) Not Defined in HASH: $@ $!"); exit }
    return value_cntrl($hash->{$key},@_)
}

sub array_cntrl {
    my $array = shift();
    my $index = shift();
    if (!defined $index) { return $array }
    if (!defined $array->[$index]) { error ("Index ($index) Not Defined in ARRAY: $@ $!"); exit }
    return value_cntrl($array->[$index],@_)
}
# ║                                                                                                                                   ║ #
# ╚═══════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════╝ #
#########################################################################################################################################

1

#########################################################################################################################################
# ╔═══════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════╗ #
# ║ EOF (C) 2020 OnEhIppY, Groningen, Domero                                                                                          ║ #
# ╚═══════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════╝ #
#########################################################################################################################################
