#!/usr/bin/perl
################################################################################

#############################################
#                                           #
#     Terminal ANSI Color Handeling         #
#                                           #
#    (C) 2020 OnEhIppY, Groningen, Domero   #
#                                           #
#############################################

################################################################################

package gterm::ansi;

################################################################################
use strict;
use warnings;
use Exporter;
use vars qw($VERSION @ISA @EXPORT @EXPORT_OK);

$VERSION     = '2.0.1';
@ISA         = qw(Exporter);
@EXPORT      = qw();
@EXPORT_OK   = qw();

################################################################################

use Carp;
use POSIX;
use Term::ANSIColor qw(:constants :constants256 :pushpop);
use gfio;
use glib qw(dechex);

################################################################################
# Local Global Used
my $ANSI;
sub new { my ($class)=@_; if (defined $ANSI) { return $ANSI } $ANSI = {}; bless $ANSI; return $ANSI }

################################################################################
# :constants
################################################################################
# TEXT MODE
sub clear { CLEAR }
sub reset { RESET }
sub bold { BOLD }
sub dark { DARK }
sub faint { FAINT }
sub italic { ITALIC }
sub underline { UNDERLINE }
sub underscore { UNDERSCORE }
sub blink { BLINK }
sub reverse { REVERSE }
sub concealed { CONCEALED }

################################################################################
# TX COLOR
sub black { BLACK }
sub red { RED }
sub green { GREEN }
sub yellow { YELLOW }
sub blue { BLUE }
sub magenta { MAGENTA }
sub cyan { CYAN }
sub white { WHITE }
sub bright_black { BRIGHT_BLACK }
sub bright_red { BRIGHT_RED }
sub bright_green { BRIGHT_GREEN }
sub bright_yellow { BRIGHT_YELLOW }
sub bright_blue { BRIGHT_BLUE }
sub bright_magenta { BRIGHT_MAGENTA }
sub bright_cyan { BRIGHT_CYAN }
sub bright_white { BRIGHT_WHITE }

################################################################################
# BG COLOR
sub on_black { ON_BLACK }
sub on_red { ON_RED }
sub on_green { ON_GREEN }
sub on_yellow { ON_YELLOW }
sub on_blue { ON_BLUE }
sub on_magenta { ON_MAGENTA }
sub on_cyan { ON_CYAN }
sub on_white { ON_WHITE }
sub on_bright_black { ON_BRIGHT_BLACK }
sub on_bright_red { ON_BRIGHT_RED }
sub on_bright_green { ON_BRIGHT_GREEN }
sub on_bright_yellow { ON_BRIGHT_YELLOW }
sub on_bright_blue { ON_BRIGHT_BLUE }
sub on_bright_magenta { ON_BRIGHT_MAGENTA }
sub on_bright_cyan { ON_BRIGHT_CYAN }
sub on_bright_white { ON_BRIGHT_WHITE }

################################################################################
# :constants256

################################################################################
#  ANSI0 .. ANSI255
#  ON_ANSI0 .. ON_ANSI255
sub ansi { 
	my ($self,$dec)=@_; if (!defined $dec) { die ("NO ANSI[0-255] Color Defined") }
	my $chr=undef; if (!eval("\$chr = ANSI$dec; return 1")) { die $@ }; 
	$chr
}
sub on_ansi {
	my ($self,$dec)=@_; if (!defined $dec) { die ("NO ON_ANSI[0-255] Color Defined") }
	my $chr=undef; if (!eval("\$chr = ON_ANSI$dec; return 1")) { die $@ }
	$chr
}

################################################################################
#  GREY0 .. GREY23
#  ON_GREY0 .. ON_GREY23
sub grey {
	my ($self,$dec)=@_; if (!defined $dec) { die ("NO GREY[0-23] Color Defined") }
	my $chr;
	if (!eval("\$chr = GREY$dec; return 1")) { die $@ }
	$chr
}
sub on_grey {
	my ($self,$dec)=@_; if (!defined $dec) { die ("NO ON_GREY[0-23] Color Defined") }
	my $chr=undef; if (!eval("\$chr = ON_GREY$dec")) { die $@ }; 
	$chr 
}

################################################################################
#  RGBXYZ (for X, Y, and Z values from 0 to 5, like RGB000 or RGB515)
#  ON_RGBXYZ (for X, Y, and Z values from 0 to 5)
#  rgb(5,1,5) . on_rgb(1,5,1);
sub rgb {
  my ($self,$r,$g,$b)=@_; if (!defined $r || !defined $g || !defined $b) { die ("Colors [Blue,Green,Blue] Not Defined") }
  if ($r>6) {$r=5} if ($r<0) {$r=0}
  if ($g>6) {$g=5} if ($g<0) {$g=0}
  if ($b>6) {$b=5} if ($b<0) {$b=0}
  my $chr=undef;if (!eval("\$chr = RGB$r$g$b; return 1")) { die ($@) }
  $chr
}
sub on_rgb {
  my ($self,$r,$g,$b)=@_; if (!defined $r || !defined $g || !defined $b) { die ("Colors [Blue,Green,Blue] Not Defined") }
  if ($r>6) {$r=5} if ($r<0) {$r=0}
  if ($g>6) {$g=5} if ($g<0) {$g=0}
  if ($b>6) {$b=5} if ($b<0) {$b=0}
  my $chr=undef; if(!eval("\$chr = ON_RGB$r$g$b; return 1")){ die $@ }
  $chr
}

################################################################################
# EOF gterm::ansi (c) 2020 Demoro
################################################################################
1;
