
- `gterm/data/term.cntrl` :
```perl
{
#########################################################################
# ASCII HEX SEQUENCE ORDERED # Data File for gterm::cntrl.pm
#[INIT]#########################################################################
#;TABSZ=4
################################################################################
#   FULL ACSII CONTROL CODES
#########################################################################
################################################################################
# ANSI Escape sequences - VT100 / VT52 (ANSI Escape codes)
# ANSI Escape sequences  |  VT100 / VT52 ANSI escape sequences  |  VT100 User Guide
# This document describes how to control a VT100 terminal.
# ANSI escape sequence is a sequence of ASCII characters, the first two of which 
# are the ASCII "Escape" character 27 (1Bh) and the left-bracket character " [ " (5Bh). 
# The character or characters following the escape and left-bracket characters specify 
# an alphanumeric code that controls a keyboard or display function.
# Information is also available int the VT100 User Guide.
#########################################################################
####[name]######################################[char_sequence]############################[#HEX:.. ][SPACE     ][DEC[,DEC]][SPACE][ASCII|UNICODE][SPACE][ALT_NAMES][SPACE]:[SPACE][EXTRA_INFO                        ]##
#########################################################################

#########################################################################
# SPECIAL ESCAPE CODES
#########################################################################
#   call as dereffered function to create the string      like :                        my $chars = tc('cursor_move_up',lines)
#   call as function to create the string value           like :                        my $chars = tc('cursor_reset')
#########################################################################


#########################################################################
# TERMINAL CALL & RESPONSE
#########################################################################
    identify                                =>  "\e[c",                                 # Esc [ c                   #   Identify what terminal type                     : DA
    terminal_type                           =>  "\e[0c",                                # Esc [ 0 c                 #   Identify what terminal type (another)           : DA
#########################################################################
    terminal_type_response                  =>  sub {                                   # Esc [ ? 1 ; Value 0 c     #   Response: terminal type code n                  : DA
        if ($_[0] =~ /^\e\[\?1\;(.+)0c$/){ return $1 }
        return undef
    },                                                                                  
# TERMINAL RESPONSE CODES
    terminal_ok                             =>  "\e0n",                                 #1B:5B:30:6E                27, 91, 48, 110 n term_ok:dsr                       : [DSR][OK] Response: terminal is OK
    terminal_notok                          =>  "\e3n",                                 #1B:5B:33:6E                27, 91, 51, 110 n term_nook:dsr                     : [DSR][NOTOK] Response: terminal is NOT OK
#########################################################################
    terminal_identify                       =>  "\eZ",                                  # Esc Z                     #   Identify what the terminal is (VT52)            : ident
    terminal_vt52                           =>  "\e/Z",                                 # Esc / Z                   #   Correct response to ident (VT52)                : identresp
#########################################################################
    terminal_device_status_report           =>  "\e5n",                                 #1B:5B:35:6E                27, 91, 53, 110 n term_dsr                          : [DSR] Response: Device status report
#########################################################################

#########################################################################
    clear_buffers                           =>  "\e[3J",
#########################################################################
    tty_select                              =>  sub { echr("[12;".$_[0]."]") },
    tty_clear                               =>  "\e[1;1H\e[2J",
#########################################################################
    test_powerup                            =>  "\e[2;1y",                              # Esc [ 2 ; 1 y             #   Confidence power up test                        : DECTST
    repeat_powerup                          =>  "\e[2;9y",                              # Esc [ 2 ; 9 y             #   Repeat power up test                            : DECTST
#########################################################################
    test_loopback                           =>  "\e[2;2y",                              # Esc [ 2 ; 2 y             #   Confidence loopback test                        : DECTST
    repeat_loopback                         =>  "\e[2;10y",                             # Esc [ 2 ; 10 y            #   Repeat loopback test                            : DECTST
#########################################################################


#########################################################################
# CHARACTER SET CONTROL
#########################################################################
# Graphics ???? maar dan 1 of 3 bytes per sprite-pixel?
    graphic_g0_spec                         =>  "\e(0",                                 #1B:28:30              27, 40, 48 0 setspecg0                           : Set G0 special chars. & line set
    graphic_g0_alt                          =>  "\e(1",                                 #1B:28:31              27, 40, 49 1 setaltg0                            : Set G0 alternate character ROM
    graphic_g0_alt_spec                     =>  "\e(2",                                 #1B:28:32              27, 40, 50 2 setaltspecg0                        : Set G0 alt char ROM and spec. graphics
    graphic_g0_uk                           =>  "\e(A",                                 #1B:28:41              27, 40, 65 A setukg0                             : Set United Kingdom G0 character set
    graphic_g0_us                           =>  "\e(B",                                 #1B:28:42              27, 40, 66 B setusg0                             : Set United States G0 character set
#########################################################################
    graphic_g1_spec                         =>  "\e)0",                                 #1B:29:30              27, 41, 48 0 setspecg1                           : Set G1 special chars. & line set
    graphic_g1_alt                          =>  "\e)1",                                 #1B:29:32              27, 41, 49 1 setaltg1                            : Set G1 alternate character ROM
    graphic_g1_alt_spec                     =>  "\e)2",                                 #1B:29:33              27, 41, 50 2 setaltspecg1                        : Set G1 alt char ROM and spec. graphics
    graphic_g1_uk                           =>  "\e)A",                                 #1B:29:41              27, 41, 51 3 setukg1                             : Set United Kingdom G1 character set
    graphic_g1_us                           =>  "\e)B",                                 #1B:29:42              27, 41, 52 4 setusg1                             : Set United States G1 character set
#########################################################################
    character_set_gr                        =>  "\eF",                                  # Esc F             #   Use special graphics character set (VT52)       : setgr
    character_set_uk                        =>  "\eG",                                  # Esc G             #   Use normal US/UK character set (VT52)           : resetgr
#########################################################################

#########################################################################
# LINE FEED CONTROL
#########################################################################
    reverse_linefeed                        =>  "\eI",                                  # Esc I             #   Generate a reverse line-feed (VT52)             : revlinefeed
#########################################################################

#########################################################################
#########################################################################
# TERMINAL CONTROL
#########################################################################
#########################################################################


#########################################################################
#   Screen Resolutions:  ################################################################################################################################
#########################################################################
#   tc('enable_screen_mode',screen_mode])                                   #   Changes the screen width or type to the mode specified by one of the Screen resolution.
#   tc('disable_screen_mode',screen_mode])                                  #   Resets the mode by using the same values that Set Mode uses, except for 7, which disables line wrapping.
    set_screen_mode                         =>  sub { echr("[=".$_[0]."h")},            #1B:5B:3D:/[30-39:]+/:68                      27, 91, 61, [48-57]+, 104 h ssr   : [SSR] Set Screen resolution
    reset_screen_mode                       =>  sub { echr("[=".$_[0]."l")},            #1B:5B:3D:/[30-39:]+/:6C                      27, 91, 61, [48-57]+, 108 h resetscreenmode       : Reset Screen resolution
#########################################################################
    set_screen_0                            =>  "\e[=0h",                               #1B:5B:3D:30:68                      27, 91, 61, 48, 104 h ssr0                 : [SSR0] Set Screen resolution  0 =  40 x  25 2-color (text)
    reset_screen_0                          =>  "\e[=0l",                               #1B:5B:3D:30:6C                      27, 91, 61, 48, 104 l rsr0                 : [RSR0] Reset Screen resolution  0 =  40 x  25 2-color (text)
#########################################################################
    set_screen_1                            =>  "\e[=1h",                               #1B:5B:3D:31:68                      27, 91, 61, 49, 104 h ssr1                 : [SSR1] Set Screen resolution  1 =  40 x  25 16-color (text)
    reset_screen_1                          =>  "\e[=1l",                               #1B:5B:3D:31:6C                      27, 91, 61, 49, 104 l rsr1                 : [RSR1] Reset Screen resolution  1 =  40 x  25 16-color (text)
#########################################################################
    set_screen_13                           =>  "\e[=13h",                              #1B:5B:3D:31:33:68                   27, 91, 61, 55, 104 h ssr13                : [SSR13] Set Screen resolution 13 = 320 x 200 16-color (graphics)
    reset_screen_13                         =>  "\e[=13l",                              #1B:5B:3D:31:33:6C                   27, 91, 61, 55, 104 l rsr13                : [RSR13] Reset Screen resolution 13 = 320 x 200 16-color (graphics)
#########################################################################
    set_screen_14                           =>  "\e[=14h",                              #1B:5B:3D:31:34:68                   27, 91, 61, 56, 104 h ssr14                : [SSR14] Set Screen resolution 14 = 640 x 200 16-color (graphics)
    reset_screen_14                         =>  "\e[=14l",                              #1B:5B:3D:31:34:6C                   27, 91, 61, 56, 104 l rsr14                : [RSR14] Reset Screen resolution 14 = 640 x 200 16-color (graphics)
#########################################################################
    set_screen_15                           =>  "\e[=15h",                              #1B:5B:3D:31:35:68                   27, 91, 61, 57, 104 h ssr15                : [SSR15] Set Screen resolution 15 = 640 x 350 2-color (graphics)
    reset_screen_15                         =>  "\e[=15l",                              #1B:5B:3D:31:35:6C                   27, 91, 61, 57, 104 l rsr15                : [RSR15] Reset Screen resolution 15 = 640 x 350 2-color (graphics)
#########################################################################
    set_screen_16                           =>  "\e[=16h",                              #1B:5B:3D:31:36:68                   27, 91, 61, 58, 104 h ssr16                : [SSR16] Set Screen resolution 16 = 640 x 350 16-color (graphics)
    reset_screen_16                         =>  "\e[=16l",                              #1B:5B:3D:31:36:6C                   27, 91, 61, 58, 104 l rsr16                : [RSR16] Reset Screen resolution 16 = 640 x 350 16-color (graphics)
#########################################################################
    set_screen_17                           =>  "\e[=17h",                              #1B:5B:3D:31:37:68                   27, 91, 61, 59, 104 h ssr17                : [SSR17] Set Screen resolution 17 = 640 x 480 2-color (graphics)
    reset_screen_17                         =>  "\e[=17l",                              #1B:5B:3D:31:37:6C                   27, 91, 61, 59, 104 l rsr17                : [RSR17] Reset Screen resolution 17 = 640 x 480 2-color (graphics)
#########################################################################
    set_screen_18                           =>  "\e[=18h",                              #1B:5B:3D:31:38:68                   27, 91, 61, 60, 104 h ssr18                : [SSR18] Set Screen resolution 18 = 640 x 480 16-color (graphics)
    reset_screen_18                         =>  "\e[=18l",                              #1B:5B:3D:31:38:6C                   27, 91, 61, 60, 104 l rsr18                : [RSR18] Reset Screen resolution 18 = 640 x 480 16-color (graphics)
#########################################################################
    set_screen_19                           =>  "\e[=19h",                              #1B:5B:3D:31:39:68                   27, 91, 61, 61, 104 h ssr19                : [SSR19] Set Screen resolution 19 = 320 x 200 256-color (graphics)
    reset_screen_19                         =>  "\e[=19l",                              #1B:5B:3D:31:39:6C                   27, 91, 61, 61, 104 l rsr19                : [RSR19] Reset Screen resolution 19 = 320 x 200 256-color (graphics)
#########################################################################
    set_screen_2                            =>  "\e[=2h",                               #1B:5B:3D:32:68                      27, 91, 61, 50, 104 h ssr2                 : [SSR2] Set Screen resolution  2 =  80 x  25 2-color (text)
    reset_screen_2                          =>  "\e[=2l",                               #1B:5B:3D:32:6C                      27, 91, 61, 50, 104 l rsr2                 : [RSR2] Reset Screen resolution  2 =  80 x  25 2-color (text)
#########################################################################
    set_screen_3                            =>  "\e[=3h",                               #1B:5B:3D:33:68                      27, 91, 61, 51, 104 h ssr3                 : [SSR3] Set Screen resolution  3 =  80 x  25 16-color (text)
    reset_screen_3                          =>  "\e[=3l",                               #1B:5B:3D:33:6C                      27, 91, 61, 51, 104 l rsr3                 : [RSR3] Reset Screen resolution  3 =  80 x  25 16-color (text)
#########################################################################
    set_screen_4                            =>  "\e[=4h",                               #1B:5B:3D:34:68                      27, 91, 61, 52, 104 h ssr4                 : [SSR4] Set Screen resolution  4 = 320 x 200 4-color (graphics)
    reset_screen_4                          =>  "\e[=4l",                               #1B:5B:3D:34:6C                      27, 91, 61, 52, 104 l rsr4                 : [RSR4] Reset Screen resolution  4 = 320 x 200 4-color (graphics)
#########################################################################
    set_screen_5                            =>  "\e[=5h",                               #1B:5B:3D:35:68                      27, 91, 61, 53, 104 h ssr5                 : [SSR5] Set Screen resolution  5 = 320 x 200 2-color (graphics)
    reset_screen_5                          =>  "\e[=5l",                               #1B:5B:3D:35:6C                      27, 91, 61, 53, 104 l rsr5                 : [RSR5] Reset Screen resolution  5 = 320 x 200 2-color (graphics)
#########################################################################
    set_screen_6                            =>  "\e[=6h",                               #1B:5B:3D:36:68                      27, 91, 61, 54, 104 h ssr6                 : [SSR6] Set Screen resolution  6 = 640 x 200 2-color (graphics)
    reset_screen_6                          =>  "\e[=6l",                               #1B:5B:3D:36:6C                      27, 91, 61, 54, 104 l rsr6                 : [RSR6] Reset Screen resolution  6 = 640 x 200 2-color (graphics)
#########################################################################
    set_linewrap                            =>  "\e[=7h",                               #1B:5B:3D:36:68                      27, 91, 61, 54, 104 h slnwr                : Enables line wrapping
    reset_linewrap                          =>  "\e[=7j",                               #1B:5B:3D:36:6C                      27, 91, 61, 54, 104 l rlnwr                : Disables line wrapping
#########################################################################


#########################################################################
    esc_numeric_0                           =>  "\e#0",                                 #1B:23:30              27, 35, 48 0 esc0                                        : UNDEFINED
    esc_numeric_1                           =>  "\e#1",                                 #1B:23:31              27, 35, 49 1 esc1                                        : UNDEFINED
    esc_numeric_2                           =>  "\e#2",                                 #1B:23:32              27, 35, 50 2 esc2                                        : UNDEFINED
#########################################################################
    screen_set_double_top                   =>  "\e#3",                                 #1B:23:33              27, 35, 51 3 esc3:DECDHL                                 : Double-height letters, top half
    screen_set_double_bottom                =>  "\e#4",                                 #1B:23:34              27, 35, 52 4 esc4:DECDHL                                 : Double-height letters, bottom half
    screen_set_single                       =>  "\e#5",                                 #1B:23:35              27, 35, 53 5 esc5:DECSWL                                 : Single width, single height letters
    screen_set_double                       =>  "\e#6",                                 #1B:23:36              27, 35, 54 6 esc6:DECDWL                                 : Double width, single height letters
#########################################################################
    esc_numeric_7                           =>  "\e#7",                                 #1B:23:37              27, 35, 55 7 esc7                                        : UNDEFINED
#########################################################################
    screen_set_alignment                    =>  "\e#8",                                 #1B:23:38              27, 35, 56 8 esc8:DECALN                                 : Screen alignment display
#########################################################################
    esc_numeric_9                           =>  "\e#9",                                 #1B:23:39              27, 35, 57 9 esc9:                                       : UNDEFINED
#########################################################################
    ansi_level_1                            =>  "\e L",                                 # ESC SP L  Set ANSI conformance level 1, ECMA-43.
    ansi_level_2                            =>  "\e M",                                 # ESC SP M  Set ANSI conformance level 2, ECMA-43.
    ansi_level_3                            =>  "\e N",                                 # ESC SP N  Set ANSI conformance level 3, ECMA-43.
    character_set_default                   =>  "\e%@",                                 # ESC % @   Select default character set.  That is ISO 8859-1 (ISO 2022).
    character_set_utf8                      =>  "\e%G",                                 # ESC % G   Select UTF-8 character set, ISO 2022.
#########################################################################
    switch_ansi                             =>  "\e<",                                  #1B:3C                 27, 60 < switchansi                                      : [ALT][<] : Enter/exit ANSI mode (VT52)
#########################################################################
    clear_screen_begin                      =>  "\e[0J",                                #1B:5B:32:4A 1B:5B:48  27, 91, 32, 74 J clscreenbegin:clsb                      : [ED0] Erase Display Till Begin
    clear_screen_end                        =>  "\e[1J",                                #1B:5B:32:4A 1B:5B:48  27, 91, 32, 74 J clscreenend:clse                        : [ED1] Erase Display Till End
    clear_screen                            =>  "\e[2J",                                #1B:5B:32:4A 1B:5B:48  27, 91, 32, 74 J clscreen:cls                            : [ED2] Erase Display
#########################################################################
    clear_line_right                        =>  "\e[0K",                                #1B:5B:30:4B           27, 91, 75 K clslineleft:el0                             : [EL0] Clear line from cursor right
    clear_line_left                         =>  "\e[1K",                                #1B:5B:31:4B           27, 91, 49, 75 K clslineright:el1                        : [EL1] Clear line from cursor left
    clear_line                              =>  "\e[2K",                                #1B:5B:32:4B           27, 91, 50, 75 K clsline:el2                             : [EL2] Clear entire line
#########################################################################
    save_terminal                           =>  "\e[?1049h",                            #1B:5B:3F:31:30:34:39:68                                                        : [SCREEN][SAVE] Save & Clean Screen
    restore_terminal                        =>  "\e[?1049l",                            #1B:5B:3F:31:30:34:39:6C                                                        : [SCREEN][RESTORE] Restore Screen 
    reset_terminal                          =>  "\ec",                                  # Esc c                     #   Reset terminal to initial state                 : [RIS]
#########################################################################
    two_question_altesc                     =>  "\e[?2",                                #1B:5B:3F:32           27, 91, 63, 50 2 altescquestion2                         : [ALTESC][?][2]
    set_ansi                                =>  "\e[?2h",                               #1B:5B:3F:32:68        27, 91, 63, 50,104 h setansi                             : [DECANM] Set ANSI (versus VT52)
    set_vt52                                =>  "\e[?2l",                               #1B:5B:3F:32:6C        27, 91, 63, 50,108 l setlnfeedmode                       : [DECANM] Set VT52 (versus ANSI)
#########################################################################
    three_question_altesc                   =>  "\e[?3",                                #1B:5B:3F:33           27, 91, 63, 51 3 altescquestion3                         : [ALTESC][?][3]
#ESC [ ? 3 h
#DECCOLM (default off = 80 columns): 80/132 col mode switch. The driver sources note that this alone does not suffice; 
#some user-mode utility such as resizecons(8) has to change the hardware registers on the console video card.
    set_col_132                             =>  "\e[?3h",                               #1B:5B:3F:33:68        27, 91, 63, 51,104 h set132                              : [DECCOLM] Set number of columns to 132
    set_col_80                              =>  "\e[?3l",                               #1B:5B:3F:33:6C        27, 91, 63, 51,108 l set80                               : [DECCOLM] Set number of columns to 80
#########################################################################
    four_question_altesc                    =>  "\e[?4",                                #1B:5B:3F:34           27, 91, 63, 52 4 altescquestion4                         : [ALTESC][?][3]
    set_scroll_smooth                       =>  "\e[?4h",                               #1B:5B:3F:34:68        27, 91, 63, 52,104 h setscrollscmooth                    : [DECSCLM] Set smooth scrolling
    set_scroll_jump                         =>  "\e[?4l",                               #1B:5B:3F:34:6C        27, 91, 63, 52,108 l setscrolljump                       : [DECSCLM] Set jump scrolling
#########################################################################
    five_question_altesc                    =>  "\e[?5",                                #1B:5B:3F:35           27, 91, 63, 53 5 altescquestion5                         : [ALTESC][?][5]
#ESC [ ? 5 h
#DECSCNM (default off): Set reverse-video mode.
    set_video_reverse                       =>  "\e[?5h",                               #1B:5B:3F:35:68        27, 91, 63, 53,104 h setvideoreverse                     : [DECSCNM] Set reverse video on screen
    set_video_normal                        =>  "\e[?5l",                               #1B:5B:3F:35:6C        27, 91, 63, 53,108 l setvideonormal                      : [DECSCNM] Set normal video on screen
#########################################################################
    six_question_altesc                     =>  "\e[?6",                                #1B:5B:3F:36           27, 91, 63, 54 6 altescquestion6                         : [ALTESC][?][6]
#ESC [ ? 6 h
#DECOM (default off): When set, cursor addressing is relative to the upper left corner of the scrolling region.
    set_origin_relative                     =>  "\e[?6h",                               #1B:5B:3F:36:68        27, 91, 63, 54,104 h setoriginrelative                   : [DECOM] Set origin to relative
    set_origin_absolute                     =>  "\e[?6l",                               #1B:5B:3F:36:6C        27, 91, 63, 54,108 l setoriginabsolute                   : [DECOM] Set origin to absolute
#########################################################################
    seven_question_altesc                   =>  "\e[?7",                                #1B:5B:3F:37           27, 91, 63, 55 7 altescquestion7                         : [ALTESC][?][7]
#ESC [ ? 7 h
#DECAWM (default on): Set autowrap on. In this mode, a graphic character emitted after column 80 (or column 132 of DECCOLM is on) forces a wrap to the beginning of the following line first.
    set_auto_wrap                           =>  "\e[?7h",                               #1B:5B:3F:37:68        27, 91, 63, 55,104 h setautowrap                         : [DECAWM] Set auto-wrap mode
    reset_auto_wrap                         =>  "\e[?7l",                               #1B:5B:3F:37:6C        27, 91, 63, 55,108 h resetautowrap                       : [DECAWM] Reset auto-wrap mode
#########################################################################
    eight_question_altesc                   =>  "\e[?8",                                #1B:5B:3F:38           27, 91, 63, 56 8 altescquestion8                         : [ALTESC][?][8]
#ESC [ ? 8 h
#DECARM (default on): Set keyboard autorepeat on.
    set_auto_repeat                         =>  "\e[?8h",                               #1B:5B:3F:38:68        27, 91, 63, 56,104 h setautorepeat                       : [DECARM] Set auto-repeat mode
    reset_auto_repeat                       =>  "\e[?8l",                               #1B:5B:3F:38:6C        27, 91, 63, 56,108 h resetautorepeat                     : [DECARM] Reset auto-repeat mode
#########################################################################
    nine_question_altesc                    =>  "\e[?9",                                #1B:5B:3F:39           27, 91, 63, 57 9 altescquestion9                         : [ALTESC][?][9]
#########################################################################




#########################################################################
# WINDOW CONTROL
#########################################################################
    line_set                                =>  sub { echr("[".join(';',@_)."r") },     #1B:5B:/[30-39:]+/:3B:/[30-39:]+/:72          27, 91, [48-57,]+, 59, [48-57,]+, 114 r winlines  : [DECSTBM] Set top and bottom lines of a window
    line_up                                 =>  "\eD",      #??DOUBLE??                 #1B:44                 27, 68 D altD:mvlnup:ind                         : [IND] Move/scroll cursor/window up one line
    line_down                               =>  "\eE",                                  #1B:45                 27, 69 E altE:mdlndw:nel                         : [NEL] Move cursor/window to next line
#########################################################################



#########################################################################
# CURSOR CONTROL
#########################################################################
    cursor                                  =>  "\e6n",                                 #1B:5B:35:6E                                  27, 91, 53, 110 n cursorpos                       : [DSR] Response: Get cursor position
    cursor_at                               =>  sub {                                   #1B:[30-39:]+:3B:[30-39:]+:72                 27, 91, [48-57]+, 59, [48-57]+, 82                : [CPR] Response: cursor is at v,h
        if ($_[0] =~ /^\e([0-9]+)\;([0-9]+)R$/) { return ($1,$2) }
        return (undef,undef)
    },
#########################################################################
#ESC [ ? 25 h
#DECTECM (default on): Make cursor visible.
    cursor_show                             =>  "\e[?25h",
    cursor_hide                             =>  "\e[?25l",
#########################################################################
    cursor_save                             =>  "\e[s",                                 #1B:5B:73                                     27, 91, 115 s savecursor                          : Save Cursor Position
    cursor_restore                          =>  "\e[u",                                 #1B:5B:75                                     27, 91, 117 u restorecursor                       : Restore Cursor Position
#########################################################################
    cursor_home                             =>  "\e[H",                                 #1B:5B:48                                     27, 91, 72 H cursorhome                           : [CURSOR][HOME] Move cursor to upper left corner
    cursor_hvhome                           =>  "\e[f",                                 #1B:5B:66                                     27, 91, [48-57,]+, 59, [48-57,]+, 102 f cursorpos : [CURSOR][POSITION][Line;Column] Move cursor to upper left corner
    cursor_move                             =>  sub {                                   #1B:5B:/[30-39:]+/ Esc Line Column  (1 byte only?)  # cursormv(v,h)                             : [CURSOR][MOVETO][Line][Column] Move cursor to v,h location    (VT52)
        echr( '[' . ($_[0]+1) . ($_[1]+1) )
    },
    cursor_goto                             =>  sub {                                   #1B:5B:/[30-39:]+/ Esc Line Column  (1 byte only?)  # cursormv(v,h)                             : [CURSOR][GOTO][Line][Column] Move cursor to v,h location  (VT52)
        Term::Cap->Tgetent()->Tgoto("cm", @_)
    },
    cursor_set                              =>  sub {                                   #1B:5B:/[30-39:]+/:3B:/[30-39:]+/:48          27, 91, [48-57,]+, 59, [48-57,]+, 72 H setcursor  : [CURSOR][SET][Line;Column] CUP Move cursor to screen location v,h
        "\e[H".echr( '[' . ($_[0]) . ';' . ($_[1]) . "H" )
    },
    cursor_pos                              =>  sub {                                   #1B:5B:/[30-39:]+/:3B:/[30-39:]+/:66          27, 91, [48-57,]+, 59, [48-57,]+, 102 f cursorpos : [CURSOR][MOVE][Line;Column] [CUP] Move cursor to screen location v,h
        echr( '[' . ($_[1]+1) . ';' . ($_[0]+1) . "f" )
    },
#########################################################################
    cursor_save_attr                        =>  "\e7",                                  #1B:37                 27, 55 7 DECSC                                   : Save cursor position and attributes
    cursor_restore_attr                     =>  "\e8",                                  #1B:38                 27, 56 8 DECSC                                   : Restore cursor position and attributes
#########################################################################
    question_mark_altesc                    =>  "\e[?",                                 #1B:5B:3F              27, 91, 63 ? altescquestion                      : [ALTESC][?]
    one_question_altesc                     =>  "\e[?1",                                #1B:5B:3F:31           27, 91, 63, 48 1 altescquestion1                 : [ALTESC][?][1]
#ESC [ ? 1 h
#DECCKM (default off): When set, the cursor keys send an ESC O prefix, rather than ESC [.
    cursor_application                      =>  "\e[?1h",                               #1B:5B:3F:31:68        27, 91, 63, 49,104 h setnwlnmode                 : [DECCKM] Set cursor key to application
    cursor_reset                            =>  "\e[?1l",                               #1B:5B:3F:31:6C        27, 91, 63, 49,108 l setlnfeedmode               : [DECCKM] Reset cursor key to cursor
#########################################################################
    cursor_esc                              =>  "\e[O",                                 #1B:5B:4F              27, 91, 79 O arrow:cursor                        : [ALTESC][CURSOR]
#########################################################################


#########################################################################
# WINDOW TABULATION
    tab_set                                 =>  "\eH",                                  #1B:48                 27, 72 H altH:hts                                        : [HTS] Set a tab at the current column
    tab_clear                               =>  "\e[0g",                                # Esc [ 0 g     #   Clear a tab at the current column                           : [TBC]
    tab_clear_right                         =>  "\e[1g",                                # Esc [ 1 g     #   Clear a tab at the right of current column??                : [TBC]
    tab_clear_left                          =>  "\e[2g",                                # Esc [ 2 g     #   Clear a tab at the left of current column??                 : [TBC]
    tab_clear_all                           =>  "\e[3g",                                # Esc [ 3 g     #   Clear all tabs                                              : [TBC]
#########################################################################




#########################################################################
# PRINTER CONTROL
#########################################################################
    print_screen                            =>  "\e[i",                                 # Esc [ i                   #   Print the current screen                            : Print Screen
    print_line                              =>  "\e[1i",                                # Esc [ 1 i                 #   Print the current line                              : Print Line        
#########################################################################
    print_disable_log                       =>  "\e[4i",                                # Esc [ 4 i                 #   Disable log                                         : Stop Print Log    
    print_enable_log                        =>  "\e[5i",                                # Esc [ 5 i                 #   Start log; all received text is echoed to a printer : Start Print Log
##[?]####################################################################################################################################################
    set_new_line_mode                       =>  "\e[20h",                               #1B:5B:32:30:68        27, 91, 50, 30,104 h setnewlinemode                          : [LMN] Set new line mode
    set_line_feed_mode                      =>  "\e[20l",                               #1B:5B:32:30:6C        27, 91, 50, 30,108 l setlinefeedmode                         : [LMN] Set line feed mode
#########################################################################




#########################################################################
##[KEYBOARD_CONTROL_KEYS]################################################################################################################################
#########################################################################
    SHIFT                                   =>  ";2",                                   #3B:32(:7E)            59, 50(, 126) 2 shift                            : [SHIFT]
    SHIFT_altesc                            =>  "\e[1;2",                               #1B:5B:31:3B:32        27, 91, 49, 59, 50 2 altesc_shift                : [ESC][SHIFT]
#########################################################################
    ALT                                     =>  ";3",                                   #3B:33                 59, 51 3 alt                                     : [ALT]
    ALT_altesc                              =>  "\e[1;3",                               #1B:5B:31:3B:33        27, 91, 49, 51 3 altesc_alt                      : [ESC][ALT]
#########################################################################
    ALT_SHIFT                               =>  ";4",                                   #3B:34                 59, 52 4 altshift                                : [ALT][SHIFT] 
    ALT_SHIFT_altesc                        =>  "\e[1;4",                               #1B:5B:31:3B:34        27, 91, 49, 52 4 altesc_alt_shift                : [ESC][ALT][SHIFT]
#########################################################################
    CTRL                                    =>  ";5",                                   #3B:35                          59, 53 5 ctrl                           : [CTRL]
    CTRL_altesc                             =>  "\e[1;5",                               #1B:5B:31:3B:35        27, 91, 49, 53 5 altesc_ctrl                     : [ESC][CTRL]
#########################################################################
    CTRL_SHIFT                              =>  ";6",                                   #3B:36                          59, 54 6 ctrlshift                      : [CTRL][SHIFT] 
    CTRL_SHIFT_altesc                       =>  "\e[1;6",                               #1B:5B:31:3B:36        27, 91, 49, 54 6 ctrlshift                       : [ESC][CTRL][SHIFT]
#########################################################################
    CTRL_ALT                                =>  ";7",                                   #3B:37                          59, 55 7 ctrlalt                        : [CTRL][ALT] 
    CTRL_ALT_altesc                         =>  "\e[1;7",                               #1B:5B:31:3B:37        27, 91, 49, 54 7 ctrlshift                       : [ESC][CTRL][ALT]
#########################################################################
    CTRL_ALT_SHIFT                          =>  ";8",                                   #3B:38                          59, 56 8 ctrlaltshift                   : [CTRL][ALT][SHIFT]
    CTRL_ALT_SHIFT_altesc                   =>  "\e[1;8",                               #1B:5B:31:3B:38        27, 91, 49, 54 8 ctrlshift                       : [ESC][CTRL][ALT][SHIFT]
#########################################################################
    #F1                                     =>  "\e[1{CTRLKEY}P",                       #1B:5B:[31|4F:{CTRLHEX}]:50     27, 91, 49, 59, 50, 80 P shiff1         : ([CTRLKEY])[F1]
    #F2                                     =>  "\e[1{CTRLKEY}Q",                       #1B:5B:[31|4F:{CTRLHEX}]:51     27, 91, 49, 59, 50, 81 Q shiff2         : ([CTRLKEY])[F2]
    #F3                                     =>  "\e[1{CTRLKEY}R",                       #1B:5B:[31|4F:{CTRLHEX}]:52     27, 91, 49, 59, 50, 82 R shiff3         : ([CTRLKEY])[F3]
    #F4                                     =>  "\e[1{CTRLKEY}S",                       #1B:5B:[31|4F:{CTRLHEX}]:53     27, 91, 49, 59, 50, 83 S shiff4         : ([CTRLKEY])[F4]
#########################################################################
    F5                                      =>  "15~",                                  #31:35                 49, 53 5 function5                               : [F5]
    F6                                      =>  "17~",                                  #31:37                 49, 54 7 function6                               : [F6]
    F7                                      =>  "18~",                                  #31:38                 49, 55 8 function7                               : [F7]
    F8                                      =>  "19~",                                  #31:39                 49, 56 9 function8                               : [F8]
#########################################################################
    F9                                      =>  "20~",                                  #32:30                 50, 48 0 function9                               : [F9]
    F10                                     =>  "21~",                                  #32:31                 50, 49 1 function10                              : [F10]
    F11                                     =>  "22~",                                  #32:32                 50, 50 2 function11                              : [F11]
    F12                                     =>  "23~",                                  #32:33                 50, 51 3 function12                              : [F12]
#########################################################################



#########################################################################
# [CURSOR][ARROW][UP]
    up                                      =>  "\eA",                                  # Esc A                     #   Move cursor up one line (VT52)          : [CURSOR][UP]
    move_up                                 =>  sub { echr("[".$_[0]."A") },            #1B:5B:/[30-39:]+:41                          27, 91, 30-39{3} A cuu    : [CUU] Move cursor up n lines
    shift_up                                =>  "\e[1;2A",                              #1B:5B:31:3B:32:41     27, 91, 49, 59, 50, 65 A shiftarrowup            : [SHIFT][CURSOR][UP]
    alt_up                                  =>  "\e[1;3A",                              #1B:5B:31:3B:33:41     27, 91, 49, 59, 51, 65 A altup                   : [ALT][CURSOR][UP]
    alt_shift_up                            =>  "\e[1;4A",                              #1B:5B:31:3B:34:41     27, 91, 49, 59, 52, 65 A altshiftup              : [ALT][SHIFT][CURSOR][UP]
    ctrl_up                                 =>  "\e[1;5A",                              #1B:5B:31:3B:35:41     27, 91, 49, 59, 53, 65 A ctrlup                  : [CTRL][CURSOR][UP]
    ctrl_shift_up                           =>  "\e[1;6A",                              #1B:5B:31:3B:35:41     27, 91, 49, 59, 54, 65 A ctrlshifup              : [CTRL][SHIFT][UP]
    reset_up                                =>  "\e[A",                                 #1B:5B:41              27, 91, 65 A arrupreset                          : [RESET][CURSOR][UP]
    set_up                                  =>  "\e[OA",                                #1B:5B:4F:41           27, 91, 79, 65 A up                              : [CURSOR][UP]
#########################################################################

#########################################################################
# [CURSOR][ARROW][DOWN]
    down                                    =>  "\eB",                                  # Esc B                     #   Move cursor down one line (VT52)        : [CURSOR][DOWN]
    move_down                               =>  sub { echr("[".$_[0]."B") },            #1B:5B:/[30-39:]+:42                          27, 91, 30-39{3} B cud    : [CUD] Move cursor down n lines
    shift_down                              =>  "\e[1;2B",                              #1B:5B:31:3B:32:42     27, 91, 49, 59, 50, 66 B shiftarrowdown          : [SHIFT][CURSOR][DOWN]
    alt_down                                =>  "\e[1;3B",                              #1B:5B:31:3B:33:42     27, 91, 49, 59, 51, 66 B altdown                 : [ALT][CURSOR][DOWN]
    alt_shift_down                          =>  "\e[1;4B",                              #1B:5B:31:3B:34:42     27, 91, 49, 59, 52, 66 B altshiftdw              : [ALT][SHIFT][CURSOR][DOWN]
    ctrl_down                               =>  "\e[1;5B",                              #1B:5B:31:3B:35:42     27, 91, 49, 59, 53, 66 B ctrldw                  : [CTRL][CURSOR][DOWN]
    ctrl_shift_down                         =>  "\e[1;6B",                              #1B:5B:31:3B:35:42     27, 91, 49, 59, 54, 66 B ctrlshifdown            : [CTRL][SHIFT][DOWN]
    reset_down                              =>  "\e[B",                                 #1B:5B:42              27, 91, 66 B arrdownreset                        : [RESET][CURSOR][DOWN]
    set_down                                =>  "\e[OB",                                #1B:5B:4F:42           27, 91, 79, 66 B down                            : [CURSOR][DOWN]
#########################################################################

#########################################################################
# [CURSOR][ARROW][RIGHT]
    right                                   =>  "\eC",                                  # Esc C                     #   Move cursor right one char (VT52)       : [CURSOR][RIGHT]
    move_right                              =>  sub { echr("[".$_[0]."C") },            #1B:5B:/[30-39:]+:43                          27, 91, 30-39{3} C cuf    : [CUF] Move cursor right n lines
    shift_right                             =>  "\e[1;2C",                              #1B:5B:31:3B:32:43     27, 91, 49, 59, 50, 67 C shiftarrowright         : [SHIFT][CURSOR][RIGHT]
    alt_right                               =>  "\e[1;3C",                              #1B:5B:31:3B:33:43     27, 91, 49, 59, 51, 67 C altright                : [ALT][CURSOR][RIGHT]
    alt_shift_right                         =>  "\e[1;4C",                              #1B:5B:31:3B:34:43     27, 91, 49, 59, 52, 67 C altshiftr               : [ALT][SHIFT][CURSOR][RIGHT]
    ctrl_right                              =>  "\e[1;5C",                              #1B:5B:31:3B:35:43     27, 91, 49, 59, 53, 67 C ctrlr                   : [CTRL][CURSOR][RIGHT]
    ctrl_shift_right                        =>  "\e[1;6C",                              #1B:5B:31:3B:35:43     27, 91, 49, 59, 54, 67 C ctrlshifright           : [CTRL][SHIFT][RIGHT]
    reset_right                             =>  "\e[C",                                 #1B:5B:43              27, 91, 67 C arrrightreset                       : [RESET][CURSOR][RIGHT]
    set_right                               =>  "\e[OC",                                #1B:5B:4F:43           27, 91, 79, 67 C right                           : [CURSOR][RIGHT]
#########################################################################

#########################################################################
# [CURSOR][ARROW][LEFT]
    left                                    =>  "\eD",  # Also window_line_up ??        # Esc D                     #   Move cursor left one char (VT52)        : [CURSOR][LEFT]
    move_left                               =>  sub { echr("[".$_[0]."D") },            #1B:5B:/[30-39:]+:44                          27, 91, 30-39{3} D cub    : [CUB] Move cursor left n lines
    shift_left                              =>  "\e[1;2D",                              #1B:5B:31:3B:32:44     27, 91, 49, 59, 50, 68 D shiftarrowleft          : [SHIFT][CURSOR][LEFT]
    alt_left                                =>  "\e[1;3D",                              #1B:5B:31:3B:33:44     27, 91, 49, 59, 51, 68 D altleft                 : [ALT][CURSOR][LEFT]
    alt_shift_left                          =>  "\e[1;4D",                              #1B:5B:31:3B:34:44     27, 91, 49, 59, 52, 68 D altshiftl               : [ALT][SHIFT][CURSOR][LEFT]
    ctrl_left                               =>  "\e[1;5D",                              #1B:5B:31:3B:35:44     27, 91, 49, 59, 53, 68 D ctrll                   : [CTRL][CURSOR][LEFT]
    ctrl_shift_left                         =>  "\e[1;6D",                              #1B:5B:31:3B:35:44     27, 91, 49, 59, 54, 68 D ctrlshifleft            : [CTRL][SHIFT][LEFT]
    reset_left                              =>  "\e[D",                                 #1B:5B:44              27, 91, 68 D arrleftreset                        : [RESET][CURSOR][LEFT]
    set_left                                =>  "\e[OD",                                #1B:5B:4F:44           27, 91, 79, 68 D left                            : [CURSOR][LEFT]
#########################################################################

#########################################################################
# [END] button
    end                                     =>  "\eOF",                                 #1B:4F:46              27, 79, 70 F escf:end                            : [END]
    end_shift                               =>  "\e[1;2F",                              #1B:5B:31:3B:32:46     27, 91, 49, 59, 50, 70 F shiftend                : [SHIFT][END]
    end_alt                                 =>  "\e[1;3F",                              #1B:5B:31:3B:33:46     27, 91, 49, 59, 51, 70 F altend                  : [ALT][END]
    end_alt_shift                           =>  "\e[1;4F",                              #1B:5B:31:3B:34:46     27, 91, 49, 59, 52, 70 F altshiftend             : [ALT][SHIFT][END]
    end_ctrl                                =>  "\e[1;5F",                              #1B:5B:31:3B:35:46     27, 91, 49, 59, 53, 70 F ctrlend                 : [CTRL][END]
    end_ctrl_shift                          =>  "\e[1;6F",                              #1B:5B:31:3B:36:46     27, 91, 49, 59, 54, 70 F ctrlshiftend            : [CTRL][SHIFT][END]
    end_ctrl_alt                            =>  "\e[1;7F",                              #1B:5B:31:3B:37:46     27, 91, 49, 59, 55, 70 F ctrlaltend              : [CTRL][ALT][END]
    end_ctrl_alt_shift                      =>  "\e[1;8F",                              #1B:5B:31:3B:38:46     27, 91, 49, 59, 56, 70 F ctrlaltshiftend         : [CTRL][ALT][SHIFT][END]
#########################################################################

#########################################################################
# [HOME] button
    home                                    =>  "\eOH",                                 #1B:4F:48              27, 79, 72 H esch:home                           : [HOME]
    home_shift                              =>  "\e[1;2H",                              #1B:5B:31:3B:32:48     27, 91, 49, 59, 50, 70 F shifthome               : [SHIFT][HOME]
    home_alt                                =>  "\e[1;3H",                              #1B:5B:31:3B:33:48     27, 91, 49, 59, 51, 70 F althome                 : [ALT][HOME]
    home_alt_shift                          =>  "\e[1;4H",                              #1B:5B:31:3B:34:48     27, 91, 49, 59, 52, 70 F altshifthome            : [ALT][SHIFT][HOME]
    home_ctrl                               =>  "\e[1;5H",                              #1B:5B:31:3B:35:48     27, 91, 49, 59, 53, 70 F ctrlhome                : [CTRL][HOME]
    home_ctrl_shift                         =>  "\e[1;6H",                              #1B:5B:31:3B:36:48     27, 91, 49, 59, 54, 70 F ctrlshifthome           : [CTRL][SHIFT][HOME]
    home_ctrl_alt                           =>  "\e[1;7H",                              #1B:5B:31:3B:37:48     27, 91, 49, 59, 55, 70 F ctrlalthome             : [CTRL][ALT][HOME]
    home_ctrl_alt_shift                     =>  "\e[1;8H",                              #1B:5B:31:3B:38:48     27, 91, 49, 59, 56, 70 F ctrlaltshifthome        : [CTRL][ALT][SHIFT][HOME]
#########################################################################

################################################################################
#   Code        SHIFT+code  CTRL+code   ALT+code        Key
################################################################################
#   0;59        0;84        0;94        0;104           F1  
#########################################################################
# [F1] button
    f1                                      =>  "\eOP",                                 #1B:4F:50              27, 79, 80 P escop:PF1:f1                        : [F1]
    shift_f1                                =>  "\e[1;2P",                              #1B:5B:31:3B:32:50     27, 91, 49, 59, 50, 80 P shiff1                  : [SHIFT][F1]
    alt_f1                                  =>  "\e[1;3P",                              #1B:5B:31:3B:33:50     27, 91, 49, 59, 51, 80 P altf1                   : [ALT][F1]
    alt_shift_f1                            =>  "\e[1;4P",                              #1B:5B:31:3B:34:50     27, 91, 49, 59, 52, 80 P altshiftf1              : [ALT][SHIFT][F1]
    ctrl_f1                                 =>  "\e[1;5P",                              #1B:5B:31:3B:35:50     27, 91, 49, 59, 53, 80 P altshiftf1              : [CTRL][F1]
    ctrl_shift_f1                           =>  "\e[1;6P",                              #1B:5B:31:3B:36:50     27, 91, 49, 59, 54, 80 P ctrlshiftf1             : [CTRL][SHIFT][F1]
    ctrl_alt_shift_f1                       =>  "\e[1;8P",                              #1B:5B:31:3B:37:50     27, 91, 49, 59, 56, 80 P ctrlaltshiftf1          : [CTLR][ALT][SHIFT][F1]
    ctrl_alt_f1                             =>  "\e[1;7P",                              #1B:5B:31:3B:37:50     27, 91, 49, 59, 55, 80 P ctrlaltf1               : [CTLR][ALT][F1]
#########################################################################

################################################################################
#   Code        SHIFT+code  CTRL+code   ALT+code        Key
################################################################################
#   0;60        0;85        0;95        0;105           F2  
#########################################################################
# [F2] button
    f2                                      =>  "\eOQ",                                 #1B:4F:51              27, 79, 81 Q escoq:PF2:f2                        : [F2]
    shift_f2                                =>  "\e[1;2Q",                              #1B:5B:31:3B:32:51     27, 91, 49, 59, 50, 81 Q shiff2                  : [SHIFT][F2]
    alt_f2                                  =>  "\e[1;3Q",                              #1B:5B:31:3B:33:51     27, 91, 49, 59, 51, 81 Q altf2                   : [ALT][F2]
    alt_shift_f2                            =>  "\e[1;4Q",                              #1B:5B:31:3B:34:51     27, 91, 49, 59, 52, 81 Q altshiftf2              : [ALT][SHIFT][F2]
    ctrl_f2                                 =>  "\e[1;5Q",                              #1B:5B:31:3B:35:51     27, 91, 49, 59, 53, 81 Q altshiftf2              : [CTRL][F2]
    ctrl_shift_f2                           =>  "\e[1;6Q",                              #1B:5B:31:3B:36:51     27, 91, 49, 59, 54, 81 Q ctrlshiftf2             : [CTRL][SHIFT][F2]
    ctrl_alt_shift_f2                       =>  "\e[1;8Q",                              #1B:5B:31:3B:38:51     27, 91, 49, 59, 56, 81 Q ctrlaltshiftf2          : [CTLR][ALT][SHIFT][F2]
    ctrl_alt_f2                             =>  "\e[1;7Q",                              #1B:5B:31:3B:37:51     27, 91, 49, 59, 55, 81 Q ctrlaltf2               : [CTLR][ALT][F1]
#########################################################################

################################################################################
#   Code        SHIFT+code  CTRL+code   ALT+code        Key
################################################################################
#   0;61        0;86        0;96        0;106           F3  
#########################################################################
# [F3] button
    f3                                      =>  "\eOR",                                 #1B:4F:52              27, 79, 82 R escor:PF3:f3                        : [F3]
    shift_f3                                =>  "\e[1;2R",                              #1B:5B:31:3B:32:52     27, 91, 49, 59, 50, 82 R shiff3                  : [SHIFT][F3]
    alt_f3                                  =>  "\e[1;3R",                              #1B:5B:31:3B:33:52     27, 91, 49, 59, 51, 82 R altf3                   : [ALT][F3]
    alt_shift_f3                            =>  "\e[1;4R",                              #1B:5B:31:3B:34:52     27, 91, 49, 59, 52, 82 R altshiftf3              : [ALT][SHIFT][F3]
    ctrl_f3                                 =>  "\e[1;5R",                              #1B:5B:31:3B:35:52     27, 91, 49, 59, 53, 82 R altshiftf3              : [CTRL][F3]
    ctrl_shift_f3                           =>  "\e[1;6R",                              #1B:5B:31:3B:36:52     27, 91, 49, 59, 54, 82 R ctrlshiftf3             : [CTRL][SHIFT][F3]
    ctrl_alt_shift_f3                       =>  "\e[1;7R",                              #1B:5B:31:3B:37:52     27, 91, 49, 59, 56, 82 R ctrlaltshiftf3          : [CTLR][ALT][SHIFT][F3]
    ctrl_alt_f3                             =>  "\e[1;7R",                              #1B:5B:31:3B:37:52     27, 91, 49, 59, 55, 82 Q ctrlaltf3               : [CTLR][ALT][F1]
#########################################################################

################################################################################
#   Code        SHIFT+code  CTRL+code   ALT+code        Key
################################################################################
#   0;62        0;87        0;97        0;107           F4  
#########################################################################
# [F4] button
    f4                                      =>  "\eOS",                                 #1B:4F:53              27, 79, 83 S escos:PF4:f4                        : [F4]
    shift_f4                                =>  "\e[1;2S",                              #1B:5B:31:3B:32:53     27, 91, 49, 59, 50, 83 Q shiff4                  : [SHIFT][F4]
    alt_f4                                  =>  "\e[1;3S",                              #1B:5B:31:3B:33:53     27, 91, 49, 59, 51, 83 S altf4                   : [ALT][F4]
    alt_shift_f4                            =>  "\e[1;4S",                              #1B:5B:31:3B:34:53     27, 91, 49, 59, 52, 83 S altshiftf4              : [ALT][SHIFT][F4]
    ctrl_f4                                 =>  "\e[1;5S",                              #1B:5B:31:3B:35:53     27, 91, 49, 59, 53, 83 S ctrlf4                  : [CTRL][F4]
    ctrl_shift_f4                           =>  "\e[1;6S",                              #1B:5B:31:3B:36:53     27, 91, 49, 59, 54, 83 S ctrlshiftf4             : [CTRL][SHIFT][F4]
    ctrl_alt_shift_f4                       =>  "\e[1;8S",                              #1B:5B:31:3B:38:53     27, 91, 49, 59, 56, 83 S ctrlaltshiftf4          : [CTLR][ALT][SHIFT][F4]
    ctrl_alt_f4                             =>  "\e[1;7S",                              #1B:5B:31:3B:37:53     27, 91, 49, 59, 55, 83 S ctrlaltf4               : [CTRL][ALT][F4]
#########################################################################

################################################################################
#   Code        SHIFT+code  CTRL+code   ALT+code        Key
################################################################################
#   0;63        0;88        0;98        0;108           F5  
#########################################################################
# [F5] button
    f5                                      =>  "\e[15~",                               #1B:5B:31:35:7E        27, 91, 49, 53, 126
    shift_f5                                =>  "\e[15;2~",                             #1B:5B:31:35:3B:32:7E  27, 91, 49, 53, 59, 50, 126
    alt_f5                                  =>  "\e[15;3~",                             #1B:5B:31:35:3B:33:7E  27, 91, 49, 53, 59, 51, 126
    alt_shift_f5                            =>  "\e[15;4~",                             #1B:5B:31:35:3B:34:7E  27, 91, 49, 53, 59, 52, 126
    ctrl_f5                                 =>  "\e[15;5~",                             #1B:5B:31:35:3B:35:7E  27, 91, 49, 53, 59, 53, 126
    ctrl_shift_f5                           =>  "\e[15;6~",                             #1B:5B:31:35:3B:36:7E  27, 91, 49, 53, 59, 54, 126
    ctrl_alt_f5                             =>  "\e[15;7~",                             #1B:5B:31:35:3B:37:7E  27, 91, 49, 53, 59, 55, 126
    ctrl_alt_shift_f5                       =>  "\e[15;8~",                             #1B:5B:31:35:3B:38:7E  27, 91, 49, 53, 59, 56, 126
#########################################################################

################################################################################
#   Code        SHIFT+code  CTRL+code   ALT+code        Key
################################################################################
#   0;64        0;89        0;99        0;109           F6  
#########################################################################
# [F6] button
    f6                                      =>  "\e[17~",                               #1B:5B:31:37:7E        27, 91, 49, 55, 126
    shift_f6                                =>  "\e[17;2~",                             #1B:5B:31:37:3B:32:7E  27, 91, 49, 55, 59, 50, 126
    alt_f6                                  =>  "\e[17;3~",                             #1B:5B:31:37:3B:33:7E  27, 91, 49, 55, 59, 51, 126
    alt_shift_f6                            =>  "\e[17;4~",                             #1B:5B:31:37:3B:34:7E  27, 91, 49, 55, 59, 52, 126
    ctrl_f6                                 =>  "\e[17;5~",                             #1B:5B:31:37:3B:35:7E  27, 91, 49, 55, 59, 53, 126
    ctrl_shift_f6                           =>  "\e[17;6~",                             #1B:5B:31:37:3B:36:7E  27, 91, 49, 55, 59, 54, 126
    ctrl_alt_f6                             =>  "\e[17;7~",                             #1B:5B:31:37:3B:37:7E  27, 91, 49, 55, 59, 55, 126
    ctrl_alt_shift_f6                       =>  "\e[17;8~",                             #1B:5B:31:37:3B:38:7E  27, 91, 49, 55, 59, 56, 126
#########################################################################

################################################################################
#   Code        SHIFT+code  CTRL+code   ALT+code        Key
################################################################################
#   0;65        0;90        0;100       0;110           F7  
#########################################################################
# [F7] button
    f7                                      =>  "\e[18~",                               #1B:5B:31:38:7E        27, 91, 49, 56, 126
    shift_f7                                =>  "\e[18;2~",                             #1B:5B:31:38:3B:32:7E  27, 91, 49, 56, 59, 50, 126
    alt_f7                                  =>  "\e[18;3~",                             #1B:5B:31:38:3B:33:7E  27, 91, 49, 56, 59, 51, 126
    alt_shift_f7                            =>  "\e[18;4~",                             #1B:5B:31:38:3B:34:7E  27, 91, 49, 56, 59, 52, 126
    ctrl_f7                                 =>  "\e[18;5~",                             #1B:5B:31:38:3B:35:7E  27, 91, 49, 56, 59, 53, 126
    ctrl_shift_f7                           =>  "\e[18;6~",                             #1B:5B:31:38:3B:36:7E  27, 91, 49, 56, 59, 54, 126
    ctrl_alt_f7                             =>  "\e[18;7~",                             #1B:5B:31:38:3B:37:7E  27, 91, 49, 56, 59, 55, 126
    ctrl_alt_shift_f7                       =>  "\e[18;8~",                             #1B:5B:31:38:3B:38:7E  27, 91, 49, 56, 59, 56, 126
#########################################################################

################################################################################
#   Code        SHIFT+code  CTRL+code   ALT+code        Key
################################################################################
#   0;66        0;91        0;101       0;111           F8  
#########################################################################
# [F8] button
    f8                                      =>  "\e[19~",                               #1B:5B:31:39:7E        27, 91, 49, 57, 126
    shift_f8                                =>  "\e[19;2~",                             #1B:5B:31:39:3B:32:7E  27, 91, 49, 56, 57, 50, 126
    alt_f8                                  =>  "\e[19;3~",                             #1B:5B:31:39:3B:33:7E  27, 91, 49, 56, 57, 51, 126
    alt_shift_f8                            =>  "\e[19;4~",                             #1B:5B:31:39:3B:34:7E  27, 91, 49, 56, 57, 52, 126
    ctrl_f8                                 =>  "\e[19;5~",                             #1B:5B:31:39:3B:35:7E  27, 91, 49, 56, 57, 53, 126
    ctrl_shift_f8                           =>  "\e[19;6~",                             #1B:5B:31:39:3B:36:7E  27, 91, 49, 56, 57, 54, 126
    ctrl_alt_f8                             =>  "\e[19;7~",                             #1B:5B:31:39:3B:37:7E  27, 91, 49, 56, 57, 55, 126
    ctrl_alt_shift_f8                       =>  "\e[19;8~",                             #1B:5B:31:39:3B:38:7E  27, 91, 49, 56, 57, 56, 126
#########################################################################

################################################################################
#   Code        SHIFT+code  CTRL+code   ALT+code        Key
################################################################################
#   0;67        0;92        0;102       0;112           F9  
#########################################################################
# [F9] button
    f9                                      =>  "\e[20~",                               #1B:5B:32:30:7E        27, 91, 50, 48, 126
    shift_f9                                =>  "\e[20;2~",                             #1B:5B:32:30:3B:32:7E  27, 91, 50, 48, 57, 50, 126
    alt_f9                                  =>  "\e[20;3~",                             #1B:5B:32:30:3B:33:7E  27, 91, 50, 48, 57, 51, 126
    alt_shift_f9                            =>  "\e[20;4~",                             #1B:5B:32:30:3B:34:7E  27, 91, 50, 48, 57, 52, 126
    ctrl_f9                                 =>  "\e[20;5~",                             #1B:5B:32:30:3B:35:7E  27, 91, 50, 48, 57, 53, 126
    ctrl_shift_f9                           =>  "\e[20;6~",                             #1B:5B:32:30:3B:36:7E  27, 91, 50, 48, 57, 54, 126
    ctrl_alt_f9                             =>  "\e[20;7~",                             #1B:5B:32:30:3B:37:7E  27, 91, 50, 48, 57, 55, 126
    ctrl_alt_shift_f9                       =>  "\e[20;8~",                             #1B:5B:32:30:3B:38:7E  27, 91, 50, 48, 57, 56, 126
#########################################################################

################################################################################
#   Code        SHIFT+code  CTRL+code   ALT+code        Key
################################################################################
#   0;68        0;93        0;103       0;113           F10 
#########################################################################
# [F10] button
    f10                                     =>  "\e[21~",                               #1B:5B:32:31:7E        27, 91, 50, 49, 126
    shift_f10                               =>  "\e[21;2~",                             #1B:5B:32:31:3B:32:7E  27, 91, 50, 49, 57, 50, 126
    alt_f10                                 =>  "\e[21;3~",                             #1B:5B:32:31:3B:33:7E  27, 91, 50, 49, 57, 51, 126
    alt_shift_f10                           =>  "\e[21;4~",                             #1B:5B:32:31:3B:34:7E  27, 91, 50, 49, 57, 52, 126
    ctrl_f10                                =>  "\e[21;5~",                             #1B:5B:32:31:3B:35:7E  27, 91, 50, 49, 57, 53, 126
    ctrl_shift_f10                          =>  "\e[21;6~",                             #1B:5B:32:31:3B:36:7E  27, 91, 50, 49, 57, 54, 126
    ctrl_alt_f10                            =>  "\e[21;7~",                             #1B:5B:32:31:3B:37:7E  27, 91, 50, 49, 57, 55, 126
    ctrl_alt_shift_f10                      =>  "\e[21;8~",                             #1B:5B:32:31:3B:38:7E  27, 91, 50, 49, 57, 56, 126
#########################################################################

################################################################################
#   Code        SHIFT+code  CTRL+code   ALT+code        Key
################################################################################
#   0;133       0;135       0;137       0;139           F11 
#########################################################################
# [F11] button
    f11                                     =>  "\e[23~",                               #1B:5B:32:33:7E        27, 91, 50, 51, 126
    shift_f11                               =>  "\e[23;2~",                             #1B:5B:32:33:3B:32:7E  27, 91, 50, 51, 57, 50, 126
    alt_f11                                 =>  "\e[23;3~",                             #1B:5B:32:33:3B:33:7E  27, 91, 50, 51, 57, 51, 126
    alt_shift_f11                           =>  "\e[23;4~",                             #1B:5B:32:33:3B:34:7E  27, 91, 50, 51, 57, 52, 126
    ctrl_f11                                =>  "\e[23;5~",                             #1B:5B:32:33:3B:35:7E  27, 91, 50, 51, 57, 53, 126
    ctrl_shift_f11                          =>  "\e[23;6~",                             #1B:5B:32:33:3B:36:7E  27, 91, 50, 51, 57, 54, 126
    ctrl_alt_f11                            =>  "\e[23;7~",                             #1B:5B:32:33:3B:37:7E  27, 91, 50, 51, 57, 55, 126
    ctrl_alt_shift_f11                      =>  "\e[23;8~",                             #1B:5B:32:33:3B:38:7E  27, 91, 50, 51, 57, 56, 126
#########################################################################

################################################################################
#   Code        SHIFT+code  CTRL+code   ALT+code        Key
################################################################################
#   0;134       0;136       0;138       0;140           F12 
#########################################################################
# [F12] button
    f12                                     =>  "\e[24~",                               #1B:5B:32:34:7E        27, 91, 50, 52, 126
    shift_f12                               =>  "\e[24;2~",                             #1B:5B:32:34:3B:32:7E  27, 91, 50, 52, 57, 50, 126
    alt_f12                                 =>  "\e[24;3~",                             #1B:5B:32:34:3B:33:7E  27, 91, 50, 52, 57, 51, 126
    alt_shift_f12                           =>  "\e[24;4~",                             #1B:5B:32:34:3B:34:7E  27, 91, 50, 52, 57, 52, 126
    ctrl_f12                                =>  "\e[24;5~",                             #1B:5B:32:34:3B:35:7E  27, 91, 50, 52, 57, 53, 126
    ctrl_shift_f12                          =>  "\e[24;6~",                             #1B:5B:32:34:3B:36:7E  27, 91, 50, 52, 57, 54, 126
    ctrl_alt_f12                            =>  "\e[24;7~",                             #1B:5B:32:34:3B:37:7E  27, 91, 50, 52, 57, 55, 126
    ctrl_alt_shift_f12                      =>  "\e[24;8~",                             #1B:5B:32:34:3B:38:7E  27, 91, 50, 52, 57, 56, 126
#########################################################################

#########################################################################
# [INS] button
    ins                                     =>  "\e[2~",                                #1B:5B:32:7E           27, 91, 50, 126 ~ ins                            : [INS]
    shift_ins                               =>  "\e[2;2~",                              #1B:5B:32:3B:32:7E     27, 91, 50, 59, 50,126 ~ shifins                 : [SHIFT][INS]
    alt_ins                                 =>  "\e[2;3~",                              #1B:5B:32:3B:33:7E     27, 91, 50, 59, 51,126 ~ altins                  : [ALT][INS]
    alt_shift_ins                           =>  "\e[2;4~",                              #1B:5B:32:3B:34:7E     27, 91, 50, 59, 52,126 ~ altshiftins             : [ALT][SHIFT][INS]
    ctrl_ins                                =>  "\e[2;5~",                              #1B:5B:32:3B:35:7E     27, 91, 50, 59, 53,126 ~ ctrlins                 : [CTRL][INS]
    ctrl_shift_ins                          =>  "\e[2;6~",                              #1B:5B:32:3B:36:7E     27, 91, 50, 59, 54,126 ~ ctrlshiftins            : [CTRL][SHIFT][INS]
    ctrl_alt_ins                            =>  "\e[2;7~",                              #1B:5B:32:3B:37:7E     27, 91, 50, 59, 55,126 ~ ctrlaltins              : [CTLR][ALT][INS]
    ctrl_alt_shift_ins                      =>  "\e[2;8~",                              #1B:5B:32:3B:38:7E     27, 91, 50, 59, 56,126 ~ ctrlaltshiftins         : [CTLR][ALT][SHIFT][INS]
#########################################################################

#########################################################################
# [DEL] button
    del                                     =>  "\e[3~",                                #1B:5B:33:7E           27, 91, 51,126 ~ del                             : [DEL]
    shift_del                               =>  "\e[3;2~",                              #1B:5B:33:3B:32:7E     27, 91, 51, 59, 50,126 ~ shiftdel                : [SHIFT][DEL]
    alt_del                                 =>  "\e[3;3~",                              #1B:5B:33:3B:33:7E     27, 91, 51, 59, 51,126 ~ altdel                  : [ALT][DEL]
    alt_shift_del                           =>  "\e[3;4~",                              #1B:5B:33:3B:34:7E     27, 91, 51, 59, 52,126 ~ altshiftdel             : [ALT][SHIFT][DEL]
    ctrl_del                                =>  "\e[3;5~",                              #1B:5B:33:3B:35:7E     27, 91, 51, 59, 53,126 ~ ctrldel                 : [CTRL][DEL]
    ctrl_shift_del                          =>  "\e[3;6~",                              #1B:5B:33:3B:36:7E     27, 91, 51, 59, 54,126 ~ ctrlshiftdel            : [CTRL][SHIFT][DEL]
    ctrl_alt_del                            =>  "\e[3;7~",                              #1B:5B:33:3B:37:7E     27, 91, 51, 59, 55,126 ~ ctrlaltdel              : [CTLR][ALT][DEL]
    ctrl_alt_shift_del                      =>  "\e[3;8~",                              #1B:5B:33:3B:38:7E     27, 91, 51, 59, 56,126 ~ ctrlaltshiftdel         : [CTLR][ALT][SHIFT][DEL]
#########################################################################

#########################################################################
# [PGUP] button
    page_up                                 =>  "\e[5~",                                #1B:5B:35:7E           27, 91, 53,126 ~ pgup                            : [PGUP]
    shift_page_up                           =>  "\e[5;2~",                              #1B:5B:35:3B:32:7E     27, 91, 53, 59, 50,126 ~ shiftpgup               : [SHIFT][PGUP]
    alt_page_up                             =>  "\e[5;3~",                              #1B:5B:35:3B:33:7E     27, 91, 53, 59, 51,126 ~ altpgup                 : [ALT][PGUP]
    alt_shift_page_up                       =>  "\e[5;4~",                              #1B:5B:35:3B:34:7E     27, 91, 53, 59, 52,126 ~ altshiftpgup            : [ALT][SHIFT][PGUP]
    ctrl_page_up                            =>  "\e[5;5~",                              #1B:5B:35:3B:35:7E     27, 91, 53, 59, 53,126 ~ ctrlpgup                : [CTRL][PGUP]
    ctrl_shift_page_up                      =>  "\e[5;6~",                              #1B:5B:35:3B:36:7E     27, 91, 53, 59, 54,126 ~ ctrlshiftpgup           : [CTRL][SHIFT][PGUP]
    ctrl_alt_page_up                        =>  "\e[5;7~",                              #1B:5B:35:3B:37:7E     27, 91, 53, 59, 55,126 ~ ctrlaltpgup             : [CTRL][ALT][PGUP]
    ctrl_alt_shift_page_up                  =>  "\e[5;8~",                              #1B:5B:35:3B:38:7E     27, 91, 53, 59, 56,126 ~ ctrlaltshiftpgup        : [CTLR][ALT][SHIFT][PGUP]
#########################################################################

#########################################################################
# [PGDW] button
    page_down                               =>  "\e[6~",                                #1B:5B:36:7E           27, 91, 54,126 ~ pgdw                            : [PGDW]
    shift_page_down                         =>  "\e[6;2~",                              #1B:5B:36:3B:32:7E     27, 91, 54, 59, 50,126 ~ shiftpgdw               : [SHIFT][PGDW]
    alt_page_down                           =>  "\e[6;3~",                              #1B:5B:36:3B:33:7E     27, 91, 54, 59, 51,126 ~ altpgdw                 : [ALT][PGDW]
    alt_shift_page_down                     =>  "\e[6;4~",                              #1B:5B:36:3B:34:7E     27, 91, 54, 59, 52,126 ~ altshiftpgdw            : [ALT][SHIFT][PGDW]
    ctrl_page_down                          =>  "\e[6;5~",                              #1B:5B:36:3B:35:7E     27, 91, 54, 59, 53,126 ~ ctrlpgdw                : [CTRL][PGDW]
    ctrl_shift_page_down                    =>  "\e[6;6~",                              #1B:5B:36:3B:36:7E     27, 91, 54, 59, 54,126 ~ ctrlshiftpgdw           : [CTRL][SHIFT][PGDW]
    ctrl_alt_page_down_                     =>  "\e[6;7~",                              #1B:5B:36:3B:37:7E     27, 91, 54, 59, 55,126 ~ ctrlaltpgdw             : [CTRL][ALT][PGDW]
    ctrl_alt_shift_page_down                =>  "\e[6;8~",                              #1B:5B:36:3B:38:7E     27, 91, 54, 59, 56,126 ~ ctrlaltshiftpgdw        : [CTLR][ALT][SHIFT][PGDW]
#########################################################################


#########################################################################
##[MOUSE]################################################################################################################################################
#########################################################################
    mouse_on                                =>  "\e[?1000;1006;1015h",                            #1B:5B:3F:31:30:30:33:68  27, 91, 63, 48, 48, 51,104 h openmouse        : [MOUSE][OPEN] Mouse Console Stream Open
    mouse_off                               =>  "\e[?1000;1006;1015l",                            #1B:5B:3F:31:30:30:33:6C  27, 91, 63, 48, 48, 51,108 h closemouse       : [MOUSE][CLOSE] Mouse Console Stream Close
#ESC [ ? 9 h
#X10 Mouse Reporting (default off): Set reporting mode to 1 (or reset to 0)---see below.
    mouse_x10_on                            =>  "\e[?9h",                               #1B:5B:3F:39:68        27, 91, 63, 57,104 h setinterlacing              : [DECINLM] Set interlacing mode
    mouse_x10_off                           =>  "\e[?9l",                               #1B:5B:3F:39:6C        27, 91, 63, 57,108 h resetinterlacing            : [DECINLM] Reset interlacing mode
#ESC [ ? 1000 h
#X11 Mouse Reporting (default off): Set reporting mode to 2 (or reset to 0)---see below.
    mouse_x11_on                            =>  "\e[?1000h",                            #1B:5B:3F:31:30:30:33:68  27, 91, 63, 48, 48, 51,104 h openmouse        : [MOUSE][OPEN] Mouse Console Stream Open
    mouse_x11_off                           =>  "\e[?1000l",                            #1B:5B:3F:31:30:30:33:6C  27, 91, 63, 48, 48, 51,108 h closemouse       : [MOUSE][CLOSE] Mouse Console Stream Close
    mouse_x01_on                            =>  "\e[?1001h",
    mouse_x01_off                           =>  "\e[?1001l",
    mouse_x02_on                            =>  "\e[?1002h",
    mouse_x02_off                           =>  "\e[?1002l",
    mouse_x03_on                            =>  "\e[?1003h",                            #1B:5B:3F:31:30:30:33:68  27, 91, 63, 48, 48, 51,104 h openmouse        : [MOUSE][OPEN] Mouse Console Stream Open
    mouse_x03_off                           =>  "\e[?1003l",                            #1B:5B:3F:31:30:30:33:6C  27, 91, 63, 48, 48, 51,108 h closemouse       : [MOUSE][CLOSE] Mouse Console Stream Close
    mouse_x04_on                            =>  "\e[?1004h",
    mouse_x04_off                           =>  "\e[?1004l",
    mouse_x05_on                            =>  "\e[?1005h",
    mouse_x05_off                           =>  "\e[?1005l",
    mouse_x06_on                            =>  "\e[?1006h",
    mouse_x06_off                           =>  "\e[?1006l",
    mouse_x07_on                            =>  "\e[?1007h",
    mouse_x07_off                           =>  "\e[?1007l",
    mouse_x08_on                            =>  "\e[?1008h",
    mouse_x08_off                           =>  "\e[?1008l",
    mouse_x09_on                            =>  "\e[?1009h",
    mouse_x09_off                           =>  "\e[?1009l",
    mouse_x10_on                            =>  "\e[?1010h",
    mouse_x10_off                           =>  "\e[?1010l",
    mouse_x11_on                            =>  "\e[?1011h",
    mouse_x11_off                           =>  "\e[?1011l",
    mouse_x12_on                            =>  "\e[?1012h",
    mouse_x12_off                           =>  "\e[?1012l",
    mouse_x13_on                            =>  "\e[?1013h",
    mouse_x13_off                           =>  "\e[?1013l",
    mouse_x14_on                            =>  "\e[?1014h",
    mouse_x14_off                           =>  "\e[?1014l",
    mouse_x15_on                            =>  "\e[?1015h",
    mouse_x15_off                           =>  "\e[?1015l",
#########################################################################
    mouse_decode                             =>  sub { 
        return $_[0] =~ /^.\[\<([0-9]+)\;([0-9]+)\;([0-9]+)([mM]{1})$/ || $_[0] =~ /^\^\[\[\<([0-9]+)\;([0-9]+)\;([0-9]+)([mM]{1})$/ ? ($1,$2,$3,$4) : undef 
    },
#########################################################################
    mouse_event                            => sub {
        my ($code,$col,$row,$mode)=tc('mouse_decode',$_[0]);
        if (defined $mode && $mode =~ /m/gsi) {
               if ($code ==  0) { return ('left_'.($mode eq 'M' ? 'down' : 'up'),$col,$row) }
            elsif ($code ==  1) { return ('middle_'.($mode eq 'M' ? 'down' : 'up'),$col,$row) }
            elsif ($code ==  2) { return ('right_'.($mode eq 'M' ? 'down' : 'up'),$col,$row) }
            elsif ($code ==  3) { return ('button_'.($mode eq 'M' ? 'down' : 'up'),$col,$row) }
            elsif ($code ==  4) { return ('shift_left_'.($mode eq 'M' ? 'down' : 'up'),$col,$row) }
            elsif ($code ==  5) { return ('shift_middle_'.($mode eq 'M' ? 'down' : 'up'),$col,$row) }
            elsif ($code ==  6) { return ('shift_right_'.($mode eq 'M' ? 'down' : 'up'),$col,$row) }
            elsif ($code ==  7) { return ('shift_button_'.($mode eq 'M' ? 'down' : 'up'),$col,$row) }
            elsif ($code ==  8) { return ('alt_left_'.($mode eq 'M' ? 'down' : 'up'),$col,$row) }
            elsif ($code ==  9) { return ('alt_middle_'.($mode eq 'M' ? 'down' : 'up'),$col,$row) }
            elsif ($code == 10) { return ('alt_right_'.($mode eq 'M' ? 'down' : 'up'),$col,$row) }
            elsif ($code == 11) { return ('alt_button_'.($mode eq 'M' ? 'down' : 'up'),$col,$row) }
            elsif ($code == 12) { return ('alt_shift_left_'.($mode eq 'M' ? 'down' : 'up'),$col,$row) }
            elsif ($code == 13) { return ('alt_shift_middle_'.($mode eq 'M' ? 'down' : 'up'),$col,$row) }
            elsif ($code == 14) { return ('alt_shift_right_'.($mode eq 'M' ? 'down' : 'up'),$col,$row) }
            elsif ($code == 15) { return ('alt_shift_button_'.($mode eq 'M' ? 'down' : 'up'),$col,$row) }
            elsif ($code == 16) { return ('ctrl_left_'.($mode eq 'M' ? 'down' : 'up'),$col,$row) }
            elsif ($code == 17) { return ('ctrl_middle_'.($mode eq 'M' ? 'down' : 'up'),$col,$row) }
            elsif ($code == 18) { return ('ctrl_right_'.($mode eq 'M' ? 'down' : 'up'),$col,$row) }
            elsif ($code == 19) { return ('ctrl_button_'.($mode eq 'M' ? 'down' : 'up'),$col,$row) }
            elsif ($code == 20) { return ('ctrl_shift_left_'.($mode eq 'M' ? 'down' : 'up'),$col,$row) }
            elsif ($code == 21) { return ('ctrl_shift_middle_'.($mode eq 'M' ? 'down' : 'up'),$col,$row) }
            elsif ($code == 22) { return ('ctrl_shift_right_'.($mode eq 'M' ? 'down' : 'up'),$col,$row) }
            elsif ($code == 23) { return ('ctrl_shift_button_'.($mode eq 'M' ? 'down' : 'up'),$col,$row) }
            elsif ($code == 24) { return ('ctrl_alt_left_'.($mode eq 'M' ? 'down' : 'up'),$col,$row) }
            elsif ($code == 25) { return ('ctrl_alt_middle_'.($mode eq 'M' ? 'down' : 'up'),$col,$row) }
            elsif ($code == 26) { return ('ctrl_alt_right_'.($mode eq 'M' ? 'down' : 'up'),$col,$row) }
            elsif ($code == 27) { return ('ctrl_alt_button_'.($mode eq 'M' ? 'down' : 'up'),$col,$row) }
            elsif ($code == 28) { return ('ctrl_alt_shift_left_'.($mode eq 'M' ? 'down' : 'up'),$col,$row) }
            elsif ($code == 29) { return ('ctrl_alt_shift_middle_'.($mode eq 'M' ? 'down' : 'up'),$col,$row) }
            elsif ($code == 30) { return ('ctrl_alt_shift_right_'.($mode eq 'M' ? 'down' : 'up'),$col,$row) }
            elsif ($code == 31) { return ('ctrl_alt_shift_button_'.($mode eq 'M' ? 'down' : 'up'),$col,$row) }
            elsif ($code == 32) { return ('left_drag',$col,$row) }
            elsif ($code == 33) { return ('middle_drag',$col,$row) }
            elsif ($code == 34) { return ('right_drag',$col,$row) }
            elsif ($code == 35) { return ('mouse_move',$col,$row) }
            elsif ($code == 36) { return ('shift_left_drag',$col,$row) }
            elsif ($code == 37) { return ('shift_middle_drag',$col,$row) }
            elsif ($code == 38) { return ('shift_right_drag',$col,$row) }
            elsif ($code == 39) { return ('shift_mouse_move',$col,$row) }
            elsif ($code == 40) { return ('alt_left_drag',$col,$row) }
            elsif ($code == 41) { return ('alt_middle_drag',$col,$row) }
            elsif ($code == 42) { return ('alt_right_drag',$col,$row) }
            elsif ($code == 43) { return ('alt_mouse_move',$col,$row) }
            elsif ($code == 44) { return ('alt_shift_left_drag',$col,$row) }
            elsif ($code == 45) { return ('alt_shift_middle_drag',$col,$row) }
            elsif ($code == 46) { return ('alt_shift_right_drag',$col,$row) }
            elsif ($code == 47) { return ('alt_shift_mouse_move',$col,$row) }
            elsif ($code == 48) { return ('ctrl_left_drag',$col,$row) }
            elsif ($code == 49) { return ('ctrl_middle_drag',$col,$row) }
            elsif ($code == 50) { return ('ctrl_right_drag',$col,$row) }
            elsif ($code == 51) { return ('ctrl_mouse_move',$col,$row) }
            elsif ($code == 52) { return ('ctrl_shift_left_drag',$col,$row) }
            elsif ($code == 53) { return ('ctrl_shift_middle_drag',$col,$row) }
            elsif ($code == 54) { return ('ctrl_shift_right_drag',$col,$row) }
            elsif ($code == 55) { return ('ctrl_shift_mouse_move',$col,$row) }
            elsif ($code == 56) { return ('ctrl_alt_left_drag',$col,$row) }
            elsif ($code == 57) { return ('ctrl_alt_middle_drag',$col,$row) }
            elsif ($code == 58) { return ('ctrl_alt_right_drag',$col,$row) }
            elsif ($code == 59) { return ('ctrl_alt_mouse_move',$col,$row) }
            elsif ($code == 60) { return ('ctrl_alt_shift_left_drag',$col,$row) }
            elsif ($code == 61) { return ('ctrl_alt_shift_middle_drag',$col,$row) }
            elsif ($code == 62) { return ('ctrl_alt_shift_right_drag',$col,$row) }
            elsif ($code == 63) { return ('ctrl_alt_shift_mouse_move',$col,$row) }
            elsif ($code == 64) { return ('wheel_up',$col,$row) }
            elsif ($code == 65) { return ('wheel_down',$col,$row) }
            elsif ($code == 66) { return ('_wheel_up',$col,$row) }
            elsif ($code == 67) { return ('_wheel_down',$col,$row) }
            elsif ($code == 68) { return ('shift_wheel_up',$col,$row) }
            elsif ($code == 69) { return ('shift_wheel_down',$col,$row) }
            elsif ($code == 70) { return ('__wheel_up',$col,$row) }
            elsif ($code == 71) { return ('__wheel_down',$col,$row) }
            # 72-79 ??
            elsif ($code == 72) { return ('mouse_72',$col,$row) }
            elsif ($code == 73) { return ('mouse_73',$col,$row) }
            elsif ($code == 74) { return ('mouse_74',$col,$row) }
            elsif ($code == 75) { return ('mouse_75',$col,$row) }
            elsif ($code == 76) { return ('mouse_76',$col,$row) }
            elsif ($code == 77) { return ('mouse_77',$col,$row) }
            elsif ($code == 78) { return ('mouse_78',$col,$row) }
            elsif ($code == 79) { return ('mouse_79',$col,$row) }
            #
            elsif ($code == 80) { return ('ctrl_wheel_up',$col,$row) }
            elsif ($code == 81) { return ('ctrl_wheel_down',$col,$row) }
            elsif ($code == 82) { return ('ctrl__wheel_up',$col,$row) }
            elsif ($code == 83) { return ('ctrl__wheel_down',$col,$row) }
            elsif ($code == 84) { return ('ctrl_shift_wheel_up',$col,$row) }
            elsif ($code == 85) { return ('ctrl_shift_wheel_down',$col,$row) }
            elsif ($code == 86) { return ('___wheel_up',$col,$row) }
            elsif ($code == 87) { return ('___wheel_down',$col,$row) }
        }
        return undef
    },
#########################################################################
    altesc_mouse                            =>  "\e[M",                                 #1B:5B:4D              27, 91, 77 M mouseevent                          : [ALTESC][MOUSE]
#########################################################################
    left_down                               =>  "\e[M ",                                #1B:5B:4D:20(:col:row) 27, 91, 77, 32  ldw                             : [LEFT][DOWN]
    middle_down                             =>  "\e[M!",                                #1B:5B:4D:21(:col:row) 27, 91, 77, 33 ! mdw                             : [MIDDLE][DOWN]
    right_down                              =>  "\e[M\"",                               #1B:5B:4D:22(:col:row) 27, 91, 77, 34 " rdw                             : [RIGHT][DOWN]
    mouse_up                                =>  "\e[M#",                                #1B:5B:4D:23(:col:row) 27, 91, 77, 35 # mup                             : [MOUSE][UP]
#########################################################################
    ctrl_left_down                          =>  "\e[M0",                                #1B:5B:4D:30(:col:row) 27, 91, 77, 48 0 ctrlldw                         : [CTRL][LEFT][DOWN]
    ctrl_middle_down                        =>  "\e[M1",                                #1B:5B:4D:31(:col:row) 27, 91, 77, 49 1 ctrlmdw                         : [CTRL][MIDDLE][DOWN]
    ctrl_right_down                         =>  "\e[M2",                                #1B:5B:4D:32(:col:row) 27, 91, 77, 50 2 ctrlrdw                         : [CTRL][RIGHT][DOWN]
    ctrl_mouse_up                           =>  "\e[M3",                                #1B:5B:4D:33(:col:row) 27, 91, 77, 51 3 ctrlmup                         : [CTRL][MOUSE][UP]
#########################################################################
    ctrl_shift_left_down                    =>  "\e[M4",                                #1B:5B:4D:34(:col:row) 27, 91, 77, 52 4 ctrlshiftldw                    : [CTRL][SHIFT][LEFT][DOWN]
    ctrl_shift_middle_down                  =>  "\e[M5",                                #1B:5B:4D:35(:col:row) 27, 91, 77, 53 5 ctrlshiftmdw                    : [CTRL][SHIFT][MIDDLE][DOWN]
    ctrl_shift_right_down                   =>  "\e[M6",                                #1B:5B:4D:36(:col:row) 27, 91, 77, 54 6 ctrlshiftrdw                    : [CTRL][SHIFT][RIGHT][DOWN]
    ctrl_shift_mouse_up                     =>  "\e[M7",                                #1B:5B:4D:37(:col:row) 27, 91, 77, 55 7 ctrlshiftmup                    : [CTRL][SHIFT][MOUSE][UP]
#########################################################################
    ctrl_alt_left_down                      =>  "\e[M8",                                #1B:5B:4D:38(:col:row) 27, 91, 77, 56 8 ctrlaltldw                      : [CTRL][ALT][LEFT][DOWN]
    ctrl_alt_middle_down                    =>  "\e[M9",                                #1B:5B:4D:39(:col:row) 27, 91, 77, 57 9 ctrlaltmdw                      : [CTRL][ALT][MIDDLE][DOWN]
    ctrl_alt_right_down                     =>  "\e[M:",                                #1B:5B:4D:3A(:col:row) 27, 91, 77, 58 : ctrlaltrdw                      : [CTRL][ALT][RIGHT][DOWN]
    ctrl_alt_mouse_up                       =>  "\e[M;",                                #1B:5B:4D:3B(:col:row) 27, 91, 77, 59 ; ctrlaltmup                      : [CTRL][ALT][MOUSE][UP]
#########################################################################
    ctrl_alt_shift_left_down                =>  "\e[M<",                                #1B:5B:4D:3C(:col:row) 27, 91, 77, 60 < ctrlaltshiftldw                 : [CTRL][ALT][SHIFT][LEFT][DOWN]
    ctrl_alt_shift_middle_down              =>  "\e[M=",                                #1B:5B:4D:3D(:col:row) 27, 91, 77, 61 = ctrlaltshiftmdw                 : [CTRL][ALT][SHIFT][MIDDLE][DOWN]
    ctrl_alt_shift_right_down               =>  "\e[M>",                                #1B:5B:4D:3E(:col:row) 27, 91, 77, 62 > ctrlaltshiftrdw                 : [CTRL][ALT][SHIFT][RIGHT][DOWN]
    ctrl_alt_shift_mouse_up                 =>  "\e[M?",                                #1B:5B:4D:3F(:col:row) 27, 91, 77, 63 ? ctrlaltshiftmup                 : [CTRL][ALT][SHIFT][MOUSE][UP]
#########################################################################
    left_drag                               =>  "\e[M\@",                               #1B:5B:4D:40(:col:row) 27, 91, 77, 64 @ ldr                             : [LEFT][DRAG]
    middle_drag                             =>  "\e[MA",                                #1B:5B:4D:41(:col:row) 27, 91, 77, 65 A mdr                             : [MIDDLE][DRAG]
    right_drag                              =>  "\e[MB",                                #1B:5B:4D:42(:col:row) 27, 91, 77, 66 B rdr                             : [RIGHT][DRAG]
    mouse_move                              =>  "\e[MC",                                #1B:5B:4D:43(:col:row) 27, 91, 77, 67 C mmv                             : [MOUSE][MOVE]
#########################################################################
    shift_left_drag                         =>  "\e[MD",                                #1B:5B:4D:46(:col:row) 27, 91, 77, 68 D shiftldr                        : [SHIFT][LEFT][DRAG]
    shift_middle_drag                       =>  "\e[ME",                                #1B:5B:4D:47(:col:row) 27, 91, 77, 69 E shiftmdr                        : [SHIFT][MIDDLE][DRAG]
    shift_right_drag                        =>  "\e[MF",                                #1B:5B:4D:48(:col:row) 27, 91, 77, 70 F shiftrdr                        : [SHIFT][RIGHT][DRAG]
    shift_mouse_move                        =>  "\e[MG",                                #1B:5B:4D:49(:col:row) 27, 91, 77, 71 G shiftmmv                        : [SHIFT][MOUSE][MOVE]
#########################################################################
    alt_left_drag                           =>  "\e[MH",                                #1B:5B:4D:48(:col:row) 27, 91, 77, 72 H altldr                          : [ALT][LEFT][DRAG]
    alt_middle_drag                         =>  "\e[MI",                                #1B:5B:4D:49(:col:row) 27, 91, 77, 73 I altmdr                          : [ALT][MIDDLE][DRAG]
    alt_right_drag                          =>  "\e[MJ",                                #1B:5B:4D:4A(:col:row) 27, 91, 77, 74 J altrdr                          : [ALT][RIGHT][DRAG]
    alt_mouse_move                          =>  "\e[MK",                                #1B:5B:4D:4B(:col:row) 27, 91, 77, 75 K altmmv                          : [ALT][MOUSE][MOVE]
#########################################################################
    alt_shift_left_drag                     =>  "\e[ML",                                #1B:5B:4D:4C(:col:row) 27, 91, 77, 76 L altshiftldr                     : [ALT][SHIFT][LEFT][DRAG]
    alt_shift_middle_drag                   =>  "\e[MM",                                #1B:5B:4D:4D(:col:row) 27, 91, 77, 77 M altshiftmdr                     : [ALT][SHIFT][MIDDLE][DRAG]
    alt_shift_right_drag                    =>  "\e[MN",                                #1B:5B:4D:4E(:col:row) 27, 91, 77, 78 N altshiftrdr                     : [ALT][SHIFT][RIGHT][DRAG]
    alt_shift_mouse_move                    =>  "\e[MO",                                #1B:5B:4D:4F(:col:row) 27, 91, 77, 79 O altshiftmmv                     : [ALT][SHIFT][MOUSE][MOVE]
#########################################################################
    ctrl_left_drag                          =>  "\e[MP",                                #1B:5B:4D:50(:col:row) 27, 91, 77, 80 P ctrlldr                         : [CTRL][LEFT][DRAG]
    ctrl_middle_drag                        =>  "\e[MQ",                                #1B:5B:4D:51(:col:row) 27, 91, 77, 81 Q ctrlmdr                         : [CTRL][MIDDLE][DRAG]
    ctrl_right_drag                         =>  "\e[MR",                                #1B:5B:4D:52(:col:row) 27, 91, 77, 82 R ctrlrdr                         : [CTRL][RIGHT][DRAG]
    ctrl_mouse_move                         =>  "\e[MS",                                #1B:5B:4D:53(:col:row) 27, 91, 77, 83 S ctrlmmv                         : [CTRL][MOUSE][MOVE]
#########################################################################
    ctrl_shift_left_drag                    =>  "\e[MT",                                #1B:5B:4D:54(:col:row) 27, 91, 77, 84 T ctrlshiftldr                    : [CTRL][SHIFT][LEFT][DRAG]
    ctrl_shift_middle_drag                  =>  "\e[MU",                                #1B:5B:4D:55(:col:row) 27, 91, 77, 85 U ctrlshiftmdr                    : [CTRL][SHIFT][MIDDLE][DRAG]
    ctrl_shift_right_drag                   =>  "\e[MV",                                #1B:5B:4D:56(:col:row) 27, 91, 77, 86 V ctrlshiftrdr                    : [CTRL][SHIFT][RIGHT][DRAG]
    ctrl_shift_mouse_move                   =>  "\e[MW",                                #1B:5B:4D:57(:col:row) 27, 91, 77, 87 W ctrlshiftmmv                    : [CTRL][SHIFT][MOUSE][MOVE]
#########################################################################
    ctrl_alt_left_drag                      =>  "\e[MX",                                #1B:5B:4D:58(:col:row) 27, 91, 77, 88 X ctrlaltldr                      : [CTRL][ALT][LEFT][DRAG]
    ctrl_alt_middle_drag                    =>  "\e[MY",                                #1B:5B:4D:59(:col:row) 27, 91, 77, 89 Y ctrlaltmdr                      : [CTRL][ALT][MIDDLE][DRAG]
    ctrl_alt_right_drag                     =>  "\e[MZ",                                #1B:5B:4D:5A(:col:row) 27, 91, 77, 90 Z ctrlaltrdr                      : [CTRL][ALT][RIGHT][DRAG]
    ctrl_alt_mouse_move                     =>  "\e[M[",                                #1B:5B:4D:5B(:col:row) 27, 91, 77, 91 [ ctrlaltmmv                      : [CTRL][ALT][MOUSE][MOVE]
#########################################################################
    ctrl_alt_shift_left_drag                =>  "\e[M\\",                               #1B:5B:4D:5C(:col:row) 27, 91, 77, 92 \ ctrlaltshiftldr                 : [CTRL][ALT][SHIFT][LEFT][DRAG]
    ctrl_alt_shift_middle_drag              =>  "\e[M]",                                #1B:5B:4D:5D(:col:row) 27, 91, 77, 93 ] ctrlaltshiftmdr                 : [CTRL][ALT][SHIFT][MIDDLE][DRAG]
    ctrl_alt_shift_right_drag               =>  "\e[M^",                                #1B:5B:4D:5E(:col:row) 27, 91, 77, 94 ^ ctrlaltshiftrdr                 : [CTRL][ALT][SHIFT][RIGHT][DRAG]
    ctrl_alt_shift_mouse_move               =>  "\e[M_",                                #1B:5B:4D:5F(:col:row) 27, 91, 77, 95 _ ctrlaltshiftmmv                 : [CTRL][ALT][SHIFT][MOUSE][MOVE]
#########################################################################
    wheel_up                                =>  "\e[M`",                                #1B:5B:4D:60(:col:row) 27, 91, 77, 96 ` scrollup:wheelup                : [WHEEL][UP]
    wheel_down                              =>  "\e[Ma",                                #1B:5B:4D:61(:col:row) 27, 91, 77, 97 a scrolldw:wheeldw                : [WHEEL][DOWN]
#########################################################################
    shift_wheel_up                          =>  "\e[Me",                                #1B:5B:4D:65(:col:row) 27, 91, 77,101 e shiftwheelup:shiftscrollup      : [SHIFT][WHEEL][UP]
    shift_wheel_down                        =>  "\e[Mf",                                #1B:5B:4D:66(:col:row) 27, 91, 77,102 f shiftwheeldw:shiftscrolldw      : [SHIFT][WHEEL][DOWN]
#########################################################################
    ctrl_wheel_up                           =>  "\e[Mp",                                #1B:5B:4D:70(:col:row) 27, 91, 77,112 p ctrlwheelup:ctrlscrollup        : [CTRL][WHEEL][UP]
    ctrl_wheel_down                         =>  "\e[Mq",                                #1B:5B:4D:71(:col:row) 27, 91, 77,113 q ctrlwheeldw:ctrlscrolldw        : [CTRL][WHEEL][DOWN]
#########################################################################
    ctrl_shift_wheel_up                     =>  "\e[Mu",                                #1B:5B:4D:70(:col:row) 27, 91, 77,116 u 
    ctrl_shift_wheel_down                   =>  "\e[Mv",                                #1B:5B:4D:71(:col:row) 27, 91, 77,117 v 
#########################################################################
# nog ff uitzoeken wat dit allemaal is
#########################################################################
    altesc_mouse_24                         =>  "\e[M\$",                               #1B:5B:4D:24(:col:row) 27, 91, 77, 36 $     # Shift-Mouse-Button !! Your OS Took those !! how many other Button Groups ??
    altesc_mouse_25                         =>  "\e[M%",                                #1B:5B:4D:25(:col:row) 27, 91, 77, 37 %
    altesc_mouse_26                         =>  "\e[M&",                                #1B:5B:4D:26(:col:row) 27, 91, 77, 38 &
    altesc_mouse_27                         =>  "\e[M'",                                #1B:5B:4D:27(:col:row) 27, 91, 77, 39 '
    altesc_mouse_28                         =>  "\e[M(",                                #1B:5B:4D:28(:col:row) 27, 91, 77, 40 (
    altesc_mouse_29                         =>  "\e[M)",                                #1B:5B:4D:29(:col:row) 27, 91, 77, 41 ) 
    altesc_mouse_2A                         =>  "\e[M*",                                #1B:5B:4D:2A(:col:row) 27, 91, 77, 42 *
    altesc_mouse_2B                         =>  "\e[M+",                                #1B:5B:4D:2B(:col:row) 27, 91, 77, 43 +
    altesc_mouse_2C                         =>  "\e[M,",                                #1B:5B:4D:2C(:col:row) 27, 91, 77, 44 ,
    altesc_mouse_2D                         =>  "\e[M-",                                #1B:5B:4D:2D(:col:row) 27, 91, 77, 45 -
    altesc_mouse_2E                         =>  "\e[M.",                                #1B:5B:4D:2E(:col:row) 27, 91, 77, 46 .
    altesc_mouse_2F                         =>  "\e[M/",                                #1B:5B:4D:2F(:col:row) 27, 91, 77, 47 /
#########################################################################
# dingen van wheel oa
    altesc_mouse_62                         =>  "\e[Mb",                                #1B:5B:4D:62(:col:row) 27, 91, 77, 98 b 
    altesc_mouse_63                         =>  "\e[Mc",                                #1B:5B:4D:63(:col:row) 27, 91, 77, 99 c 
    altesc_mouse_64                         =>  "\e[Md",                                #1B:5B:4D:64(:col:row) 27, 91, 77,100 d 
    altesc_mouse_67                         =>  "\e[Mg",                                #1B:5B:4D:67(:col:row) 27, 91, 77,103 g 
    altesc_mouse_68                         =>  "\e[Mh",                                #1B:5B:4D:68(:col:row) 27, 91, 77,104 h 
    altesc_mouse_69                         =>  "\e[Mi",                                #1B:5B:4D:69(:col:row) 27, 91, 77,105 i 
    altesc_mouse_6A                         =>  "\e[Mj",                                #1B:5B:4D:6A(:col:row) 27, 91, 77,106 j 
    altesc_mouse_6B                         =>  "\e[Mk",                                #1B:5B:4D:6B(:col:row) 27, 91, 77,107 k 
    altesc_mouse_6C                         =>  "\e[Ml",                                #1B:5B:4D:6C(:col:row) 27, 91, 77,108 l 
    altesc_mouse_6D                         =>  "\e[Mm",                                #1B:5B:4D:6D(:col:row) 27, 91, 77,109 m 
    altesc_mouse_6E                         =>  "\e[Mn",                                #1B:5B:4D:6E(:col:row) 27, 91, 77,110 n 
    altesc_mouse_6F                         =>  "\e[Mo",                                #1B:5B:4D:6F(:col:row) 27, 91, 77,111 o 
#########################################################################
    altesc_mouse_72                         =>  "\e[Mr",                                #1B:5B:4D:72(:col:row) 27, 91, 77,114 r 
    altesc_mouse_73                         =>  "\e[Ms",                                #1B:5B:4D:73(:col:row) 27, 91, 77,115 s 
    altesc_mouse_74                         =>  "\e[Mt",                                #1B:5B:4D:74(:col:row) 27, 91, 77,116 t 
#########################################################################


#########################################################################
# DISPLAY CONTROL CHARACTERS
#########################################################################


#########################################################################
#   Calls the graphics functions specified by the following values.
#   These specified functions remain active until the next occurrence of this escape sequence.
#   Graphics mode changes the colors and attributes of text (such as bold and underline) displayed on the screen.
#########################################################################
    stripcode                               => sub { my($t)=@_; $t =~ s/\e[^m]*m//gs; return $t },
#╔════════════════════════╦════════════════════════════════╦═════════════════════════════════════════════════════════════════════════╗
#║         Code           ║             Effect             ║                                   Note                                  ║
#╠════════════════════════╬════════════════════════════════╬═════════════════════════════════════════════════════════════════════════╣
    attr                                    =>  sub { echr("[".join(';',@_)."m") },    #  Set Graphics Mode                          ║
    attr_off                                =>  "\e[m",#   ║                                                                         ║
#╠════════════════════════╬════════════════════════════════╬═════════════════════════════════════════════════════════════════════════╣
#║ 0                      ║  Reset / Normal                ║  all attributes off                                                     ║
    reset                                   =>  "\e[0m",#  ║                                                                         ║
#╠════════════════════════╩════════════════════════════════╩═════════════════════════════════════════════════════════════════════════╣
#║  UNICODE FONTS                                                                                                                    ║
#╠═══════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════╣
    font                                    => {
#╠─┄┄┄┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┄┈┈┈┄┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┄┄┄─╣ #
        parenthesis => {
#╠─┄┄┄┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┄┈┈┈┄┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┄┄┄─╣ #
            'A'=>"\x{0001F110}\x{200A}",
            'B'=>"\x{0001F111}\x{200A}",
            'C'=>"\x{0001F112}\x{200A}",
            'D'=>"\x{0001F113}\x{200A}",
            'E'=>"\x{0001F114}\x{200A}",
            'F'=>"\x{0001F115}\x{200A}",
            'G'=>"\x{0001F116}\x{200A}",
            'H'=>"\x{0001F117}\x{200A}",
            'I'=>"\x{0001F118}\x{200A}",
            'J'=>"\x{0001F119}\x{200A}",
            'K'=>"\x{0001F11A}\x{200A}",
            'L'=>"\x{0001F11B}\x{200A}",
            'M'=>"\x{0001F11C}\x{200A}",
            'N'=>"\x{0001F11D}\x{200A}",
            'O'=>"\x{0001F11E}\x{200A}",
            'P'=>"\x{0001F11F}\x{200A}",
            'Q'=>"\x{0001F120}\x{200A}",
            'R'=>"\x{0001F121}\x{200A}",
            'S'=>"\x{0001F122}\x{200A}",
            'T'=>"\x{0001F123}\x{200A}",
            'U'=>"\x{0001F124}\x{200A}",
            'V'=>"\x{0001F125}\x{200A}",
            'W'=>"\x{0001F126}\x{200A}",
            'X'=>"\x{0001F127}\x{200A}",
            'Y'=>"\x{0001F128}\x{200A}",
            'Z'=>"\x{0001F129}\x{200A}",
#╠─┄┄┄┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┄┈┈┈┄┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┄┄┄─╣ #
        },
#╠─┄┄┄┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┄┈┈┈┄┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┄┄┄─╣ #
        framed => {
#╠─┄┄┄┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┄┈┈┈┄┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┄┄┄─╣ #
            'A'=>"\x{0001F130}\x{200A}",
            'B'=>"\x{0001F131}\x{200A}",
            'C'=>"\x{0001F132}\x{200A}",
            'D'=>"\x{0001F133}\x{200A}",
            'E'=>"\x{0001F134}\x{200A}",
            'F'=>"\x{0001F135}\x{200A}",
            'G'=>"\x{0001F136}\x{200A}",
            'H'=>"\x{0001F137}\x{200A}",
            'I'=>"\x{0001F138}\x{200A}",
            'J'=>"\x{0001F139}\x{200A}",
            'K'=>"\x{0001F13A}\x{200A}",
            'L'=>"\x{0001F13B}\x{200A}",
            'M'=>"\x{0001F13C}\x{200A}",
            'N'=>"\x{0001F13D}\x{200A}",
            'O'=>"\x{0001F13E}\x{200A}",
            'P'=>"\x{0001F13F}\x{200A}",
            'Q'=>"\x{0001F140}\x{200A}",
            'R'=>"\x{0001F141}\x{200A}",
            'S'=>"\x{0001F142}\x{200A}",
            'T'=>"\x{0001F143}\x{200A}",
            'U'=>"\x{0001F144}\x{200A}",
            'V'=>"\x{0001F145}\x{200A}",
            'W'=>"\x{0001F146}\x{200A}",
            'X'=>"\x{0001F147}\x{200A}",
            'Y'=>"\x{0001F148}\x{200A}",
            'Z'=>"\x{0001F149}\x{200A}",
        },
#╠─┄┄┄┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┄┈┈┈┄┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┄┄┄─╣ #
        encircled => {
#╠─┄┄┄┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┄┈┈┈┄┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┄┄┄─╣ #
            'A'=>"\x{0001F150}\x{200A}",
            'B'=>"\x{0001F151}\x{200A}",
            'C'=>"\x{0001F152}\x{200A}",
            'D'=>"\x{0001F153}\x{200A}",
            'E'=>"\x{0001F154}\x{200A}",
            'F'=>"\x{0001F155}\x{200A}",
            'G'=>"\x{0001F156}\x{200A}",
            'H'=>"\x{0001F157}\x{200A}",
            'I'=>"\x{0001F158}\x{200A}",
            'J'=>"\x{0001F159}\x{200A}",
            'K'=>"\x{0001F15A}\x{200A}",
            'L'=>"\x{0001F15B}\x{200A}",
            'M'=>"\x{0001F15C}\x{200A}",
            'N'=>"\x{0001F15D}\x{200A}",
            'O'=>"\x{0001F15E}\x{200A}",
            'P'=>"\x{0001F15F}\x{200A}",
            'Q'=>"\x{0001F160}\x{200A}",
            'R'=>"\x{0001F161}\x{200A}",
            'S'=>"\x{0001F162}\x{200A}",
            'T'=>"\x{0001F163}\x{200A}",
            'U'=>"\x{0001F164}\x{200A}",
            'V'=>"\x{0001F165}\x{200A}",
            'W'=>"\x{0001F166}\x{200A}",
            'X'=>"\x{0001F167}\x{200A}",
            'Y'=>"\x{0001F168}\x{200A}",
            'Z'=>"\x{0001F169}\x{200A}",
#╠─┄┄┄┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┄┈┈┈┄┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┄┄┄─╣ #
        },
#╠─┄┄┄┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┄┈┈┈┄┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┄┄┄─╣ #
        squared => {
#╠─┄┄┄┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┄┈┈┈┄┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┄┄┄─╣ #
            'A'=>"\x{0001F170}\x{200A}",
            'B'=>"\x{0001F171}\x{200A}",
            'C'=>"\x{0001F172}\x{200A}",
            'D'=>"\x{0001F173}\x{200A}",
            'E'=>"\x{0001F174}\x{200A}",
            'F'=>"\x{0001F175}\x{200A}",
            'G'=>"\x{0001F176}\x{200A}",
            'H'=>"\x{0001F177}\x{200A}",
            'I'=>"\x{0001F178}\x{200A}",
            'J'=>"\x{0001F179}\x{200A}",
            'K'=>"\x{0001F17A}\x{200A}",
            'L'=>"\x{0001F17B}\x{200A}",
            'M'=>"\x{0001F17C}\x{200A}",
            'N'=>"\x{0001F17D}\x{200A}",
            'O'=>"\x{0001F17E}\x{200A}",
            'P'=>"\x{0001F17F}\x{200A}",
            'Q'=>"\x{0001F180}\x{200A}",
            'R'=>"\x{0001F181}\x{200A}",
            'S'=>"\x{0001F182}\x{200A}",
            'T'=>"\x{0001F183}\x{200A}",
            'U'=>"\x{0001F184}\x{200A}",
            'V'=>"\x{0001F185}\x{200A}",
            'W'=>"\x{0001F186}\x{200A}",
            'X'=>"\x{0001F187}\x{200A}",
            'Y'=>"\x{0001F188}\x{200A}",
            'Z'=>"\x{0001F189}\x{200A}",
#╠─┄┄┄┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┄┈┈┈┄┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┄┄┄─╣ #
        },
#╠─┄┄┄┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┄┈┈┈┄┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┄┄┄─╣ #
        comic => {
#╠─┄┄┄┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┄┈┈┈┄┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┄┄┄─╣ #
            'A'=>"\x{0001D4D0}",
            'B'=>"\x{0001D4D1}",
            'C'=>"\x{0001D4D2}",
            'D'=>"\x{0001D4D3}",
            'E'=>"\x{0001D4D4}",
            'F'=>"\x{0001D4D5}",
            'G'=>"\x{0001D4D6}",
            'H'=>"\x{0001D4D7}",
            'I'=>"\x{0001D4D8}",
            'J'=>"\x{0001D4D9}",
            'K'=>"\x{0001D4DA}",
            'L'=>"\x{0001D4DB}",
            'M'=>"\x{0001D4DC}",
            'N'=>"\x{0001D4DD}",
            'O'=>"\x{0001D4DE}",
            'P'=>"\x{0001D4DF}",
            'Q'=>"\x{0001D4E0}",
            'R'=>"\x{0001D4E1}",
            'S'=>"\x{0001D4E2}",
            'T'=>"\x{0001D4E3}",
            'U'=>"\x{0001D4E4}",
            'V'=>"\x{0001D4E5}",
            'W'=>"\x{0001D4E6}",
            'X'=>"\x{0001D4E7}",
            'Y'=>"\x{0001D4E8}",
            'Z'=>"\x{0001D4E9}",
            'a'=>"\x{0001D4EA}",
            'b'=>"\x{0001D4EB}",
            'c'=>"\x{0001D4EC}",
            'd'=>"\x{0001D4ED}",
            'e'=>"\x{0001D4EE}",
            'f'=>"\x{0001D4EF}",
            'g'=>"\x{0001D4F0}",
            'h'=>"\x{0001D4F1}",
            'i'=>"\x{0001D4F2}",
            'j'=>"\x{0001D4F3}",
            'k'=>"\x{0001D4F4}",
            'l'=>"\x{0001D4F5}",
            'm'=>"\x{0001D4F6}",
            'n'=>"\x{0001D4F7}",
            'o'=>"\x{0001D4F8}",
            'p'=>"\x{0001D4F9}",
            'q'=>"\x{0001D4FA}",
            'r'=>"\x{0001D4FB}",
            's'=>"\x{0001D4FC}",
            't'=>"\x{0001D4FD}",
            'u'=>"\x{0001D4FE}",
            'v'=>"\x{0001D4FF}",
            'w'=>"\x{0001D500}",
            'x'=>"\x{0001D501}",
            'y'=>"\x{0001D502}",
            'z'=>"\x{0001D503}",
#╠─┄┄┄┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┄┈┈┈┄┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┄┄┄─╣ #
        },
#╠─┄┄┄┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┄┈┈┈┄┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┄┄┄─╣ #
        big => {
#╠─┄┄┄┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┄┈┈┈┄┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┄┄┄─╣ #
            'A'=>"\x{0001F1E6}",
            'B'=>"\x{0001F1E7}",
            'C'=>"\x{0001F1E8}",
            'D'=>"\x{0001F1E9}",
            'E'=>"\x{0001F1EA}",
            'F'=>"\x{0001F1EB}",
            'G'=>"\x{0001F1EC}",
            'H'=>"\x{0001F1ED}",
            'I'=>"\x{0001F1EE}",
            'J'=>"\x{0001F1EF}",
            'K'=>"\x{0001F1F0}",
            'L'=>"\x{0001F1F1}",
            'M'=>"\x{0001F1F2}",
            'N'=>"\x{0001F1F3}",
            'O'=>"\x{0001F1F4}",
            'P'=>"\x{0001F1F5}",
            'Q'=>"\x{0001F1F6}",
            'R'=>"\x{0001F1F7}",
            'S'=>"\x{0001F1F8}",
            'T'=>"\x{0001F1F9}",
            'U'=>"\x{0001F1FA}",
            'V'=>"\x{0001F1FB}",
            'W'=>"\x{0001F1FC}",
            'X'=>"\x{0001F1FD}",
            'Y'=>"\x{0001F1FE}",
            'Z'=>"\x{0001F1FF}",
        }
#╠─┄┄┄┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┄┈┈┈┄┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┄┄┄─╣ #
    },
#╠════════════════════════╩════════════════════════════════╩═════════════════════════════════════════════════════════════════════════╣
#║  TERMINAL FONTS                                                                                                                   ║
#╠════════════════════════╦════════════════════════════════╦═════════════════════════════════════════════════════════════════════════╣
#║ 10                     ║  Primary(default) font         ║                                                                         ║
    font_default                            =>  "\e[10m",# ║                                                                         ║
#║ 11–19                  ║  Alternate font                ║  Select alternate font `n = [10-19]`                                    ║
    font_select                             =>  sub { echr("[".$_[0]."m") },    #                                                    ║
    font_00                                 =>  "\e[10m",# ║                                                                         ║
    font_01                                 =>  "\e[11m",# ║                                                                         ║
    font_02                                 =>  "\e[12m",# ║                                                                         ║
    font_03                                 =>  "\e[13m",# ║                                                                         ║
    font_04                                 =>  "\e[14m",# ║                                                                         ║
    font_05                                 =>  "\e[15m",# ║                                                                         ║
    font_06                                 =>  "\e[16m",# ║                                                                         ║
    font_07                                 =>  "\e[17m",# ║                                                                         ║
    font_08                                 =>  "\e[18m",# ║                                                                         ║
    font_09                                 =>  "\e[19m",# ║                                                                         ║
#╠════════════════════════╩════════════════════════════════╩═════════════════════════════════════════════════════════════════════════╣
#║         INTENSITIES                                                                                                               ║
#╠════════════════════════╦════════════════════════════════╦═════════════════════════════════════════════════════════════════════════╣
#║ 1                      ║  Bold or increased intensity   ║                                                                         ║
    bold                                    =>  "\e[1m",#  ║                                                                         ║
#║ 21                     ║  Bold off or Double Underline  ║  Bold off not widely supported; double underline hardly ever supported. ║
    bold_off                                =>  "\e[21m",# ║                                                                         ║
#║ 2                      ║  Faint (decreased intensity)   ║  Not widely supported.                                                  ║
    faint                                   =>  "\e[2m",#  ║                                                                         ║
#║ 22                     ║  Normal color or intensity     ║  Neither bold nor faint                                                 ║
    faint_off                               =>  "\e[22m",# ║                                                                         ║
#║ 22                     ║  Normal color or intensity     ║  Neither bold nor faint                                                 ║
    normal                                  =>  "\e[22m",# ║                                                                         ║
#╠════════════════════════╩════════════════════════════════╩═════════════════════════════════════════════════════════════════════════╣
#║         STYLES                                                                                                                    ║
#╠════════════════════════╦════════════════════════════════╦═════════════════════════════════════════════════════════════════════════╣
#║ 3                      ║  Italic                        ║  Not widely supported. Sometimes treated as inverse.                    ║
    italic                                  =>  "\e[3m",#  ║                                                                         ║
#║ 23                     ║  Not italic, not Fraktur       ║                                                                         ║
    italic_off                              =>  "\e[23m",# ║                                                                         ║
#╠════════════════════════╬════════════════════════════════╬═════════════════════════════════════════════════════════════════════════╣
#║ 4                      ║  Underline                     ║                                                                         ║
    underline                               =>  "\e[4m",#  ║                                                                         ║
#║ 24                     ║  Underline off                 ║  Not singly or doubly underlined                                        ║
    underline_off                           =>  "\e[24m",# ║                                                                         ║
#╠════════════════════════╬════════════════════════════════╬═════════════════════════════════════════════════════════════════════════╣
#║ 21                     ║  Bold off or Double Underline  ║  Bold off not widely supported; double underline hardly ever supported. ║
    dblunderline                            =>  "\e[21m",# ║                                                                         ║
#╠════════════════════════╬════════════════════════════════╬═════════════════════════════════════════════════════════════════════════╣
#║ 5                      ║  Slow Blink                    ║  less than 150 per minute                                               ║
    blink                                   =>  "\e[5m",#  ║                                                                         ║
#║ 25                     ║  Blink off                     ║                                                                         ║
    blink_off                               =>  "\e[25m",# ║                                                                         ║
#╠════════════════════════╬════════════════════════════════╬═════════════════════════════════════════════════════════════════════════╣
#║ 6                      ║  Rapid Blink                   ║  MS-DOS ANSI.SYS; 150+ per minute; not widely supported                 ║
    blinker                                 =>  "\e[6m",#  ║                                                                         ║
#║ 26?                    ║  RapidBlink Off ???            ║                                                                         ║
    blinker_off                             =>  "\e[26m",# ║                                                                         ║
#╠════════════════════════╬════════════════════════════════╬═════════════════════════════════════════════════════════════════════════╣
#║ 7                      ║  [[reverse video]]             ║  swap foreground and background colors                                  ║
    reverse                                 =>  "\e[7m",#  ║                                                                         ║
#║ 27                     ║  Inverse off                   ║                                                                         ║
    inverse_off                             =>  "\e[27m",# ║                                                                         ║
#╠════════════════════════╬════════════════════════════════╬═════════════════════════════════════════════════════════════════════════╣
#║ 8                      ║  Conceal                       ║  Not widely supported.                                                  ║
    conceal                                 =>  "\e[8m",#  ║                                                                         ║
#║ 28                     ║  Reveal                        ║  conceal off                                                            ║
    reveal                                  =>  "\e[21m",# ║                                                                         ║
#╠════════════════════════╬════════════════════════════════╬═════════════════════════════════════════════════════════════════════════╣
#║ 9                      ║  Crossed-out                   ║  Characters legible, but marked for deletion.  Not widely supported.    ║
    crossedout                              =>  "\e[9m",#  ║                                                                         ║
    linethrough                             =>  "\e[9m",#  ║                                                                         ║
#║ 29                     ║  Not crossed out               ║                                                                         ║
    crossedout_off                          =>  "\e[21m",# ║                                                                         ║
    linethrough_off                         =>  "\e[21m",# ║                                                                         ║
#╠════════════════════════╬════════════════════════════════╬═════════════════════════════════════════════════════════════════════════╣
#║ 20                     ║  Fraktur                       ║  hardly ever supported                                                  ║
    fraktur                                 =>  "\e[10m",# ║                                                                         ║
#║ 23                     ║  Not italic, not Fraktur       ║                                                                         ║
    fraktur_off                             =>  "\e[23m",# ║                                                                         ║
#╠════════════════════════╬════════════════════════════════╬═════════════════════════════════════════════════════════════════════════╣
#║ 51                     ║  Framed                        ║                                                                         ║
    framed                                  =>  "\e[51m",# ║                                                                         ║
#║ 54                     ║  Not framed or encircled       ║                                                                         ║
    framed_off                              =>  "\e[54m",# ║                                                                         ║
#╠════════════════════════╬════════════════════════════════╬═════════════════════════════════════════════════════════════════════════╣
#║ 52                     ║  Encircled                     ║                                                                         ║
    encircled                               =>  "\e[52m",# ║                                                                         ║
#║ 54                     ║  Not framed or encircled       ║                                                                         ║
    encircled_off                           =>  "\e[54m",# ║                                                                         ║
#╠════════════════════════╬════════════════════════════════╬═════════════════════════════════════════════════════════════════════════╣
#║ 53                     ║  Overlined                     ║                                                                         ║
    overlined                               =>  "\e[53m",# ║                                                                         ║
#║ 55                     ║  Not overlined                 ║                                                                         ║
    overlined_off                           =>  "\e[54m",# ║                                                                         ║
#╠════════════════════════╩════════════════════════════════╩═════════════════════════════════════════════════════════════════════════╣
#║         IDIOGRAM                                                                                                                  ║
#╠════════════════════════╦════════════════════════════════╦═════════════════════════════════════════════════════════════════════════╣
#║ 60                     ║  ideogram underline            ║  hardly ever supported                                                  ║
    ideogram_underline                      =>  "\e[60m",# ║                                                                         ║
#║ 61                     ║  ideogram double underline     ║  hardly ever supported                                                  ║
    ideogram_dblunderline                   =>  "\e[61m",# ║                                                                         ║
#║ 62                     ║  ideogram overline             ║  hardly ever supported                                                  ║
    ideogram_overline                       =>  "\e[62m",# ║                                                                         ║
#║ 63                     ║  ideogram double overline      ║  hardly ever supported                                                  ║
    ideogram_dbloverline                    =>  "\e[63m",# ║                                                                         ║
#║ 64                     ║  ideogram stress marking       ║  hardly ever supported                                                  ║
    ideogram_stress_marking                 =>  "\e[64m",# ║                                                                         ║
#║ 65                     ║  ideogram attributes off       ║  reset the effects of all of 60-64                                      ║
    ideogram_off                            =>  "\e[65m",# ║                                                                         ║
#╠════════════════════════╩════════════════════════════════╩═════════════════════════════════════════════════════════════════════════╣
#║         TEXT & BACKGROUND COLORS                                                                                                  ║
#╠════════════════════════╦════════════════════════════════╦═════════════════════════════════════════════════════════════════════════╣
    colors                                  =>  ["black","red","green","yellow","blue","magenta","cyan","white"], #                  ║
    bright_colors                           =>  ["bright_black","bright_red","bright_green","bright_yellow","bright_blue","bright_magenta","bright_cyan","bright_white"],
    on_colors                               =>  ["on_black","on_red","on_green","on_yellow","on_blue","on_magenta","on_cyan","on_white"],
    on_bright_colors                        =>  ["on_bright_black","on_bright_red","on_bright_green","on_bright_yellow","on_bright_blue","on_bright_magenta","on_bright_cyan","on_bright_white"],
#╠════════════════════════╬════════════════════════════════╬═════════════════════════════════════════════════════════════════════════╣
#║ 39                     ║  Default foreground color      ║  implementation defined (according to standard)                         ║
    default                                 =>  "\e[39m",# ║                                                                         ║
#║ 38                     ║  Set foreground color          ║  Next arguments are `5;n` or `2;r;g;b`, see below                       ║
    color                                   =>  sub { #    ║                                                                         ║
        echr("[38;5;".$_[0]."m") #                         ║  tc('color',0-5)      gray ?                                            ║
    },  #                 ║                                ║                                                                         ║
    rgb                                     =>  sub { #    ║                                                                         ║
        echr("[38;2;".join(";",@_)."m") #                  ║  tc('rgb',0-255,0-255,0-255)                                            ║
    },  #                 ║                                ║                                                                         ║
    gray                                    =>  sub { #    ║  tc('gray',[0-255])                                                     ║
        if(!defined $_[0]){return tc('rgb',127,127,127)} # ║                                                                         ║
        tc('rgb',$_[0],$_[0],$_[0])                     #  ║                                                                         ║
    },  #                 ║                                ║                                                                         ║
#╠════════════════════════╬════════════════════════════════╬═════════════════════════════════════════════════════════════════════════╣
#║ 30–37                  ║  Set foreground color          ║  See color table below                                                  ║
    black                                   =>  "\e[30m",# ║    30  Black                                                            ║
    red                                     =>  "\e[31m",# ║    31  Red                                                              ║
    green                                   =>  "\e[32m",# ║    32  Green                                                            ║
    yellow                                  =>  "\e[33m",# ║    33  Yellow                                                           ║
    blue                                    =>  "\e[34m",# ║    34  Blue                                                             ║
    magenta                                 =>  "\e[35m",# ║    35  Magenta                                                          ║
    cyan                                    =>  "\e[36m",# ║    36  Cyan                                                             ║
    white                                   =>  "\e[37m",# ║    37  White                                                            ║
#╠════════════════════════╬════════════════════════════════╬═════════════════════════════════════════════════════════════════════════╣
#║ 90–97                  ║  Set bright foreground color   ║  aixterm (not in standard)                                              ║
    bright_black                            =>  "\e[90m",# ║    40  BrightBlack                                                      ║
    bright_red                              =>  "\e[91m",# ║    41  BrightRed                                                        ║
    bright_green                            =>  "\e[92m",# ║    42  BrightGreen                                                      ║
    bright_yellow                           =>  "\e[93m",# ║    43  BrightYellow                                                     ║
    bright_blue                             =>  "\e[94m",# ║    44  BrightBlue                                                       ║
    bright_magenta                          =>  "\e[95m",# ║    45  BrightMagenta                                                    ║
    bright_cyan                             =>  "\e[96m",# ║    46  BrightCyan                                                       ║
    bright_white                            =>  "\e[97m",# ║    47  BrightWhite                                                      ║
#╠════════════════════════╬════════════════════════════════╬═════════════════════════════════════════════════════════════════════════╣
#║ 49                     ║  Default background color      ║  implementation defined (according to standard)                         ║
    on_default                              =>  "\e[49m",# ║                                                                         ║
#║ 48                     ║  Set background color          ║  Next arguments are `5;n` or `2;r;g;b`, see below                       ║
    on_color                                =>  sub { #    ║                                                                         ║
        echr("[48;5;$_[0]m")    #                          ║  tc('bg_color',40-47)                                                   ║
    },  #                 ║                                ║                                                                         ║
    on_rgb                                  =>  sub { #    ║                                                                         ║
        echr("[48;2;".join(";",@_)."m") #                  ║  tc('bg_color',40-47,40-47,40-47)                                       ║
    },  #                 ║                                ║                                                                         ║
    on_gray                                 =>  sub { #    ║  tc('gray',[0-255])                                                     ║
       if(!defined $_[0]){return tc('on_rgb',127,127,127)}#║                                                                         ║
       tc('on_rgb',$_[0],$_[0],$_[0])                   #  ║                                                                         ║
    },  #                 ║                                ║                                                                         ║
#╠════════════════════════╬════════════════════════════════╬═════════════════════════════════════════════════════════════════════════╣
#║ 40–47                  ║  Set background color          ║  See color table below                                                  ║
    on_black                                =>  "\e[40m",# ║    40  OnBlack                                                          ║
    on_red                                  =>  "\e[41m",# ║    41  OnRed                                                            ║
    on_green                                =>  "\e[42m",# ║    42  OnGreen                                                          ║
    on_yellow                               =>  "\e[43m",# ║    43  OnYellow                                                         ║
    on_blue                                 =>  "\e[44m",# ║    44  OnBlue                                                           ║
    on_magenta                              =>  "\e[45m",# ║    45  OnMagenta                                                        ║
    on_cyan                                 =>  "\e[46m",# ║    46  OnCyan                                                           ║
    on_white                                =>  "\e[47m",# ║    47  OnWhite                                                          ║
#╠════════════════════════╬════════════════════════════════╬═════════════════════════════════════════════════════════════════════════╣
#║ 100–107                ║  Set bright background color   ║  aixterm (not in standard)                                              ║
    on_bright_black                         =>  "\e[100m",#║    40  OnBrightBlack                                                    ║
    on_bright_red                           =>  "\e[101m",#║    41  OnBrightRed                                                      ║
    on_bright_green                         =>  "\e[102m",#║    42  OnBrightGreen                                                    ║
    on_bright_yellow                        =>  "\e[103m",#║    43  OnBrightYellow                                                   ║
    on_bright_blue                          =>  "\e[104m",#║    44  OnBrightBlue                                                     ║
    on_bright_magenta                       =>  "\e[105m",#║    45  OnBrightMagenta                                                  ║
    on_bright_cyan                          =>  "\e[106m",#║    46  OnBrightCyan                                                     ║
    on_bright_white                         =>  "\e[107m",#║    47  OnBrightWhite                                                    ║
#╠════════════════════════╩════════════════════════════════╩═════════════════════════════════════════════════════════════════════════╣
#║         UNKNOWN LEFTOVERS                                                                                                         ║
#╠════════════════════════╦════════════════════════════════╦═════════════════════════════════════════════════════════════════════════╣
#║ 50 66-89 98-99         ║  unknown settings              ║                                                                         ║
    color50                                 =>  "\e[50m",# ║                                                                         ║
#╠════════════════════════╬════════════════════════════════╬═════════════════════════════════════════════════════════════════════════╣
    color66                                 =>  "\e[66m",# ║                                                                         ║
    color67                                 =>  "\e[67m",# ║                                                                         ║
    color68                                 =>  "\e[68m",# ║                                                                         ║
    color69                                 =>  "\e[69m",# ║                                                                         ║
    color70                                 =>  "\e[70m",# ║                                                                         ║
    color71                                 =>  "\e[71m",# ║                                                                         ║
    color72                                 =>  "\e[72m",# ║                                                                         ║
    color73                                 =>  "\e[73m",# ║                                                                         ║
    color74                                 =>  "\e[74m",# ║                                                                         ║
    color75                                 =>  "\e[75m",# ║                                                                         ║
    color76                                 =>  "\e[76m",# ║                                                                         ║
    color77                                 =>  "\e[77m",# ║                                                                         ║
    color78                                 =>  "\e[78m",# ║                                                                         ║
    color79                                 =>  "\e[79m",# ║                                                                         ║
    color80                                 =>  "\e[80m",# ║                                                                         ║
    color81                                 =>  "\e[81m",# ║                                                                         ║
    color82                                 =>  "\e[82m",# ║                                                                         ║
    color83                                 =>  "\e[83m",# ║                                                                         ║
    color84                                 =>  "\e[84m",# ║                                                                         ║
    color85                                 =>  "\e[85m",# ║                                                                         ║
    color86                                 =>  "\e[86m",# ║                                                                         ║
    color87                                 =>  "\e[87m",# ║                                                                         ║
    color88                                 =>  "\e[88m",# ║                                                                         ║
    color89                                 =>  "\e[89m",# ║                                                                         ║
#╠════════════════════════╬════════════════════════════════╬═════════════════════════════════════════════════════════════════════════╣
    color98                                 =>  "\e[98m",# ║                                                                         ║
    color99                                 =>  "\e[98m",# ║                                                                         ║
#╚════════════════════════╩════════════════════════════════╩═════════════════════════════════════════════════════════════════════════╝
#########################################################################


#########################################################################
    null                                    =>  "\x{00}",                               #00                     0  NUL :ctrl2:ctrlcommercialat:ctrlat          : <control> NULL : UNICODE00
    null_esc                                =>  "\x{1B}\x{00}",                         #1B:00                 27,  0  ctrlalt2                                : <control> [ESC] NULL
#########################################################################
    start_of_heading                        =>  "\x{01}",                               #01                     1  SOH:ctrla                                   : <control> START OF HEADING : UNICODE01
    start_of_heading_esc                    =>  "\x{1B}\x{01}",                         #1B:01                 27,  1  ctrlaltsoh                              : <control> [ESC] START OF HEADING
#########################################################################
    start_of_text                           =>  "\x{02}",                               #02                     2  STX:ctrlb                                   : <control> START OF TEXT
    start_of_text_esc                       =>  "\x{1B}\x{02}",                         #1B:02                 27,  2  ctrlaltstx                              : <control> [ESC] START OF TEXT
#########################################################################
    end_of_text                             =>  "\x{03}",                               #03                     3  ETX :ctrlc                                  : <control> END OF TEXT
    end_of_text_esc                         =>  "\x{1B}\x{03}",                         #1B:03                 27,  3  ctrlaltetx                              : <control> [ESC] END OF TEXT
#########################################################################
    end_of_transmission                     =>  "\x{04}",                               #04                     4  EOT:ctrld                                   : <control> END OF TRANSMISSION
    end_of_transmission_esc                 =>  "\x{1B}\x{04}",                         #1B:04                 27,  4  ctrlalteot                              : <control> [ESC] END OF TRANSMISSION
#########################################################################
    enquiry                                 =>  "\x{05}",                               #05                     5  ENQ:ctrle                                   : <control> ENQUIRY
    enquiry_esc                             =>  "\x{1B}\x{05}",                         #1B:05                 27,  5  ctrlaltenq                              : <control> [ESC] ENQUIRY
#########################################################################
    acknowledge                             =>  "\x{06}",                               #06                     6  ACK:ctrlf                                   : <control> ACKNOWLEDGE
    acknowledge_esc                         =>  "\x{1B}\x{06}",                         #1B:06                 27,  6  ctrlaltack                              : <control> [ESC] ACKNOWLEDGE
#########################################################################
    bell                                    =>  "\x{07}",                               #07                     7  BEL:ctrlg                                   : <control> BELL
    bell_esc                                =>  "\x{1B}\x{07}",                         #1B:07                 27,  7  ctrlaltbel                              : <control> [ESC] BELL
#########################################################################
    backspace                               =>  "\x{08}",                               #08                     8  BS:ctrlbackspace                            : <control> BACKSPACE
    backspace_esc                           =>  "\x{1B}\x{08}",                         #1B:08                 27,  8  ctrlalth:ctrlaltbs                      : <control> [ALTESC] BACKSPACE
#########################################################################
    tab                                     =>  "\x{09}",                               #09                     9  HT:TAB:ctrli                                : <control> [TAB] CHARACTER TABULATION : Horizontal Tabulation
    tab_esc                                 =>  "\x{1B}\x{09}",                         #1B:09                 27,  9  ctrlalti:ctrlaltht:ctrlalttab           : <control> [ESC][TAB] CHARACTER TABULATION
#########################################################################
#   Code        SHIFT+code  CTRL+code   ALT+code        Key
    lined_feed                              =>  "\x{0A}",                               #0A                    10  LF:NL:EOL:ctrlj                             : <control> LINE FEED
    lined_feed_esc                          =>  "\x{1B}\x{0A}",                         #1B:0A                 27, 10  ctrlaltlf:ctrlaltj                      : <control> [ESC] LINE FEED
#########################################################################
    line_tabulation                         =>  "\x{0B}",                               #0B                    11  VT:ctrlk                                    : <control> LINE TABULATION : Vertical Tabulation
    line_tabulation_esc                     =>  "\x{1B}\x{0B}",                         #1B:0B                 27, 11  VT:ctrlaltk                             : [ALTESC] LINE TABULATION : Vertical Tabulation
#########################################################################
    form_feed                               =>  "\x{0C}",                               #0C                    12  FF:ctrll                                    : <control> FORM FEED : Form Feed
    form_feed_esc                           =>  "\x{1B}\x{0C}",                         #1B:0C                 27, 12  FF:ctrlaltl                             : [ALTESC] FORM FEED : Form Feed
#########################################################################
    carriage_return                         =>  "\x{0D}",                               #0D                    13  CR:ctrlm                                    : <control> CARRIAGE RETURN : Carriage Feed
    carriage_return_esc                     =>  "\x{1B}\x{0D}",                         #1B:0D                 27, 13  CR:ctrlaltm                             : [ALTESC] CARRIAGE RETURN : Carriage Feed
#########################################################################
    shift_out                               =>  "\x{0E}",                               #0E                    14  SO:ctrln                                        : <control> SHIFT OUT : LOCKING-SHIFT ONE
    shift_out_esc                           =>  "\x{1B}\x{0E}",                         #1B:0E                 27, 14  SO:ctrlaltn                             : [ALTESC] SHIFT OUT : LOCKING-SHIFT ONE
#########################################################################
    shift_in                                =>  "\x{0F}",                               #0F                    15  SI:ctrlo                                    : <control> SHIFT IN : LOCKING-SHIFT ZERO
    shift_in_esc                            =>  "\x{1B}\x{0F}",                         #1B:0F                 27, 15  SI:ctrlalto                             : [ALTESC] SHIFT IN : LOCKING-SHIFT ZERO
#########################################################################
    data_link_escape                        =>  "\x{10}",                               #10                    16  DLE:ctrlp                                   : <control> DATA LINK ESCAPE
    data_link_escape_esc                    =>  "\x{1B}\x{10}",                         #1B:10                 27, 16  DLE:ctrlaltp                            : [ALTESC] DATA LINK ESCAPE
#########################################################################
    device_control_one                      =>  "\x{11}",                               #11                    17  DC1:ctrlq                                   : <control> DEVICE CONTROL ONE
    device_control_one_esc                  =>  "\x{1B}\x{11}",                         #1B:11                 27, 17  DC1:ctrlaltq                            : [ALTESC] DEVICE CONTROL ONE
#########################################################################
    device_control_two                      =>  "\x{12}",                               #12                    18  DC2:ctrlr                                   : <control> DEVICE CONTROL TWO
    device_control_two_esc                  =>  "\x{1B}\x{12}",                         #1B:12                 27, 18  DC2:ctrlaltr                            : [ALTESC] DEVICE CONTROL TWO
#########################################################################
    device_control_three                    =>  "\x{13}",                               #13                    19  DC3:ctrls                                   : <control> DEVICE CONTROL THREE
    device_control_three_esc                =>  "\x{1B}\x{13}",                         #1B:13                 27, 19  DC3:ctrlalta                            : [ALTESC] DEVICE CONTROL THREE
#########################################################################
    device_control_four                     =>  "\x{14}",                               #14                    20  ctrlt                                   : [DC4] <control> DEVICE CONTROL FOUR
    device_control_four_esc                 =>  "\x{1B}\x{14}",                         #1B:14                 27, 20  ctrlaltt                                : [ALTESC][DC4] DEVICE CONTROL FOUR
#########################################################################
    negative_acknowledge                    =>  "\x{15}",                               #15                    21  ctrlu                                   : [NAK] <control> NEGATIVE ACKNOWLEDGE
    negative_acknowledge_esc                =>  "\x{1B}\x{15}",                         #1B:15                 27, 21  ctrlaltu                                : [ALTESC][NAK] NEGATIVE ACKNOWLEDGE : UNDO?
#########################################################################
    synchronous_idle                        =>  "\x{16}",                               #16                    22  SYN:ctrlv                                   : <control> SYNCHRONOUS IDLE
    synchronous_idle_esc                    =>  "\x{1B}\x{16}",                         #1B:16                 27, 22  SYN:ctrlaltv                            : [ALTESC] SYNCHRONOUS IDLE
#########################################################################
    end_of_transmission_block               =>  "\x{17}",                               #17                    23  ETB:ctrlw                                   : <control> END OF TRANSMISSION BLOCK
    end_of_transmission_block_esc           =>  "\x{1B}\x{17}",                         #1B:17                 27, 23  ETB:ctrlaltw                            : [ALTESC] END OF TRANSMISSION BLOCK
#########################################################################
    cancel                                  =>  "\x{18}",                               #18                    24  CAN:ctrl_x                                  : <control> CANCEL
    cancel_esc                              =>  "\x{1B}\x{18}",                         #1B:18                 27, 24  CAN:ctrlaltx                            : [ALTESC] CANCEL
#########################################################################
    end_of_medium                           =>  "\x{19}",                               #19                    25  EM:ctrl_y                                   : <control> END OF MEDIUM
    end_of_medium_esc                       =>  "\x{1B}\x{19}",                         #1B:19                 27, 25  EM:ctrlalty                             : [ALTESC] END OF MEDIUM
#########################################################################
    substitude                              =>  "\x{1A}",                               #1A                    26  SUB:ctrl_z                                  : <control> SUBSTITUTE
    substitude_esc                          =>  "\x{1B}\x{1A}",                         #1B:1A                 27, 26  SUB:ctrlaltz                            : [ALTESC] SUBSTITUTE
#########################################################################
    escape                                  =>  "\x{1B}",                               #1B                    27  ESC                                         : <control> ESCAPE
    escape_esc                              =>  "\x{1B}\x{1B}",                         #1B:1B                 27, 27  esc : ESCAPE alt_openingsquarebracket   : [ESC][ESC] OPENING SQUARE BRACKET
#########################################################################
    record_separator                        =>  "\x{1E}",                               #1E                    30  ctrl6:is2:RS                                    : <control> INFORMATION SEPARATOR TWO
    record_separator_esc                    =>  "\x{1B}\x{1E}",                         #1B:1E                 27, 30  ctrlaltrs                               : [ALTESC] INFORMATION SEPARATOR TWO
#########################################################################
    delete                                  =>  "\x{7F}",                               #7F                    127  del:ctrl8                              : <control> BACKSPACE
    alt_delete                              =>  "\x{1B}\x{7F}",                         #1B:7F                 27,127  altbackspace                            : [ALT] BACKSPACE
#########################################################################
    control_80                              =>  "\x{80}",                               #80                    128  ctrl80                                     : <control>
    control_81                              =>  "\x{81}",                               #81                    129  cntl81                                     : <control>
#########################################################################
    break_permitted_here                    =>  "\x{82}",                               #82                    130  ctrl82                                     : <control> BREAK PERMITTED HERE
    no_break_here                           =>  "\x{83}",                               #83                    131  ctrl83                                     : <control> NO BREAK HERE
#########################################################################
    control_84                              =>  "\x{84}",                               #84                    132  ctrl84:index                               : <control> formerly known as INDEX
    next_line                               =>  "\x{85}",                               #85                    133  ctrl85:nel                                 : <control> [NEL] NEXT LINE
    start_of_selected_area                  =>  "\x{86}",                               #86                    134  ctrl86                                     : <control> START OF SELECTED AREA
    end_of_selected_area                    =>  "\x{87}",                               #87                    135  ctrl87                                     : <control> END OF SELECTED AREA
    character_tabulation_set                =>  "\x{88}",                               #88                    136  ctrl88                                 : <control> CHARACTER TABULATION SET
    character_tabulation_with_justification =>  "\x{89}",                               #89                    137  ctrl89                                     : <control> CHARACTER TABULATION WITH JUSTIFICATION
    line_tabulation_set                     =>  "\x{8A}",                               #8A                    138  ctrl8a                                     : <control> LINE TABULATION SET
    partial_line_forward                    =>  "\x{8B}",                               #8B                    139  ctrl8b                                     : <control> PARTIAL LINE FORWARD
    partial_line_backward                   =>  "\x{8C}",                               #8C                    139  ctrl8c                                     : <control> PARTIAL LINE BACKWARD
    reverse_line_feed                       =>  "\x{8D}",                               #8D                    141  ctrl8d                                     : <control> REVERSE LINE FEED
    single_shift_two                        =>  "\x{8E}",                               #8E                    142  ctrl8e                                     : <control> SINGLE SHIFT TWO
    single_shift_three                      =>  "\x{8F}",                               #8F                    143  ctrl8f                                     : <control> SINGLE SHIFT THREE
    device_control_string                   =>  "\x{90}",                               #90                    144  ctrl90                                     : <control> DEVICE CONTROL STRING
    private_use_one                         =>  "\x{91}",                               #91                    145  ctrl91                                     : <control> PRIVATE USE ONE
    private_use_two                         =>  "\x{92}",                               #92                    146  ctrl92                                     : <control> PRIVATE USE TWO
    set_transmit_state                      =>  "\x{93}",                               #93                    147  ctrl93                                     : <control> SET TRANSMIT STATE
    cancel_character                        =>  "\x{94}",                               #94                    148  ctrl94                                     : <control> CANCEL CHARACTER
    message_waiting                         =>  "\x{95}",                               #95                    149  ctrl95                                     : <control> MESSAGE WAITING
    start_of_guarded_area                   =>  "\x{96}",                               #96                    150  ctrl96                                     : <control> START OF GUARDED AREA
    end_of_fuarded_area                     =>  "\x{97}",                               #97                    151  ctrl97                                     : <control> END OF GUARDED AREA
    start_of_string                         =>  "\x{98}",                               #98                    152  ctrl98                                     : <control> START OF STRING
    control_99                              =>  "\x{99}",                               #99                    153  ctrl99                                     : <control>
    single_character_intruducer             =>  "\x{9A}",                               #9A                    154  ctrl9a                                     : <control> SINGLE CHARACTER INTRODUCER
    control_sequence_introducer             =>  "\x{9B}",                               #9B                    155  ctrl9b                                     : <control> CONTROL SEQUENCE INTRODUCER
    string_terminator                       =>  "\x{9C}",                               #9C                    156  ctrl9c                                 : <control> STRING TERMINATOR
    operating_system_command                =>  "\x{9D}",                               #9D                    157  ctrl9d                                 : <control> OPERATING SYSTEM COMMAND
    privacy_message                         =>  "\x{9E}",                               #9E                    158  ctrl9e                                     : <control> PRIVACY MESSAGE
    application_program_command             =>  "\x{9F}",                               #9F                    159  ctrl9f                                     : <control> APPLICATION PROGRAM COMMAND
#########################################################################

#########################################################################
# KEYBOARD CONTROL
#########################################################################
#   Code        SHIFT+code  CTRL+code   ALT+code        Key
#   0;71        55          0;119       --              HOME (num keypad)
#   0;72        56          (0;141)     --              UP ARROW (num keypad)
#   0;73        57          0;132       --              PAGE UP (num keypad)
#   0;75        52          0;115       --              LEFT ARROW (num keypad)
#   0;77        54          0;116       --              RIGHT ARROW (num keypad)
#   0;79        49          0;117       --              END (num keypad)
#   0;80        50          (0;145)     --              DOWN ARROW (num keypad)
#   0;81        51          0;118       --              PAGE DOWN (num keypad)
#   0;82        48          (0;146)     --              INSERT (num keypad)
#   0;83        46          (0;147)     --              DELETE (num keypad)
#   (224;71)    (224;71)    (224;119)   (224;151)       HOME
#   (224;72)    (224;72)    (224;141)   (224;152)       UP ARROW
#   (224;73)    (224;73)    (224;132)   (224;153)       PAGE UP
#   (224;75)    (224;75)    (224;115)   (224;155)       LEFT ARROW
#   (224;77)    (224;77)    (224;116)   (224;157)       RIGHT ARROW
#   (224;79)    (224;79)    (224;117)   (224;159)       END
#   (224;80)    (224;80)    (224;145)   (224;154)       DOWN ARROW
#   (224;81)    (224;81)    (224;118)   (224;161)       PAGE DOWN
#   (224;82)    (224;82)    (224;146)   (224;162)       INSERT
#   (224;83)    (224;83)    (224;147)   (224;163)       DELETE
#   --          --          0;114       --              PRINT SCREEN
#   --          --          0;0         --              PAUSE/BREAK
#   8           8           127         (0)             BACKSPACE
#   13          --          10          (0)             ENTER
#   9           0;15        (0;148)     (0;165)         TAB
#   0;3         --          --          --              NULL

#########################################################################
# KEYBOARD KEYPAD CONTROL ##################################################################################################################################
    alternate_keypad                        =>  "\e=",                                  #1B:3D                 27, 61 = altequals                               : [DECKPAM] : Enter alternate keypad mode (VT52)
    numeric_keypad                          =>  "\e>",                                  #1B:3E                 27, 62 > altgraterthan:numkeypad                 : [DECKPNM] : Set numeric keypad mode (VT52)
#########################################################################
# KEYBOARD LED CONTROL ##################################################################################################################################
    led_off                                 =>  "\e[0q",                                # Esc [ 0 q                 #   Turn off all four leds                  : DECLL0
    led_1_on                                =>  "\e[1q",                                # Esc [ 1 q                 #   Turn on LED #1                          : DECLL1
    led_2_on                                =>  "\e[2q",                                # Esc [ 2 q                 #   Turn on LED #2                          : DECLL2
    led_3_on                                =>  "\e[3q",                                # Esc [ 3 q                 #   Turn on LED #3                          : DECLL3
    led_4_on                                =>  "\e[1q",                                # Esc [ 4 q                 #   Turn on LED #4                          : DECLL4
#########################################################################
# KEYBOARD KEY CONTROL ##################################################################################################################################
    keyboard_setkey                         =>  sub { echr(join(';',@_)."p") },
#########################################################################
# EXTENDED KEYPAD | SINGLE SHIFT 3
    single_shift_3                          =>  "\eO",                                  #1B:4F                 27, 79 O extkeypad:ss3                           : [EXTKEYPAD] : [SS3] Set single shift 3
    asterisk_numpad                         =>  "\eOm",                                 #1B:4F:6D              27, 79, 109 m numpadasterisk                     : Numeric Keypad Asterisk (*)
    solidus_numpad                          =>  "\eOn",                                 #1B:4F:6E              27, 79, 110 n numpadslash                        : Numeric Keypad Slash (/)
    plus_numpad                             =>  "\eOo",                                 #1B:4F:6F              27, 79, 111 o numpadplus                         : Numeric Keypad Plus (+)
    hypen_numpad                            =>  "\eOm",                                 #1B:4F:7A              27, 79, 122 z numpadminus                        : Numeric Keypad Minus (-)
    comma_numpad                            =>  "\eOl",                                 #1B:4F:6C              27, 79, 108 l numpadcomma                        : Numeric Keypad COMMA
    full_stop_numpad                        =>  "\eOn",                                 #1B:4F:7B              27, 79, 123 { numpadperiod                       : Numeric Keypad Period (.)
#########################################################################
    up_arrow                                =>  "\eOA",                                 #1B:4F:41              27, 79, 65 A escoa                               : [ARROW][UP]
    down_arrow                              =>  "\eOB",                                 #1B:4F:42              27, 79, 66 B escob                               : [ARROW][DOWN]
    right_arrow                             =>  "\eOC",                                 #1B:4F:43              27, 79, 67 C escoc                               : [ARROW][RIGHT]
    left_arrow                              =>  "\eOD",                                 #1B:4F:44              27, 79, 68 D escod                               : [ARROW][LEFT] [ESC][OD]
#########################################################################
    OE_esc                                  =>  "\eOE",                                 #1B:4F:45              27, 79, 69 E escoe                               : [ESC] OE
#########################################################################
#########################################################################
    OG_esc                                  =>  "\eOG",                                 #1B:4F:47              27, 79, 71 G escog                               : [ESC] OG
#########################################################################
#########################################################################
    OI_esc                                  =>  "\eOI",                                 #1B:4F:49              27, 79, 73 I escoi                               : [ESC] OI
    OJ_esc                                  =>  "\eOJ",                                 #1B:4F:4A              27, 79, 74 J escoj                               : [ESC] OJ
    OK_esc                                  =>  "\eOK",                                 #1B:4F:4B              27, 79, 75 K escok                               : [ESC] OK
    OL_esc                                  =>  "\eOL",                                 #1B:4F:4C              27, 79, 76 L escol                               : [ESC] OL
    OM_esc                                  =>  "\eOM",                                 #1B:4F:4D              27, 79, 77 M escom                               : [ESC] OM
    ON_esc                                  =>  "\eON",                                 #1B:4F:4E              27, 79, 78 N escon                               : [ESC] ON
    OO_esc                                  =>  "\eOO",                                 #1B:4F:4F              27, 79, 79 O escoo                               : [ESC] OO
#########################################################################
#########################################################################
    OT_esc                                  =>  "\eOT",                                 #1B:4F:54              27, 79, 79 T escot                               : [ESC] OT
    OU_esc                                  =>  "\eOU",                                 #1B:4F:55              27, 79, 79 U escou                               : [ESC] OU
    OV_esc                                  =>  "\eOV",                                 #1B:4F:56              27, 79, 79 V escov                               : [ESC] OV
    OW_esc                                  =>  "\eOW",                                 #1B:4F:57              27, 79, 79 W escow                               : [ESC] OW
    OX_esc                                  =>  "\eOX",                                 #1B:4F:58              27, 79, 79 X escox                               : [ESC] OX
    OY_esc                                  =>  "\eOY",                                 #1B:4F:59              27, 79, 79 Y escoy                               : [ESC] OY
    OZ_esc                                  =>  "\eOZ",                                 #1B:4F:5A              27, 79, 79 Z escoz                               : [ESC] OZ
#########################################################################
    zero_numpad                             =>  "\eOp",                                 #1B:4F:70              27, 79, 112 p numpad0                            : Numeric Keypad 0
    one_numpad                              =>  "\eOq",                                 #1B:4F:71              27, 79, 113 q numpad1                            : Numeric Keypad 1
    two_numpad                              =>  "\eOr",                                 #1B:4F:72              27, 79, 114 r numpad2                            : Numeric Keypad 2
    three_numpad                            =>  "\eOs",                                 #1B:4F:73              27, 79, 115 s numpad3                            : Numeric Keypad 3
    four_numpad                             =>  "\eOt",                                 #1B:4F:74              27, 79, 116 t numpad4                            : Numeric Keypad 4
    five_numpad                             =>  "\eOu",                                 #1B:4F:75              27, 79, 117 u numpad5                            : Numeric Keypad 5
    six_numpad                              =>  "\eOv",                                 #1B:4F:76              27, 79, 118 v numpad6                            : Numeric Keypad 6
    seven_numpad                            =>  "\eOw",                                 #1B:4F:77              27, 79, 119 w numpad7                            : Numeric Keypad 7
    eight_numpad                            =>  "\eOx",                                 #1B:4F:78              27, 79, 120 x numpad8                            : Numeric Keypad 8
    nine_numpad                             =>  "\eOy",                                 #1B:4F:79              27, 79, 121 y numpad9                            : Numeric Keypad 9
    lined_feed_numpad                       =>  "\x{00}\x{A6}",                         #1B:A6                 00, 166  ctrlaltlf:ctrlaltj                     : <control> [NUMPAD] LINE FEED
#########################################################################

#########################################################################
# NUMBER KEYS|CHARS
################################################################################
#   Code        SHIFT+code  CTRL+code   ALT+code        Key
#   49          33          --          0;120           1
#   50          64          0           0;121           2
#   51          35          --          0;122           3
#   52          36          --          0;123           4
#   53          37          --          0;124           5
#   54          94          30          0;125           6
#   55          38          --          0;126           7
#   56          42          --          0;126           8
#   57          40          --          0;127           9
#   48          41          --          0;129           0
#########################################################################
    zero                                    =>  "\x{30}",                               #30                    48 0 zero                                        : DIGIT ZERO
    zero_altesc                             =>  "\e[0",                                 #1B:5B:30              27, 91, 48 0 altesc0                             : [ALTESC][0]
#########################################################################
    one                                     =>  "\x{31}",                               #31                    49 1 one                                         : DIGIT ONE
    one_altesc                              =>  "\e[1",                                 #1B:5B:31              27, 91, 49 1 altesc1                             : [ALTESC][1]
    one_semicolon_altesc                    =>  "\e[1;",                                #1B:5B:31:3B           27, 91, 49, 59 ; altescisemicolon                : [ALTESC][1][;]
#########################################################################
    two                                     =>  "\x{32}",                               #32                    50 2 two                                         : DIGIT TWO
    two_altesc                              =>  "\e[2",                                 #1B:5B:32              27, 91, 50, 2 altesc2                            : [ALTESC][2]
#########################################################################
    three                                   =>  "\x{33}",                               #33                    51 3 three                                       : DIGIT THREE
    three_altesc                            =>  "\e[3",                                 #1B:5B:33              27, 91, 51, 3 altesc3                            : [ALTESC][3]
#########################################################################
    four                                    =>  "\x{34}",                               #34                    52 4 four                                        : DIGIT FOUR
    four_altesc                             =>  "\e[4",                                 #1B:5B:34              27, 91, 52, 4 altesc4                            : [ALTESC][4]
#########################################################################
#   Code        SHIFT+code  CTRL+code   ALT+code        Key
    five                                    =>  "\x{35}",                               #35                    53 5 five                                        : DIGIT FIVE
    five_altesc                             =>  "\e[5",                                 #1B:5B:35              27, 91, 53, 5 altesc5                            : [ALTESC][5]
#   (0;76)      53          (0;143)     --              5 (keypad)
#########################################################################
    six                                     =>  "\x{36}",                               #36                    54 6 six                                         : DIGIT SIX
    six_altesc                              =>  "\e[6",                                 #1B:5B:36              27, 91, 54 6 altesc6                             : [ALTESC][PGDW]
#########################################################################
    seven                                   =>  "\x{37}",                               #37                    55 7 seven                                       : DIGIT SEVEN
    seven_altesc                            =>  "\e[7",                                 #1B:5B:37              27, 91, 55 7 altesc7                             : [ALTESC][7]
#########################################################################
    eight                                   =>  "\x{38}",                               #38                    56 8 eight                                       : DIGIT EIGHT
    eight_altesc                            =>  "\e[8",                                 #1B:5B:38              27, 91, 56 8 altesc8                             : [ALTESC][8]
#########################################################################
    nine                                    =>  "\x{39}",                               #39                    57 9 nice                                        : DIGIT NINE
    nine_altesc                             =>  "\e[9",                                 #1B:5B:39              27, 91, 57 9 altesc9                             : [ALTESC][9]
#########################################################################


#########################################################################
# MATHEMETICAL KEYS|CHARS
#########################################################################


#########################################################################
    left_parenthesis                        =>  "\x{28}",                               #28                    40 ( opening_parenthesis                         : LEFT PARENTHESIS
    left_parenthesis_esc                    =>  "\e(",                                  #1B:28                 27, 40 ( alt_opening_parenthesis                 : [ALT] LEFT PARENTHESIS
#########################################################################
    right_parenthesis                       =>  "\x{29}",                               #29                    41 ) closing_parenthesis                         : RIGHT PARENTHESIS
    right_parenthesis_esc                   =>  "\e)",                                  #1B:29                 27, 41 ) alt_closing_parenthesis                 : [ALT] RIGHT PARENTHESIS
#########################################################################
    left_curly_bracket                      =>  "\x{7B}",                               #7B                   123 { opening_curly_bracket:left_brace            : LEFT CURLY BRACKET
    left_curly_bracket_esc                  =>  "\e{",                                  #1B:7B                 27, 123 { esc_opening_curly_bracket:esc_left_brace   : [ESC] LEFT CURLY BRACKET
#########################################################################
    right_curly_bracket                     =>  "\x{7D}",                               #7D                   125 } closing_curly_bracket:right_brace           : RIGHT CURLY BRACKET
#########################################################################
    left_square_bracket                     =>  "\x{5B}",                               #5B                    91 [ opening_square_bracket                      : LEFT SQUARE BRACKET
    left_square_bracket_esc                 =>  "\e[",                                  #1B:5B                 27, 91 [ altesc                                  : [ESC] LEFT SQUARE BRACKET
    left_square_bracket_ctrl                =>  "\x{1B}",                               #1B                    27  ctrl_opening_square_bracket                 : [CTRL] LEFT SQUARE BRACKET
    left_square_bracket_alt                 =>  "\x{00}\x{1C}",                         #00:1C                  0, 26  ctrlaltlsb                              : [ALT] SUBSTITUTE1D  27 [ ctrl_opening_square_bracket                  : [CTRL] LEFT SQUARE BRACKET
#########################################################################
    right_square_bracket                    =>  "\x{5D}",                               #5D                    93 ] closing_square_bracket                      : RIGHT SQUARE BRACKET
    right_square_bracket_esc                =>  "\e]",                                  #1B:5D                 27, 93 ] esc_closing_square_bracket              : [ESC] RIGHT SQUARE BRACKET
    right_square_bracket_ctrl               =>  "\x{1D}",                               #1D                    29  group_separator:ctrl5:is3                   : [CTRL] RIGHT SQUARE BRACKET [GS] <control> INFORMATION SEPARATOR THREE
    right_square_bracket_alt                =>  "\x{00}\x{1B}",                         #00:1B                  0, 29  ctrl_closing_square_bracket             : [ALT] RIGHT SQUARE BRACKET
    group_separator_esc                     =>  "\x{1B}\x{1D}",                         #1B:1D                 27, 31  alt_groupseparator                      : [ALT] CLOSING SQUARE BRACKET
#########################################################################
    less_than_sign                          =>  "\x{3C}",                               #3C                    60 < less_than:left_angle_bracket                : LESS-THAN SIGN
    left_double_angle_quotation_mark        =>  "\x{AB}",                               #AB                    171 « left_guillemet:chevrons                    : LEFT-POINTING DOUBLE ANGLE QUOTATION MARK
#########################################################################
    greater_than_sign                       =>  "\x{3E}",                               #3E                    62 > greater_than:right_angle_bracket            : GREATER-THAN SIGN
    righ_double_angle_quotation_mark        =>  "\x{BB}",                               #BB                    187 » right_guillemet:                           : RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK
#########################################################################

#########################################################################
#   Code        SHIFT+code  CTRL+code   ALT+code        Key
    solidus                                 =>  "\x{2F}",                               #2F                    47 / slash:virgule/divide                        : SOLIDUS
    solidus_esc                             =>  "\e/",                                  #1B:2F                 27, 47 / escslash:escvirgule                     : [ESC] SOLIDUS
    solidus_alt                             =>  "\x{00}\x{35}",                         #00:35                  0, 53 5 altslash:altvirgule                     : [ALT] SOLIDUS
    solidus_numpad_ctrl                     =>  "\x{00}\x{8E}",                         #00:8E                  0, 142  ctrlslash:ctrlvirgule                  : [NUMPAD][CTRL] SOLIDUS
    solidus_numpad_alt                      =>  "\x{00}\x{A4}",                         #00:A4                  0, 74 ¤ numpadaltslash:numpadaltvirgule         : [NUMPAD][ALT] SOLIDUS
#########################################################################
    reverse_solidus                         =>  "\x{5C}",                               #5C                    92 \ backslash                                   : REVERSE SOLIDUS
    reverse_solidus_esc                     =>  "\e\\",                                 #1B:5C                 27, 92 \ altbackslash                            : [ALT] REVERSE SOLIDUS
    reverse_solidus_ctrl                    =>  "\x{1C}",                               #1C                    28  file_separator:ctrl4:is4                        : [CTRL][\] : [FS] FILE SEPERATOR : <control> INFORMATION SEPARATOR FOUR
    reverse_solidus_ctrl_esc                =>  "\x{1B}\x{1C}",                         #1B:1C                 27, 28  ctrlescfs                               : [CTRL][ESC] : [FS] FILE SEPERATOR : <control> INFORMATION SEPARATOR FOUR
    reverse_solidus_alt                     =>  "\x{00}\x{2B}",                         #00:2B                  0, 43 + altfs                                   : [ALT] : [FS] FILE SEPERATOR : <control> INFORMATION SEPARATOR FOUR
#########################################################################

#########################################################################
    vertical_line                           =>  "\x{7C}",                               #7C                   124 | vertical_bar                                : VERTICAL LINE
    broken_bar                              =>  "\x{A6}",                               #A6                    166 ¦ brokenbar:broken_vertical_bar:parted_rule  : BROKEN BAR
#########################################################################

#########################################################################
    exclamation_mark                        =>  "\x{21}",                               #21                    33 ! factorial                                   : EXCLAMATION MARK : bang
    exclamation_mark_esc                    =>  "\e!",                                  #1B:21                 27, 33 ! ctrlalt_factorial:ctrlaltbang           : [CLTR+ALT] EXCLAMATION MARK
    exclamation_mark_inverted               =>  "\x{A1}",                               #A1                    161 ¡ inv_excl_mark                              : INVERTED EXCLAMATION MARK
#########################################################################
    question_mark                           =>  "\x{3F}",                               #3F                    63 ? question                                    : QUESTION MARK
    question_mark_esc                       =>  "\e?",                                  #1B:3F                 27, 63 ? altquestion                             : [ALT] QUESTION MARK
    question_mark_inverted                  =>  "\x{BF}",                               #BF                    191 ¿ turned_question_mark                       : INVERTED QUESTION MARK
#########################################################################

#########################################################################
    commercial_at                           =>  "\x{40}",                               #40                    64 @ at_sign                                     : COMMERCIAL AT
    commercial_at_esc                       =>  "\e@",                                  #1B:40                 27, 64 @ altat                                   : [ALT] COMMERCIAL AT
#########################################################################
    numeric_sign                            =>  "\x{23}",                               #23                    35 # numeric                                     : NUMBER SIGN
    numeric_sign_esc                        =>  "\e#",                                  #1B:23                 27, 35 # alt_numeric                             : [ALT] NUMBER SIGN
#########################################################################
    percent_sign                            =>  "\x{25}",                               #25                    37 % percent                                     : PERCENT SIGN
    percent_sign_esc                        =>  "\e%",                                  #1B:25                 27, 37 % altpercent                              : [ALT] PERCENT SIGN
#########################################################################
    ampersand                               =>  "\x{26}",                               #26                    38 & ampersand                                   : AMPERSAND
    ampersand_esc                           =>  "\e&",                                  #1B:26                 27, 38 & altampersand                            : [ALT] AMPERSAND
#########################################################################
    asterisk                                =>  "\x{2A}",                               #2A                    42 * asterisk                                    : ASTERISK : star
    asterisk_esc                            =>  "\e*",                                  #1B:2A                 27, 42 * altstar:altasterisk                     : [ALT] ASTERISK
    asterisk_keypad_shift                   =>  "\x{00}\x{90}",                         #00:90                  0, 144  keypadshiftasterisk                        : [ALT][KEYPAD] ASTERISK
    asterisk_keypad_ctrl                    =>  "\x{00}\x{4E}",                         #00:4E                  0, 78 M keypadctrlasterisk                      : [CTRL][KEYPAD] ASTERISK
#########################################################################
    plus                                    =>  "\x{2B}",                               #2B                    43 + plus                                        : PLUS SIGN
    plus_esc                                =>  "\e+",                                  #1B:2B                 27, 43 + altplus                                 : [ALT] PLUS SIGN
    plus_keypad_ctrl                        =>  "\x{00}\x{96}",                         #00:96                  0, 150  ctrlpluskeypad                         : [CTRL][KEYPAD] PLUS SIGN
    plus_keypad_alt                         =>  "\x{00}\x{37}",                         #00:37                  0, 55 7 altpluskeypad                           : [ALT][KEYPAD] PLUS SIGN
#########################################################################
    plus_minus                              =>  "\x{B1}",                               #B1                    177 ± pluminus                                   : PLUS-MINUS SIGN
#########################################################################
    hyphen                                  =>  "\x{2D}",                               #2D                    45 - minus                                       : HYPHEN-MINUS : hyphen or minus sign
    hyphen_esc                              =>  "\e-",                                  #1B:2D                 27, 45 - althyphen:altminus                      : [ALT] HYPHEN-MINUS
    hyphen_soft                             =>  "\x{AD}",                               #AD                    173  softhypen:discretionary_hyphen:shy         : SOFT HYPHEN
    hyphen_ctrl                             =>  "\x{1F}",                               #1F                    31  unit_separator:ctrl7:is1:US                 : [CTRL][KEYPAD] HYPHEN-MINUS : <control> INFORMATION SEPARATOR ONE
    hyphen_ctrlesc                          =>  "\x{1B}\x{1F}",                         #1B:1F                 27, 31  ctrlaltus                               : [ALTESC] INFORMATION SEPARATOR ONE
    hyphen_alt                              =>  "\x{00}\x{82}",                         #00:82                  0, 130  althyphen                              : [ALT] HYPHEN-MINUS
    hyphen_keypad_ctrl                      =>  "\x{00}\x{95}",                         #00:95                  0, 149  keypadctrlminus                            : [CTRL][KEYPAD] HYPHEN-MINUS
    hyphen_keypad_alt                       =>  "\x{00}\x{A4}",                         #00:A4                  0, 164 ¤ altpluskeypad                          : [ALT][KEYPAD] HYPHEN-MINUS
#########################################################################
    equals                                  =>  "\x{3D}",                               #3D                    61 = equals                                      : EQUALS SIGN
    equals_alt                              =>  "\x{00}\x{83}",                         #00:83                  0, 131  altequals                              : EQUALS SIGN
#########################################################################
    comma                                   =>  "\x{2C}",                               #2C                    44 , comma                                       : COMMA : decimal separator
    comma_esc                               =>  "\e,",                                  #1B:2C                 27, 44 , altcomma                                : [ALT] COMMA
    comma_ctrl                              =>  "\x{00}\x{33}",                         #00:33                  0, 51 3 ctrlcomma                               : [CTRL] COMMA
#########################################################################
    full_stop                               =>  "\x{2E}",                               #2E                    46 . period:dot:decimal_point                    : FULL STOP
    full_stop_esc                           =>  "\e.",                                  #1B:2E                 27, 46 . altdot:altpoint:altdecimal:altperiod    : [ALT] FULL STOP
    full_stop_ctrl                          =>  "\x{00}\x{34}",                         #00:34                  0, 52 4 ctrlperiod                              : [CTRL] FULL STOP
#########################################################################
    colon                                   =>  "\x{3A}",                               #3A                    58 : colon:division:scale                        : COLON
    colon_esc                               =>  "\e:",                                  #1B:3A                 27, 58 : altcolon:altdivision:altscale           : [ALT] COLON
#########################################################################
    semicolon                               =>  "\x{3B}",                               #3B                    59 ; semycolon:and_not                           : SEMICOLON
    semycolon_esc                           =>  "\e;",                                  #1B:3B                 27, 59 ; altsemycolon                            : [ALT] SEMICOLON
    semycolon_ctrl                          =>  "\x{00}\x{27}",                         #00:27                  0, 39 ' ctrlperiod                              : [CTRL] SEMICOLON
#########################################################################

#########################################################################
    not_sign                                =>  "\x{AC}",                               #AC                    172 ¬ not:angled_dash                            : NOT SIGN
    micro_sign                              =>  "\x{B5}",                               #B5                    181 μ micro:mu                                   : MICRO SIGN
    one_superscript                         =>  "\x{B9}",                               #B9                    185 ¹ supscr1                                    : SUPERSCRIPT ONE
    two_superscript                         =>  "\x{B2}",                               #B2                    178 ² supscr2:squared                            : SUPERSCRIPT TWO
    three_superscript                       =>  "\x{B3}",                               #B3                    179 ³ spscr3:cubed                               : SUPERSCRIPT THREE
    vulgar_fraction_one_quarter             =>  "\x{BC}",                               #BC                    188 ¼ fraction_1_4th                             : VULGAR FRACTION ONE QUARTER
    vulgar_fraction_one_half                =>  "\x{BD}",                               #BD                    189 ½ fraction_1_2th                             : VULGAR FRACTION ONE HALF
    vulgar_fraction_three_quarters          =>  "\x{BE}",                               #BE                    190 ¾ fraction_3_4th                             : VULGAR FRACTION THREE QUARTERS
    multiplication_sign                     =>  "\x{D7}",                               #D7                    215 × multiplication:vector:cross_product        : MULTIPLICATION SIGN
    middle_dot                              =>  "\x{B7}",                               #B7                    183 · midpoint:bullet:multiplication             : MIDDLE DOT
    division_sign                           =>  "\x{F7}",                               #F7                    247 ÷ devision:obelus                            : DIVISION SIGN
#########################################################################

#########################################################################
# COMMERCIAL CHARS
#########################################################################

#########################################################################
    dollar_sign                             =>  "\x{24}",                               #24                    36 $ dollar                                      : DOLLAR SIGN
    dollar_sign_esc                         =>  "\x{1B}\x{24}",                         #1B:24                 27, 36 $ altdollar                               : [ALT] DOLLAR SIGN
    cent_sign                               =>  "\x{A2}",                               #A2                    162 ¢ cent                                       : CENT SIGN
    pound_sign                              =>  "\x{A3}",                               #A3                    163 £ pound                                      : POUND SIGN
    currency_sign                           =>  "\x{A4}",                               #A4                    164 ¤ currency                                   : CURRENCY SIGN
    yen_sign                                =>  "\x{A5}",                               #A5                    165 ¥ yen:yuan                                   : YEN SIGN
#########################################################################
    copyright_sign                          =>  "\x{A9}",                               #A9                    169 © copyright                                  : COPYRIGHT SIGN
    registered_sign                         =>  "\x{AE}",                               #AE                    174 ® registerd:registered_trade_mark            : REGISTERED SIGN
#########################################################################

#########################################################################
# TEXT CHARS
#########################################################################

#########################################################################
    section_sign                            =>  "\x{A7}",                               #A7                    167 § section:paragraph                          : SECTION SIGN
    pilcrow_sign                            =>  "\x{B6}",                               #B6                    182 ¶ pilcrow:paragraph                          : PILCROW SIGN
#########################################################################
    apostrophe_quote                        =>  "\x{27}",                               #27                    39 ' apostrophe                                  : APOSTROPHE
    apostrophe_quote_esc                    =>  "\x{1B}\x{27}",                         #1B:27                 27, 39 ' altapostrophe:altquote                  : [ESC] APOSTROPHE
    apostrophe_quote_ctrl                   =>  "\x{00}\x{28}",                         #00:28                  0, 40 ( ctrlapostrophe                          : [CTRL] APOSTROPHE
#########################################################################
    quotation_mark                          =>  "\x{22}",                               #22                    34 " quotation                                   : QUOTATION MARK
    quotation_mark_esc                      =>  "\x{1B}\x{22}",                         #1B:22                 27, 34 " alt_quotation                           : [ESC] QUOTATION MARK
#########################################################################
    space                                   =>  "\x{20}",                               #20                    32  space                                       : SPACE
    space_esc                               =>  "\x{1B}\x{20}",                         #1B:20                 27, 32  ctrlaltspace                            : [ESC] SPACE
    space_nobreak                           =>  "\x{00A0}",                             #A0                    160  nbsp                                       : NO-BREAK SPACE
    space_en_quad                           =>  "\x{2000}",                             #  &#8192  En Quad [ ]
    space_em_quad                           =>  "\x{2001}",                             #  &#8193  Em Quad [ ]
    space_en                                =>  "\x{2002}",                             #  &#8194  En Space    [ ]
    space_em                                =>  "\x{2003}",                             #  &#8195  Em Space    [ ]
    space_em_three_per                      =>  "\x{2004}",                             #  &#8196  Three-Per-Em Space  [ ]
    space_em_four_per                       =>  "\x{2005}",                             #  &#8197  Four-Per-Em Space   [ ]
    space_em_six_per                        =>  "\x{2006}",                             #  &#8198  Six-Per-Em Space    [ ]
    space_figure                            =>  "\x{2007}",                             #  &#8199  Figure Space    [ ]
    space_punctuation                       =>  "\x{2008}",                             #  &#8200  Punctuation Space   [ ]
    space_thin                              =>  "\x{2009}",                             #  &#8201  Thin Space  [ ]
    space_hair                              =>  "\x{200A}",                             #  &#8202  Hair Space  [ ]
    space_line_seperator                    =>  "\x{2028}",                             #  &#8232  Line Seperator  [ ]
    space_medium_mathematical               =>  "\x{205F}",                             #  &#8287  Medium Mathematical Space   [ ]
    space_ideographic                       =>  "\x{3000}",                             #  &#12288 Ideographic Space   [　]
#########################################################################
    low_line                                =>  "\x{5F}",                               #5F                    95 _ spacing_underscore                          : LOW LINE
    low_line_esc                            =>  "\e_",                                  #1B:5F                 27, 95 _ alt_spacing_underscore                  : [ESC] LOW LINE
    macron                                  =>  "\x{AF}",                               #AF                    175 ¯ overline:apl:apl_overbar                   : MACRON
#########################################################################
    acccent_circumflex                      =>  "\x{5E}",                               #5E                    94 ^ up_arrowhead                                : CIRCUMFLEX ACCENT
    acccent_circumflex_alt                  =>  "\e^",                                  #1B:5E                 27, 94 ^ altcircumflexacccent                    : [ESC] CIRCUMFLEX ACCENT
#########################################################################
    accent_grave                            =>  "\x{60}",                               #60                    96 ` graveaccent                                 : GRAVE ACCENT
    accent_grave_esc                        =>  "\e`",                                  #1B:60                 27, 96 ` altgraveaccent                          : [ESC] GRAVE ACCENT
    accent_grave_ctrl                       =>  "\x{00}\x{29}",                         #00:29                  0, 41 ) ctrlgraveaccent                         : [CTRL] GRAVE ACCENT
#########################################################################
    tilde                                   =>  "\x{7E}",                               #7E                   126 ~ tilde                                       : TILDE
    tilde_esc                               =>  "\e~",                                  #1B:7E                 27,126 ~ alttilde                                : [ESC] TILDE
#########################################################################
    accent_diaeresis                        =>  "\x{A8}",                               #A8                    168 ¨ diaeresis                                  : DIAERESIS
#########################################################################
    feminine_ordinal_indicator              =>  "\x{AA}",                               #AA                    170 ª fem_ord_ind                                : FEMININE ORDINAL INDICATOR
    masculine_ordinal_indicator             =>  "\x{BA}",                               #BA                    186 º mas_ord_ind                                : MASCULINE ORDINAL INDICATOR
#########################################################################
    accent_degree                           =>  "\x{B0}",                               #B0                    176 ° degree:ring_above                          : DEGREE ACCENT
#########################################################################
    accent_acute                            =>  "\x{B4}",                               #B4                    180 ´ acute                                      : ACUTE ACCENT
#########################################################################
    accent_cedilla                          =>  "\x{B8}",                               #B8                    184 ¸ cedilla                                    : CEDILLA
#########################################################################


#########################################################################
# KEYBOARD KEY CONTROL ##################################################################################################################################
#
# Set Keyboard Strings:
# Redefines a keyboard key to a specified string.
# The parameters for this escape sequence are defined as follows:
# 
# Code is one or more of the values listed in the following table. These values 
# represent keyboard keys and key combinations. When using these values in a command,
# you must type the semicolons shown in this table in addition to the semicolons
# required by the escape sequence. The codes in parentheses are not available on
# some keyboards. ANSI.SYS will not interpret the codes in parentheses for those
# keyboards unless you specify the /X switch in the DEVICE command for ANSI.SYS.
# 
# String is either the ASCII code for a single character or a string contained in
# quotation marks. For example, both 65 and "A" can be used to represent an uppercase A.
# 
# IMPORTANT: Some of the values in the following table are not valid for all computers.
# Check your computer's documentation for values that are different.
# 
################################################################################
################################################################################
#########################################################################
#########################################################################
# LETTER CHARS
#########################################################################
#   Code        SHIFT+code  CTRL+code   ALT+code        Key
#   97          65          1           0;30            A
#   98          66          2           0;48            B
#   99          66          3           0;46            C
#   100         68          4           0;32            D
#   101         69          5           0;18            E
#   102         70          6           0;33            F
#   103         71          7           0;34            G
#   104         72          8           0;35            H
#   105         73          9           0;23            I
#   106         74         10           0;36            J
#   107         75         11           0;37            K
#   108         76         12           0;38            L
#   109         77         13           0;50            M
#   110         78         14           0;49            N
#   111         79         15           0;24            O
#   112         80         16           0;25            P
#   113         81         17           0;16            Q
#   114         82         18           0;19            R
#   115         83         19           0;31            S
#   116         84         20           0;20            T
#   117         85         21           0;22            U
#   118         86         22           0;47            V
#   119         87         23           0;17            W
#   120         88         24           0;45            X
#   121         89         25           0;21            Y
#   122         90         26           0;44            Z
#########################################################################
    'a'                                     =>  "\x{61}",                               #61                    97 a letter_a                                    : LATIN SMALL LETTER A
    a_grave                                 =>  "\x{E0}",                               #E0                    224 à letter_a_grave                             : LATIN SMALL LETTER A WITH GRAVE
    a_acute                                 =>  "\x{E1}",                               #E1                    225 á letter_a_acute                             : LATIN SMALL LETTER A WITH ACUTE
    a_circumflex                            =>  "\x{E2}",                               #E2                    226 â letter_a_circumflex                        : LATIN SMALL LETTER A WITH CIRCUMFLEX
    a_tilde                                 =>  "\x{E3}",                               #E3                    227 ã letter_a_tilde                             : LATIN SMALL LETTER A WITH TILDE
    a_diaeresis                             =>  "\x{E4}",                               #E4                    228 ä letter_a_diaeresis                         : LATIN SMALL LETTER A WITH DIAERESIS
    a_ringabove                             =>  "\x{E5}",                               #E5                    229 å letter_a_ringabote:letter_a_angstrom       : LATIN SMALL LETTER A WITH RING ABOVE
    a_alt                                   =>  "\ea",                                  #1B:61                 27, 97 a alta                                    : [ALT] small_a
#########################################################################
    'A'                                     =>  "\x{41}",                               #41                    65 A letter_A                                    : LATIN CAPITAL LETTER A
    A_alt                                   =>  "\eA",                                  #1B:41                 27, 65 A altA                                    : [ALT] LATIN CAPITAL LETTER A
    A_grave                                 =>  "\x{C0}",                               #C0                    192 À letter_A_grave                             : LATIN CAPITAL LETTER A WITH GRAVE
    A_acute                                 =>  "\x{C1}",                               #C1                    193 Á letter_A_acute                             : LATIN CAPITAL LETTER A WITH ACUTE
    A_circumflex                            =>  "\x{C2}",                               #C2                    194 Â letter_A_circumflex                        : LATIN CAPITAL LETTER A WITH CIRCUMFLEX
    A_tilde                                 =>  "\x{C3}",                               #C3                    195 Ã letter_A_tilde                             : LATIN CAPITAL LETTER A WITH TILDE
    A_diaeresis                             =>  "\x{C4}",                               #C4                    196 Ä letter_A_diaeresis                         : LATIN CAPITAL LETTER A WITH DIAERESIS
    A_ringabove                             =>  "\x{C5}",                               #C5                    197 Å letter_A_ringabove:letter_A_angstrom       : LATIN CAPITAL LETTER A WITH RING ABOVE
#########################################################################

#########################################################################
    ae                                      =>  "\x{E6}",                               #E6                    230 æ letter_ae                                  : LATIN SMALL LETTER AE
    AE                                      =>  "\x{C6}",                               #C6                    198 Æ letter_AE                                  : LATIN CAPITAL LETTER AE
#########################################################################

#########################################################################
    'b'                                     =>  "\x{62}",                               #62                    98 b letter_b                                    : LATIN SMALL LETTER B
    b_alt                                   =>  "\eb",                                  #1B:62                 27, 98 b altb                                    : [ALT] small_b
#########################################################################
    'B'                                     =>  "\x{42}",                               #42                    66 B letter_B                                    : LATIN CAPITAL LETTER B
    B_alt                                   =>  "\eB",                                  #1B:42                 27, 66 B altB                                    : [ALT] LATIN CAPITAL LETTER B
#########################################################################

#########################################################################
    'c'                                     =>  "\x{63}",                               #63                    99 c letter_c                                    : LATIN SMALL LETTER C
    c_cedilla                               =>  "\x{E7}",                               #E7                    231 ç letter_c_cedilla                           : LATIN SMALL LETTER C WITH CEDILLA
#########################################################################
    C_alt                                   =>  "\eC",                                  #1B:43                 27, 67 C altC                                    : [ALT] LATIN CAPITAL LETTER C
    'C'                                     =>  "\x{43}",                               #43                    67 C letter_C                                    : LATIN CAPITAL LETTER C
    C_cedilla                               =>  "\x{C7}",                               #C7                    199 Ç letter_C_cedilla                           : LATIN CAPITAL LETTER C WITH CEDILLA
#########################################################################
    'd'                                     =>  "\x{64}",                               #64                   100 d letter_d                                    : LATIN SMALL LETTER D
    d_alt                                   =>  "\ed",                                  #1B:64                 27,100 d altd                                    : [ALT] small_d
    'D'                                     =>  "\x{44}",                               #44                    68 D letter_D                                    : LATIN CAPITAL LETTER D
#########################################################################
    thorn                                   =>  "\x{FE}",                               #FE                    254 þ","LATIN SMALL LETTER THORN","• Icelandic, Old English, phonetics","• Runic letter borrowed into Latin script","→  ᚦ  runic letter thurisaz thurs thorn"],
    THORN                                   =>  "\x{DE}",                               #D7                    222 Þ capital_thorn                              : LATIN CAPITAL LETTER THORN
#########################################################################
    'e'                                     =>  "\x{65}",                               #65                   101 e letter_e                                    : LATIN SMALL LETTER E
    e_grave                                 =>  "\x{E8}",                               #E8                    232 è letter_e_grave                             : LATIN SMALL LETTER E WITH GRAVE
    e_acute                                 =>  "\x{E9}",                               #E9                    233 é letter_e_acute                             : LATIN SMALL LETTER E WITH ACUTE
    e_circumflex                            =>  "\x{EA}",                               #EA                    234 ê letter_e_circumflex                        : LATIN SMALL LETTER E WITH CIRCUMFLEX
    e_diaeresis                             =>  "\x{EB}",                               #EB                    235 ë letter_e_diaeresis                         : LATIN SMALL LETTER E WITH DIAERESIS
    e_alt                                   =>  "\ee",                                  #1B:65                 27,101 e alte                                    : [ALT] small_e
#########################################################################
    'E'                                     =>  "\x{45}",                               #45                    69 E letter_E                                    : LATIN CAPITAL LETTER E
    E_grave                                 =>  "\x{C8}",                               #C8                    200 È letter_E_grave                             : LATIN CAPITAL LETTER E WITH GRAVE
    E_acute                                 =>  "\x{C9}",                               #C9                    201 É letter_E_acute                             : LATIN CAPITAL LETTER E WITH ACUTE
    E_circumflex                            =>  "\x{CA}",                               #CA                    202 Ê letter_E_circumflex                        : LATIN CAPITAL LETTER E WITH CIRCUMFLEX
    E_diaeresis                             =>  "\x{CB}",                               #CB                    203 Ë letter_E_diaeresis                         : LATIN CAPITAL LETTER E WITH DIAERESIS
#########################################################################
    eth                                     =>  "\x{F0}",                               #F0                    240 ð letter_eth                                 : LATIN SMALL LETTER ETH
    #                                                                                   #F0:9F:98:97           48   😗   U+1F617     kissing face
    ETH                                     =>  "\x{D0}",                               #D0                    208 Ð letter_eth:letter_D_stroke:african_d       : LATIN CAPITAL LETTER ETH
#########################################################################
    'f'                                     =>  "\x{66}",                               #66                   102 f letter_f                                    : LATIN SMALL LETTER F
    f_alt                                   =>  "\ef",                                  #1B:66                 27,102 f altf                                    : [ALT] small_f
#########################################################################
    'F'                                     =>  "\x{46}",                               #46                    70 F letter_F                                    : LATIN CAPITAL LETTER F
#########################################################################
    'g'                                     =>  "\x{67}",                               #67                   103 g letter_g                                    : LATIN SMALL LETTER G
    g_alt                                   =>  "\eg",                                  #1B:67                 27,103 g altg                                    : [ALT] small_g
#########################################################################
    'G'                                     =>  "\x{47}",                               #47                    71 G letter_G                                    : LATIN CAPITAL LETTER G
#########################################################################
    'h'                                     =>  "\x{68}",                               #68                   104 h letter_h                                    : LATIN SMALL LETTER H
    h_alt                                   =>  "\eh",                                  #1B:68                 27,104 h alth                                    : [ALT] small_h
#########################################################################
    'H'                                     =>  "\x{48}",                               #48                    72 H letter_H                                    : LATIN CAPITAL LETTER H
#########################################################################
    'i'                                     =>  "\x{69}",                               #69                   105 i letter_i                                    : LATIN SMALL LETTER I
    i_grave                                 =>  "\x{EC}",                               #EC                    236 ì letter_i_grave                             : LATIN SMALL LETTER I WITH GRAVE
    i_acute                                 =>  "\x{ED}",                               #ED                    237 í letter_i_acute                             : LATIN SMALL LETTER I WITH ACUTE
    i_circumflex                            =>  "\x{EE}",                               #EE                    238 î letter_i_circumflex                        : LATIN SMALL LETTER I WITH CIRCUMFLEX
    i_diaeresis                             =>  "\x{EF}",                               #EF                    239 ï letter_i_diaeresis                         : LATIN SMALL LETTER I WITH DIAERESIS
    i_alt                                   =>  "\ei",                                  #1B:69                 27,105 i alti                                    : [ALT] small_i
#########################################################################
    'I'                                     =>  "\x{49}",                               #49                    73 I letter_I                                    : LATIN CAPITAL LETTER I
    I_grave                                 =>  "\x{CC}",                               #CC                    204 Ì letter_I_grave                             : LATIN CAPITAL LETTER I WITH GRAVE
    I_acute                                 =>  "\x{CD}",                               #CD                    205 Í letter_I_acute                             : LATIN CAPITAL LETTER I WITH ACUTE
    I_circumflex                            =>  "\x{CE}",                               #CE                    206 Î letter_I_circumflex                        : LATIN CAPITAL LETTER I WITH CIRCUMFLEX
    I_diaeresis                             =>  "\x{CF}",                               #CF                    207 Ï letter_I_diaresis                          : LATIN CAPITAL LETTER I WITH DIAERESIS
    I_alt                                   =>  "\eI",                                  #1B:49                 27, 73 I altI                                    : [ALT] LATIN CAPITAL LETTER I
#########################################################################

#########################################################################
    'j'                                     =>  "\x{6A}",                               #6A                   106 j letter_j                                    : LATIN SMALL LETTER J
    j_alt                                   =>  "\ej",                                  #1B:6A                 27,106 j altj                                    : [ALT] small_j
#########################################################################
    'J'                                     =>  "\x{4A}",                               #4A                    74 J letter_J                                    : LATIN CAPITAL LETTER J
    J_alt                                   =>  "\eJ",                                  #1B:4A                 27, 74 J altJ                                    : [ALT] LATIN CAPITAL LETTER J
#########################################################################

#########################################################################
    'k'                                     =>  "\x{6B}",                               #6B                   107 k letter_k                                    : LATIN SMALL LETTER K
    k_alt                                   =>  "\ek",                                  #1B:6B                 27,107 k altk                                    : [ALT] small_k
#########################################################################
    'K'                                     =>  "\x{4B}",                               #4B                    75 K letter_K                                    : LATIN CAPITAL LETTER K
    K_alt                                   =>  "\eK",                                  #1B:4B                 27, 75 K altK                                    : [ALT] LATIN CAPITAL LETTER K
#########################################################################

#########################################################################
    'l'                                     =>  "\x{6C}",                               #6C                   108 l letter_l                                    : LATIN SMALL LETTER L
    l_alt                                   =>  "\el",                                  #1B:6C                 27,108 l altl                                    : [ALT] small_l
#########################################################################
    'L'                                     =>  "\x{4C}",                               #4C                    76 L letter_L                                    : LATIN CAPITAL LETTER L
    L_alt                                   =>  "\eL",                                  #1B:4C                 27, 76 L altL                                    : [ALT] LATIN CAPITAL LETTER L
#########################################################################

#########################################################################
    'm'                                     =>  "\x{6D}",                               #6D                   109 m letter_m                                    : LATIN SMALL LETTER M
    m_alt                                   =>  "\em",                                  #1B:6D                 27,109 m altm                                    : [ALT] small_m
#########################################################################
    'M'                                     =>  "\x{4D}",                               #4D                    77 N letter_M                                    : LATIN CAPITAL LETTER M
    line_up                                 =>  "\eM",                                  #1B:4D                 27, 77 M altM:ri                                 : [RI] Move/scroll window down one line
#########################################################################

#########################################################################
    'n'                                     =>  "\x{6E}",                               #6E                   110 n letter_n                                    : LATIN SMALL LETTER N
    n_tilde                                 =>  "\x{F1}",                               #F1                    241 ñ letter_n_tilde                             : LATIN SMALL LETTER N WITH TILDE
    n_alt                                   =>  "\en",                                  #1B:6E                 27,110 n altn                                    : [ALT] small_n
#########################################################################
    'N'                                     =>  "\x{4E}",                               #4E                    78 M letter_N                                    : LATIN CAPITAL LETTER N
    N_tilde                                 =>  "\x{D1}",                               #D1                    209 Ñ letter_N_tilde                             : LATIN CAPITAL LETTER N WITH TILDE
    set_single_shift_2                      =>  "\eN",                                  #1B:4E                 27, 78 N altN:ss2                                : [SS2] Set single shift 2
#########################################################################

#########################################################################
    'o'                                     =>  "\x{6F}",                               #6F                   111 o letter_o                                    : LATIN SMALL LETTER O
    o_grave                                 =>  "\x{F2}",                               #F2                    242 ò letter_o_grave                             : LATIN SMALL LETTER O WITH GRAVE
    o_acute                                 =>  "\x{F3}",                               #F3                    243 ó letter_o_acute                             : LATIN SMALL LETTER O WITH ACUTE
    o_circumflex                            =>  "\x{F4}",                               #F4                    244 ô letter_o_circumflex                        : LATIN SMALL LETTER O WITH CIRCUMFLEX
    o_tilde                                 =>  "\x{F5}",                               #F5                    245 õ letter_o_tilde                             : LATIN SMALL LETTER O WITH TILDE
    o_diaeresis                             =>  "\x{F6}",                               #F6                    246 ö letter_o_diaeresis                         : LATIN SMALL LETTER O WITH DIAERESIS
    o_slash                                 =>  "\x{F8}",                               #F8                    248 ø letter_o_stroke:oslash:diameter_sign       : LATIN SMALL LETTER O WITH STROKE","= o slash","• Danish, Norwegian, Faroese, IPA","→  ⌀  "],
    o_esc                                   =>  "\eo",                                  #1B:6F                 27,111 o alto                                    : [ALT] small_o
#########################################################################
    'O'                                     =>  "\x{4F}",                               #4F                    79 O letter_O                                    : LATIN CAPITAL LETTER O
    O_grave                                 =>  "\x{D2}",                               #D2                    210 Ò letter_O_grave                             : LATIN CAPITAL LETTER O WITH GRAVE
    O_acute                                 =>  "\x{D3}",                               #D3                    211 Ó letter_O_acute                             : LATIN CAPITAL LETTER O WITH ACUTE
    O_circumflex                            =>  "\x{D4}",                               #D4                    212 Ô letter_O_circumflex                        : LATIN CAPITAL LETTER O WITH CIRCUMFLEX
    O_tilde                                 =>  "\x{D5}",                               #D5                    213 Õ letter_O_tilde                             : LATIN CAPITAL LETTER O WITH TILDE
    O_deaeresis                             =>  "\x{D6}",                               #D6                    214 Ö letter_O_diaeresis                         : LATIN CAPITAL LETTER O WITH DIAERESIS
    O_stroke                                =>  "\x{D8}",                               #D8                    216 Ø letter_O_stroke:letter_o_slash             : LATIN CAPITAL LETTER O WITH STROKE
#########################################################################

#########################################################################
    'p'                                     =>  "\x{70}",                               #70                   112 p letter_p                                    : LATIN SMALL LETTER P
    p_alt                                   =>  "\ep",                                  #1B:60                 27,112 p altp                                    : [ALT] small_p
#########################################################################
    'P'                                     =>  "\x{50}",                               #50                    80 P letter_P                                    : LATIN CAPITAL LETTER P
    P_alt                                   =>  "\eP",                                  #1B:50                 27, 80 P altP                                    : [ALT] LATIN CAPITAL LETTER P
#########################################################################

#########################################################################
    'q'                                     =>  "\x{71}",                               #71                   113 q letter_q                                    : LATIN SMALL LETTER Q
    q_alt                                   =>  "\eq",                                  #1B:61                 27,113 q altq                                    : [ALT] small_q
#########################################################################
    'Q'                                     =>  "\x{51}",                               #51                    81 Q letter_Q                                    : LATIN CAPITAL LETTER Q
    Q_alt                                   =>  "\eQ",                                  #1B:51                 27, 81 Q altQ                                    : [ALT] LATIN CAPITAL LETTER Q
#########################################################################

#########################################################################
    'r'                                     =>  "\x{72}",                               #72                   114 r letter_r                                    : LATIN SMALL LETTER R
    r_alt                                   =>  "\er",                                  #1B:62                 27,114 r altr                                    : [ALT] small_r
#########################################################################
    'R'                                     =>  "\x{52}",                               #52                    82 R letter_R                                    : LATIN CAPITAL LETTER R
    R_alt                                   =>  "\eR",                                  #1B:52                 27, 82 R altR                                    : [ALT] LATIN CAPITAL LETTER R
#########################################################################

#########################################################################
    's'                                     =>  "\x{73}",                               #73                   115 s letter_s                                    : LATIN SMALL LETTER S
    s_sharp                                 =>  "\x{DF}",                               #DF                    223 ß letter_s_sharp:eszett                      : LATIN SMALL LETTER SHARP S
    s_alt                                   =>  "\es",                                  #1B:63                 27,115 s alts                                    : [ALT] small_s
#########################################################################
    'S'                                     =>  "\x{53}",                               #53                    83 S letter_S                                    : LATIN CAPITAL LETTER S
    S_alt                                   =>  "\eS",                                  #1B:53                 27, 83 S altS                                    : [ALT] LATIN CAPITAL LETTER S
#########################################################################

#########################################################################
    't'                                     =>  "\x{74}",                               #74                   116 t letter_t                                    : LATIN SMALL LETTER T
    t_alt                                   =>  "\et",                                  #1B:64                 27,116 t altt                                    : [ALT] small_t
#########################################################################
    'T'                                     =>  "\x{54}",                               #54                    84 T letter_T                                    : LATIN CAPITAL LETTER T
    T_alt                                   =>  "\eT",                                  #1B:54                 27, 84 T altT                                    : [ALT] LATIN CAPITAL LETTER T
#########################################################################

#########################################################################
    'u'                                     =>  "\x{75}",                               #75                   117 u letter_u                                    : LATIN SMALL LETTER U
    u_grave                                 =>  "\x{F9}",                               #F9                    249 ù","LATIN SMALL LETTER U WITH GRAVE","• French, Italian","≡  u   $̀"],
    u_acute                                 =>  "\x{FA}",                               #FA                    250 ú","LATIN SMALL LETTER U WITH ACUTE","≡  u   $́"],
    u_circumflex                            =>  "\x{FB}",                               #FB                    251 û","LATIN SMALL LETTER U WITH CIRCUMFLEX","≡  u   $̂"],
    u_diaeresis                             =>  "\x{FC}",                               #FC                    252 ü","LATIN SMALL LETTER U WITH DIAERESIS","≡  u   $̈"],
    u_alt                                   =>  "\eu",                                  #1B:65                 27,117 u altu                                    : [ALT] small_u
#########################################################################
    'U'                                     =>  "\x{55}",                               #55                    85 U letter_U                                    : LATIN CAPITAL LETTER U
    U_alt                                   =>  "\eU",                                  #1B:55                 27, 85 U altU                                    : [ALT] LATIN CAPITAL LETTER U
    U_grave                                 =>  "\x{D9}",                               #D9                    217 Ù letter_U_grave                             : LATIN CAPITAL LETTER U WITH GRAVE
    U_acute                                 =>  "\x{DA}",                               #DA                    218 Ú letter_U_acute                             : LATIN CAPITAL LETTER U WITH ACUTE
    U_circumflex                            =>  "\x{DB}",                               #DB                    219 Û letter_U_circumflex                        : LATIN CAPITAL LETTER U WITH CIRCUMFLEX
    U_diaeresis                             =>  "\x{DC}",                               #DC                    220 Ü letter_u_diaeresis                         : LATIN CAPITAL LETTER U WITH DIAERESIS
#########################################################################

#########################################################################
    'v'                                     =>  "\x{76}",                               #76                   118 v letter_v                                    : LATIN SMALL LETTER V
    v_alt                                   =>  "\ev",                                  #1B:66                 27,118 v altv                                    : [ALT] small_v
#########################################################################
    'V'                                     =>  "\x{56}",                               #56                    86 V letter_V                                    : LATIN CAPITAL LETTER V
    V_alt                                   =>  "\eV",                                  #1B:56                 27, 86 V altV                                    : [ALT] LATIN CAPITAL LETTER V
#########################################################################

#########################################################################
    'w'                                     =>  "\x{77}",                               #77                   119 w letter_w                                    : LATIN SMALL LETTER W
    w_alt                                   =>  "\ew",                                  #1B:67                 27,119 w altw                                    : [ALT] small_w
#########################################################################
    'W'                                     =>  "\x{57}",                               #57                    87 W letter_W                                    : LATIN CAPITAL LETTER W
    W_alt                                   =>  "\eW",                                  #1B:57                 27, 87 W altW                                    : [ALT] LATIN CAPITAL LETTER W
#########################################################################

#########################################################################
    'x'                                     =>  "\x{78}",                               #78                   120 x letter_x                                    : LATIN SMALL LETTER X
    x_alt                                   =>  "\ex",                                  #1B:68                 27,120 x altx                                    : [ALT] small_x
#########################################################################
    'X'                                     =>  "\x{58}",                               #58                    88 X letter_X                                    : LATIN CAPITAL LETTER X
    X_alt                                   =>  "\eX",                                  #1B:58                 27, 88 X altX                                    : [ALT] LATIN CAPITAL LETTER X
#########################################################################

#########################################################################
    'y'                                     =>  "\x{79}",                               #79                   121 y letter_y                                    : LATIN SMALL LETTER Y
    y_alt                                   =>  "\ey",                                  #1B:69                 27,121 y alty                                    : [ALT] small_y
    y_acute                                 =>  "\x{FD}",                               #FD                    253 ý","LATIN SMALL LETTER Y WITH ACUTE","• Czech, Slovak, Icelandic, Faroese, Welsh, Malagasy","≡  y   $́"],
    y_diaeresis                             =>  "\x{FF}",                               #FF                    255 ÿ","LATIN SMALL LETTER Y WITH DIAERESIS","• French, medieval Hungarian orthography","• uppercase is  Ÿ","≡  y   $"],
#########################################################################
    'Y'                                     =>  "\x{59}",                               #59                    89 Y letter_Y                                    : LATIN CAPITAL LETTER Y
    Y_alt                                   =>  "\eY",                      #1B:59                 27, 89 Y altY                                    : [ALT] LATIN CAPITAL LETTER Y
    Y_acute                                 =>  "\x{DD}",                               #DD                    221 Ý letter_Y_acute                             : LATIN CAPITAL LETTER Y WITH ACUTE
#########################################################################

#########################################################################
    'z'                                     =>  "\x{7A}",                               #7A                   122 z letter_z                                    : LATIN SMALL LETTER Z
    z_alt                                   =>  "\ez",                                  #1B:7A                 27,122 z altz                                    : [ALT] small_z
#########################################################################
    'Z'                                     =>  "\x{5A}",                               #5A                    90 Z letter_Z                                    : LATIN CAPITAL LETTER Z 
#########################################################################


################################################################################
#
#   Icons
#
################################################################################
    icon                                    => {
        copy    =>  "\x{2397}", # ⎗ copy
        paste   =>  "\x{2398}", # ⎘ paste
        print   =>  "\x{2399}", # ⎙ print
        edit    =>  "\x{23CD}", # ⏍ edit
    },

################################################################################
#
#   Arrows
#
################################################################################

    arrow                                   => {
################################################################################
        small => {
            over => {
                left    =>  "\x{25C2}",             # ◂
                top     =>  "\x{25B4}",             # ▴
                right   =>  "\x{25B8}",             # ▸
                bottom  =>  "\x{25BE}",             # ▾
            },
            out => {
                left    =>  "\x{25C3}",             # ◃
                top     =>  "\x{25B5}",             # ▵
                right   =>  "\x{25B9}",             # ▹
                bottom  =>  "\x{25BF}",             # ▿
            },
        },
        medium => {
            over => {
                left    =>  "\x{25C0}",             # ◀
                top     =>  "\x{25B2}",             # ▲
                right   =>  "\x{25B6}",             # ▶
                bottom  =>  "\x{25BC}",             # ▼
            },
            out => {
                left    =>  "\x{25C1}",             # ◁
                top     =>  "\x{25B3}",             # △
                right   =>  "\x{25B7}",             # ▷
                bottom  =>  "\x{25BD}",             # ▽
            },
        },
        dir => {
            blt   =>  "\x{21B0}",             # ↰
            brt   =>  "\x{21B1}",             # ↱
            tlb   =>  "\x{21B2}",             # ↲
            trb   =>  "\x{21B3}",             # ↳
        }
################################################################################
    },


################################################################################
#
#   Box Drawing
#
################################################################################
#
#   Directions :
#       v = vertical
#       h = horizontal
#       l = left
#       t = top
#       r = right 
#       b = bottom
#
#   Styles :
#         = single
#       d = double
#       c = rounded (center break)
#       s = thick 
#       u = striped
#       e = dotted
#       u = underline type
#       f = freetype
#
#       a = aligned
#       w = wide
#       g = Grey
#       B = bar
#       I = ICON
#
################################################################################
# Borders 
################################################################################
    draw                                    =>  {
        # Undefined (No Border)
        none => { 
            # all borders & single line
            dot => " ",
            lt => ' ', rt => ' ', h => { l=>' ', h=>' ', r=>' ' }, v => { t=>' ', v=>' ', b=>' ' }, lb => ' ', rb => ' ',
            # vertical      ->  horizontal
            solid   => { lt=>'sr', rt=>'sl', lb=>'sr', rb=>'sl' },                  # v Nothing         h Solid
            double  => { lt=>'dr', rt=>'dl', lb=>'dr', rb=>'dl' },                  # v Nothing         h Double
            thin    => { lt=>'r',  rt=>'l',  lb=>'r',  rb=>'l'  },                  # v Nothing         h Thin
            dotted  => { lt=>'r',  rt=>'l',  lb=>'r',  rb=>'l'  },                  # v Nothing         h Dotted
            striped => { lt=>'r',  rt=>'l',  lb=>'r',  rb=>'l'  },                  # v Nothing         h Striped
        },
        # Solid Line
        solid => { 
            # all borders & single line
            dot => "middle_dot",
            lt => 'srsb', rt => 'slsb', h => {l=>'sr', h=>'sh', r=>'sl'}, v => {t=>'sb', v=>'sv', b=>'st'}, lb => 'stsr', rb => 'slst',
            # vertical      ->  horizontal
            double  => { lt=>'srsb', rt=>'slsb', lb=>'stsr', rb=>'slst' },          # v Solid           h Double
            thin    => { lt=>'rsb',  rt=>'lsb',  lb=>'str',  rb=>'lst'  },          # v Solid           h Thin
            dotted  => { lt=>'rsb',  rt=>'lsb',  lb=>'str',  rb=>'lst'  },          # v Solid           h Dotted
            striped => { lt=>'rsb',  rt=>'lsb',  lb=>'str',  rb=>'lst'  },          # v Solid           h Striped
            none    => { lt=>'sb',   rt=>'sb',   lb=>'st',   rb=>'st'   },          # v Solid           h Nothing
        },
        # Double Line
        double => { 
            # all borders & single line
            dot => "colon",
            lt=>'drdb', rt=>'dldb', h => {l=>'dr', h=>'dh', r=>'dl'}, v => {t=>'db', v=>'dv', b=>'dt'}, lb=>'dtdr', rb=>'dldt',
            # vertical      ->  horizontal
            solid   => { lt=>'srsb', rt=>'slsb', lb=>'stsr', rb=>'slst' },          # v Double          h Solid
            thin    => { lt=>'rdb',  rt=>'ldb',  lb=>'dtr',  rb=>'ldt'  },          # v Double          h Thin
            dotted  => { lt=>'rdb',  rt=>'ldb',  lb=>'dtr',  rb=>'ldt'  },          # v Double          h Dotted
            striped => { lt=>'rdb',  rt=>'ldb',  lb=>'dtr',  rb=>'ldt'  },          # v Double          h Striped
            none    => { lt=>'db',   rt=>'db',   lb=>'dt',   rb=>'dt'   },          # v Double          h Nothing
        },
        # Thin Line
        thin => { 
            # all borders & single line
            dot => "middle_dot",
            lt=>'rb', rt=>'lb', h => {l=>'r', h=>'h', r=>'l'}, v => {t=>'b', v=>'v', b=>'t'}, lb=>'tr', rb=>'lt',
            # vertical      ->  horizontal
            solid   => { lt=>'srb', rt=>'slb', lb=>'tsr', rb=>'slt' },              # v Single          h Solid
            double  => { lt=>'drb', rt=>'dlb', lb=>'tdr', rb=>'dlt' },              # v Single          h Double
            dotted  => { lt=>'crb', rt=>'clb', lb=>'ctr', rb=>'clt' },              # v Single          h Dotted
            striped => { lt=>'crb', rt=>'clb', lb=>'ctr', rb=>'clt' },              # v Single          h Striped
            none    => { lt=>'b',   rt=>'b',   lb=>'t',   rb=>'t'   },              # v Single          h Nothing
        },
        # Dotted Line
        dotted => { 
            # all borders & single line
            dot => "middle_dot",
            lt=>'rb', rt=>'lb', h => {l=>'r', h=>'eh', r=>'l'}, v => {t=>'b', v=>'ev', b=>'t'}, lb=>'tr', rb=>'lt',
            # vertical      ->  horizontal
            solid   => { lt=>'srb', rt=>'slb', lb=>'tsr', rb=>'slt' },              # v Dotted          h Solid
            double  => { lt=>'drb', rt=>'dlb', lb=>'tdr', rb=>'dlt' },              # v Dotted          h Double
            thin    => { lt=>'crb', rt=>'clb', lb=>'ctr', rb=>'clt' },              # v Dotted          h Thin
            striped => { lt=>'crb', rt=>'clb', lb=>'ctr', rb=>'clt' },              # v Single          h Striped
            none    => { lt=>'b',   rt=>'b',   lb=>'t',   rb=>'t'   },              # v Single          h Nothing
        },
        # Striped Line
        striped => { 
            # all borders & single line
            dot => "middle_dot",
            lt=>'rb', rt=>'lb', h => {l=>'r', h=>'uh', r=>'l'}, v => {t=>'b', v=>'uv', b=>'t'}, lb=>'tr', rb=>'lt',
            # vertical      ->  horizontal
            solid  => { lt=>'srb',  rt=>'slb',  lb=>'tsr',  rb=>'slt' },                # v Striped         h Solid
            double => { lt=>'drb',  rt=>'dlb',  lb=>'tdr',  rb=>'dlt' },                # v Striped         h Double
            thin   => { lt=>'crb',  rt=>'clb',  lb=>'ctr',  rb=>'clt' },                # v Striped         h Thin
            dotted => { lt=>'crb',  rt=>'clb',  lb=>'ctr',  rb=>'clt' },                # v Striped         h Dotted
            none   => { lt=>'b',    rt=>'b',    lb=>'t',    rb=>'t'   },                # v Striped         h Nothing
        },
    },
################################################################################
    ' '     =>  " ",        #       space
################################################################################
    u0387   =>  "\x{0387}", # · ╴   dot
    u02D9   =>  "\x{02D9}", # ˙ ╴   top-small-dot
################################################################################
    u02DA   =>  "\x{02DA}", # ˚ ╴   top small-circle
    u02F3   =>  "\x{02F3}", # ˳ ╴   bottom micro-circle
################################################################################
# Horizontal
    l       =>  "\x{2574}", # ╴     single-left
    h       =>  "\x{2500}", # ─     single-horizontal
    lr      =>  "\x{254C}", # ╌     single-left single-right
    r       =>  "\x{2576}", # ╶     single-right
    lsr     =>  "\x{257C}", # ╼     single-left thick-right
    slr     =>  "\x{257E}", # ╾     thick-left single-right
    sr      =>  "\x{257A}", # ╺     thick-right
    dr      =>  "\x{257A}", # ╺     thick-right
    sh      =>  "\x{2501}", # ━     thick-horizontal
    slsr    =>  "\x{254D}", # ╍     thick-left thick-right
    sl      =>  "\x{2578}", # ╸     thick-left
    dl      =>  "\x{2578}", # ╸     thick-left
    dh      =>  "\x{2550}", # ═     double-horizontal
    uh      =>  "\x{2504}", # ┄     stripped-horizontal
    eh      =>  "\x{2508}", # ┈     dotted-horizontal
    ush     =>  "\x{2505}", # ┅     striped-thick-horizontal
    esh     =>  "\x{2509}", # ┉ ⋯ … dotted-thick-horizontal
    u22EF   =>  "\x{22EF}", # ⋯…
    u2026   =>  "\x{2026}", # …
################################################################################
# Vertical
    b       =>  "\x{2577}", # ╷     single-bottom
    v       =>  "\x{2502}", # │     single-vertical
    t       =>  "\x{2575}", # ╵     single-top
    tb      =>  "\x{254E}", # ╎     single-top single-bottom
    tsb     =>  "\x{257D}", # ╽     single-top thick-bottom
    stb     =>  "\x{257F}", # ╿     thick-top single-bottom
    sb      =>  "\x{257B}", # ╻     thick-bottom
    db      =>  "\x{257B}", # ╻     thick-bottom
    sv      =>  "\x{2503}", # ┃     thick-vertical
    st      =>  "\x{2579}", # ╹     thick-top
    dt      =>  "\x{2579}", # ╹     thick-top
    stsb    =>  "\x{254F}", # ╏     thick-top thick-bottom
    dv      =>  "\x{2551}", # ║     double-vertical
    dwv     =>  "\x{2016}", # ‖     double-wide-vertical
    uv      =>  "\x{2506}", # ┆     striped-vertical
    ev      =>  "\x{250A}", # ┊     dotted-vertical
    usv     =>  "\x{2507}", # ┇     thick-striped-vertical
    esv     =>  "\x{250B}", # ┋     thick-dotted-vertical
################################################################################
# Vertical Right
    vr      =>  "\x{251C}", # ├     single-vertical single-right
    vdr     =>  "\x{255E}", # ╞     single-vertical double-right
    dvr     =>  "\x{255F}", # ╟     double-vertical single-right
    dvdr    =>  "\x{2560}", # ╠     double-vertical double-right
    vsr     =>  "\x{251D}", # ┝     single-vertical thick-right
    svr     =>  "\x{2520}", # ┠     thick-vertical single-right
    svsr    =>  "\x{2523}", # ┣     thick-vertical thick-right
    strb    =>  "\x{251E}", # ┞     thick-top single-right single-bottom
    trsb    =>  "\x{251F}", # ┟     single-top single-right thick-bottom
    stsrb   =>  "\x{2521}", # ┡     thick-top thick-right single-bottom
    tsrsb   =>  "\x{2522}", # ┢     single-top thick-right thick-bottom
################################################################################
# Vertical Left
    vl      =>  "\x{2524}", # ┤
    vdl     =>  "\x{2561}", # ╡
    dvl     =>  "\x{2562}", # ╢
    dvdl    =>  "\x{2563}", # ╣
    vsl     =>  "\x{2525}", # ┥
    svsl    =>  "\x{252B}", # ┫
    svl     =>  "\x{2528}", # ┨
    lstb    =>  "\x{2526}", # ┦
    ltsb    =>  "\x{2527}", # ┧
    stslb   =>  "\x{2529}", # ┩
    tslsb   =>  "\x{252A}", # ┪
################################################################################
# Horizontal Bottom
    hb      =>  "\x{252C}", # ┬
    dhdb    =>  "\x{2566}", # ╦
    shsb    =>  "\x{2533}", # ┳
    dhb     =>  "\x{2564}", # ╤
    u20B8   =>  "\x{20B8}", # ₸
    hdb     =>  "\x{2565}", # ╥
    hsb     =>  "\x{2530}", # ┰
    shb     =>  "\x{252F}", # ┯
    slrb    =>  "\x{252D}", # ┭
    lsrb    =>  "\x{252E}", # ┮
    slrsb   =>  "\x{2531}", # ┱
    lsrsb   =>  "\x{2532}", # ┲
################################################################################
# Horizontal Vertical Crossing
    vh      =>  "\x{253C}", # ┼
    dvdh    =>  "\x{256C}", # ╬
    svsh    =>  "\x{254B}", # ╋
    dvh     =>  "\x{256B}", # ╫
    vdh     =>  "\x{256A}", # ╪
    vslr    =>  "\x{253D}", # ┽
    vlsr    =>  "\x{253E}", # ┾
    vsh     =>  "\x{253F}", # ┿
    hstb    =>  "\x{2540}", # ╀
    htsb    =>  "\x{2541}", # ╁
    hsv     =>  "\x{2542}", # ╂
    slstrb  =>  "\x{2543}", # ╃
    lstsrb  =>  "\x{2544}", # ╄
    sltrsb  =>  "\x{2545}", # ╅
    ltsrsb  =>  "\x{2546}", # ╆
    shstb   =>  "\x{2547}", # ╇
    shtsb   =>  "\x{2548}", # ╈
    svslr   =>  "\x{2549}", # ╉
    svlsr   =>  "\x{254A}", # ╊
################################################################################
# Horizontal Top
    ht      =>  "\x{2534}", # ┴
    dhdt    =>  "\x{2569}", # ╩
    shst    =>  "\x{253B}", # ┻
    hdt     =>  "\x{2568}", # ╨
    dht     =>  "\x{2567}", # ╧
    sht     =>  "\x{2537}", # ┷
    hst     =>  "\x{2538}", # ┸
    sltr    =>  "\x{2535}", # ┵
    ltsr    =>  "\x{2536}", # ┶
    slstr   =>  "\x{2539}", # ┹
    lstsr   =>  "\x{253A}", # ┺
################################################################################
# Corner to Right Bottom
    rb      =>  "\x{250C}", # ┌
    crb     =>  "\x{256D}", # ╭
    drdb    =>  "\x{2554}", # ╔
    srsb    =>  "\x{250F}", # ┏
    drb     =>  "\x{2552}", # ╒
    rdb     =>  "\x{2553}", # ╓
    srb     =>  "\x{250D}", # ┍
    rsb     =>  "\x{250E}", # ┎
################################################################################
# Corner to Left Bottom
    lb      =>  "\x{2510}", # ┐
    clb     =>  "\x{256E}", # ╮
    dldb    =>  "\x{2557}", # ╗
    slsb    =>  "\x{2513}", # ┓
    ldb     =>  "\x{2556}", # ╖
    dlb     =>  "\x{2555}", # ╕
    slb     =>  "\x{2511}", # ┑
    lsb     =>  "\x{2512}", # ┒
################################################################################
# Corner to Top Right
    tr      =>  "\x{2514}", # └
    ctr     =>  "\x{2570}", # ╰
    dtdr    =>  "\x{255A}", # ╚
    stsr    =>  "\x{2517}", # ┗
    dtr     =>  "\x{2559}", # ╙
    tdr     =>  "\x{2558}", # ╘
    tsr     =>  "\x{2515}", # ┕
    str     =>  "\x{2516}", # ┖
################################################################################
# Corner to Left Top
    lt      =>  "\x{2518}", # ┘
    clt     =>  "\x{256F}", # ╯
    dldt    =>  "\x{255D}", # ╝
    slst    =>  "\x{251B}", # ┛
    ldt     =>  "\x{255C}", # ╜
    dlt     =>  "\x{255B}", # ╛
    slt     =>  "\x{2519}", # ┙
    lst     =>  "\x{251A}", # ┚
################################################################################
# HLINES
    u2055   =>  "\x{2055}", # ⁕‒–—―⏤‾
    u2012   =>  "\x{2012}", # ‒–—―⏤‾
    u2013   =>  "\x{2013}", # –—―⏤‾
    u2014   =>  "\x{2014}", # —―⏤‾
    u2015   =>  "\x{2015}", # ―⏤‾
    u23E4   =>  "\x{23E4}", # ⏤‾
    u203E   =>  "\x{203E}", # ‾
    u2017   =>  "\x{2017}", # ‗₌⁼
    u208C   =>  "\x{208C}", # ₌⁼
    u207C   =>  "\x{207C}", # ⁼
################################################################################
    u27DD   =>  "\x{27DD}", # ⟝⟞
    u27DE   =>  "\x{27DE}", # ⟞
################################################################################
    u23C9   =>  "\x{23C9}", # ⏉     thin-horizontal-top long-vertical-center
    u23CA   =>  "\x{23CA}", # ⏊     thin-horizontal-bottom long-vertical-center
    u22BA   =>  "\x{22BA}", # ⊺
    u02EB   =>  "\x{02EB}", # ˫
    u22A6   =>  "\x{22A6}", # ⊦
    u23D0   =>  "\x{23D0}", # ⏐ <- Wherer is my Vertical ?
################################################################################
    u2044   =>  "\x{2044}", # ⁄
    u2216   =>  "\x{2216}", # ∖
################################################################################
    u27DB   =>  "\x{27DB}", # ⟛
################################################################################
    u27DA   =>  "\x{27DA}", # ⟚
################################################################################
    u27D9   =>  "\x{27D9}", # ⟙     horizontal-top long-vertical-center
    u27D8   =>  "\x{27D8}", # ⟘⚊⚋   horizontal-bottom long-vertical-center
    ftrb    =>  "\x{22A2}", # ⊢−⊣   horizontal-center short-vertical-left
    fltb    =>  "\x{22A3}", # ⊣     horizontal-center short-vertical-right
    flrb    =>  "\x{22A4}", # ⊤ ⊤   horizontal-top short-vertical-center
    u01C2   =>  "\x{01C2}", # ǂ
    fltr    =>  "\x{22A5}", # ⊥ ∣   horizontal-bottom short-vertical-center
    u2351   =>  "\x{2351}", # ⍑     double-horizontal-top long-vertical-center
    ftb     =>  "\x{2223}", # ∣     long-vertical-center
    flr     =>  "\x{2212}", # −
    u234A   =>  "\x{234A}", # ⍊⚊    double-horizontal-bottom long-vertical-center
################################################################################
################################################################################
    u02C8   =>  "\x{02C8}", # ˈˌˉˍ  top-vertical
    u02CC   =>  "\x{02CC}", # ˌ     bottom-vertical
    u02C9   =>  "\x{02C9}", # ˉ‐‑ˍ  top-horizontal
    u2010   =>  "\x{2010}", # ‐
    u2011   =>  "\x{2011}", # ‑
    u02CD   =>  "\x{02CD}", # ˍ     bottom-horizontal
################################################################################
    u230C   =>  "\x{230C}", # ⌌ ⌍ˌ
    u230E   =>  "\x{230E}", # ⌎ ˈ⌏
    u230D   =>  "\x{230D}", # ⌍
    u230F   =>  "\x{230F}", # ⌏
################################################################################
    u04CF   =>  "\x{04CF}", # ӏ
    u01C0   =>  "\x{01C0}", # ǀ
    u01C1   =>  "\x{01C1}", # ǁ
################################################################################
    u22A8   =>  "\x{22A8}", # ⊨⋕
    u22AB   =>  "\x{22AB}", # ⊫⋕
    u22A7   =>  "\x{22A7}", # ⊧⋕
    u22D5   =>  "\x{22D5}", # ⋕
    u2225   =>  "\x{2225}", # ∥
################################################################################
    u22A9   =>  "\x{22A9}", # ⊩
    u22AA   =>  "\x{22AA}", # ⊪
################################################################################
    u231C   =>  "\x{231C}", # ⌜
    u231D   =>  "\x{231D}", # ⌝
    u231F   =>  "\x{231F}", # ⌟
    u231E   =>  "\x{231E}", # ⌞
################################################################################
    u02EA   =>  "\x{02EA}", # ˪ ⏌
    u23BE   =>  "\x{23BE}", # ⎾ ⏋
    u23BF   =>  "\x{23BF}", # ⎿ ⏌
    u23CB   =>  "\x{23CB}", # ⏋
    u23CC   =>  "\x{23CC}", # ⏌
################################################################################
################################################################################
    u2310   =>  "\x{2310}", # ⌐
    u2319   =>  "\x{2319}", # ⌙
    u029F   =>  "\x{029F}", # ʟ
    u0393   =>  "\x{0393}", # Γ
################################################################################
    u02E5   =>  "\x{02E5}", # ˥
    u02E6   =>  "\x{02E6}", # ˦⁻
    u02E7   =>  "\x{02E7}", # ˧
    u208B   =>  "\x{208B}", # ₋⁻
    u207B   =>  "\x{207B}", # ⁻
    u02E8   =>  "\x{02E8}", # ˨₋
    u02E9   =>  "\x{02E9}", # ˩
################################################################################
    u02F9       =>  "\x{02F9}",         # ˹˺˻˼
    u02FA       =>  "\x{02FA}",         # ˺
    u02FC       =>  "\x{02FC}",         # ˼
    u02FB       =>  "\x{02FB}",         # ˻˼
################################################################################
# Blocks Barr [ left-top, top-right, left-bottom, right-bottom ] = 0 | 1
    B0000   =>  "\x{00A0}", #  
    B0001   =>  "\x{2597}", # ▗
    B0010   =>  "\x{2596}", # ▖
    B0011   =>  "\x{2584}", # ▄
    B0100   =>  "\x{259D}", # ▝
    B0101   =>  "\x{2590}", # ▐
    B0110   =>  "\x{259E}", # ▞
    B0111   =>  "\x{259F}", # ▟
    B1000   =>  "\x{2598}", # ▘
    B1001   =>  "\x{259A}", # ▚
    B1010   =>  "\x{258C}", # ▌
    B1011   =>  "\x{2599}", # ▙
    B1100   =>  "\x{2580}", # ▀
    B1101   =>  "\x{259C}", # ▜
    B1110   =>  "\x{259B}", # ▛
    B1111   =>  "\x{2588}", # █
################################################################################
# Special Blocks
    u220E   =>  "\x{220E}", # ∎ ??
    BA000   =>  "\x{25A0}", # ■ Reversed SPace
    BA001   =>  "\x{2581}", # ▁ Bottom Horizontal Edge
    BA002   =>  "\x{2594}", # ▔ Top Horizontal Edge
    BA003   =>  "\x{23B8}", # ⎸Ultra Left Vertical Edge
    BA004   =>  "\x{258F}", # ▏ Left Vertical Edge
    BA005   =>  "\x{2595}", # ▕ Right Vertical Edge
    BA006   =>  "\x{23B9}", # ⎹ UltraRight Vertical Edge
    ulr     =>  "\x{268B}", # ⚋ ⚊−˭Ξ    horizontal-under-left-right
    uln     =>  "\x{268A}", # ⚊ −˭Ξ     horizontal-under
    flr    =>  "\x{2212}",  # − ˭Ξ      horizontal-center
    u02ED  =>  "\x{02ED}",  # ˭Ξ        horizontal-over
    u039E  =>  "\x{039E}",  # Ξ
################################################################################
# Greys & Spaces ' '░'▒'▓'█'■'
# Greys & Spaces
    gray_0  => sub { tc('B0000') },     # ' '
    gray_1  => sub { tc('lgsp') },      # '░'
    gray_2  => sub { tc('mgsp') },      # '▒'
    gray_3  => sub { tc('dgsp') },      # '▓'
    gray_4  => sub { tc('B1111') },     # '█'
    gray_5  => sub { tc('BA000') },     # '■'
    lgsp    =>  "\x{2591}",             # ░
    mgsp    =>  "\x{2592}",             # ▒
    dgsp    =>  "\x{2593}",             # ▓
    rvsp    =>  sub { tc('BA000',@_) }, # ■ Reversed SPace
    blsp    =>  sub { tc('B1111',@_) }, # █ Black NonBlocking SPace
    nbsp    =>  sub { tc('B0000',@_) }, #   NonBlocking SPace
################################################################################
# Vertical ProgressBar  ' '▁'▂'▃'▄'▅'▆'▇'█'
    vbar      => sub { 
        my ($h,$p)=@_;
        my $l="";
        my $pr=$p*($h/100);
        for (my $i=0;$i<$h;$i++){
            if ($i<int($pr)) { $l.=tc('vbar_8') }
            elsif ($i>int($pr)) { $l.=tc('vbar_0') }
            else {
                my $cw=($pr-int($pr));
                my $b=int(($cw ? 8*$cw : 0));
                if ($b<0) {$b=0}
                if ($b>8) {$b=8}
                $l.=tc("vbar_$b")
            }
        }
        return $l
    },
    vbar_0    => sub { tc('B0000') },
    vbar_1    => "\x{2581}",
    vbar_2    => "\x{2582}",
    vbar_3    => "\x{2583}",
    vbar_4    => "\x{2584}",
    vbar_5    => "\x{2585}",
    vbar_6    => "\x{2586}",
    vbar_7    => "\x{2587}",
    vbar_8    => sub { tc('B1111',@_) },
################################################################################
# Horizontal ProgressBar ' '▏'▎'▍'▌'▋'▊'▉'█'
    hbar      => sub { 
        my ($w,$p)=@_;
        my $l="";
        my $pr=$p*($w/100);
        for (my $i=0;$i<$w;$i++){
            if ($i<int($pr)) { $l.=tc('hbar_8') }
            elsif ($i>int($pr)) { $l.=tc('hbar_0') }
            else {
                my $cw=($pr-int($pr));
                my $b=int(($cw ? 8*$cw : 0));
                if ($b<0) {$b=0}
                if ($b>8) {$b=8}
                $l.=tc("hbar_$b")
            }
        }
        return $l
    },
    hbar_0    => sub { tc('B0000') },       # ' '
    hbar_1    => "\x{258F}",                # '▏'
    hbar_2    => "\x{258E}",                # '▎'
    hbar_3    => "\x{258D}",                # '▍'
    hbar_4    => "\x{258C}",                # '▌'
    hbar_5    => "\x{258B}",                # '▋'
    hbar_6    => "\x{258A}",                # '▊'
    hbar_7    => "\x{2589}",                # '▉'
    hbar_8    => sub { tc('B1111') },       # '█'
################################################################################
    u2758   =>  "\x{2758}", # ❘❙❚
    u2759   =>  "\x{2759}", # ❙❚
    u275A   =>  "\x{275A}", # ❚
################################################################################
# Vertical ProgressLine       # ' '⎺'‾'⎻'⎼'⎽'⎯'‗'
    hline_1   => "\x{23BA}",  # '⎺'
    hline_2   => "\x{203E}",  # '‾'
    hline_3   => "\x{23BB}",  # '⎻'
    hline_4   => "\x{23BC}",  # '⎼'
    hline_5   => "\x{2012}",  # '‒'
    hline_6   => "\x{23BD}",  # '⎽'
    hline_7   => "\x{23AF}",  # '⎯'
    hline_8   => "\x{2017}",  # '‗'
################################################################################
# Diagonal Lines
    lbrt    =>  "\x{2571}", # ╱
    rblt    =>  "\x{2572}", # ╲
    trbl    =>  "\x{2573}", # ╳
################################################################################
    u2215   =>  "\x{2215}", # ∕
################################################################################

################################################################################
    ChBxHa  =>  "\x{25F7}",              # ◷
    ChBxHb  =>  "\x{25F6}",              # ◶
    ChBxHc  =>  "\x{25F5}",              # ◵
    ChBxHd  =>  "\x{25F4}",              # ◴
################################################################################
    ChBxIa  =>  "\x{25D4}",              # ◔
    ChBxIb  =>  "\x{25D1}",              # ◑
    ChBxIc  =>  "\x{25D5}",              # ◕
    ChBxId  =>  "\x{25CF}",              # ●
    ChBxIe  =>  "\x{25D2}",              # ◒
    ChBxIf  =>  "\x{25D0}",              # ◐
    ChBxIg  =>  "\x{25D3}",              # ◓
    ChBxIh  =>  "\x{25D6}",              # ◖
    ChBxIi  =>  "\x{25D7}",              # ◗
################################################################################
    ChBxKa  =>  "\x{25DB}",              # ◛
    ChBxKb  =>  "\x{25D9}",              # ◙
    ChBxKc  =>  "\x{25DA}",              # ◚
################################################################################
    ChBxLb  =>  "\x{25E0}",              # ◠
    ChBxLe  =>  "\x{25E1}",              # ◡
    ChBxLa  =>  "\x{25DC}",              # ◜◝
    ChBxLc  =>  "\x{25DD}",              # ◝
    ChBxLd  =>  "\x{25DE}",              # ◞
    ChBxLf  =>  "\x{25DF}",              # ◟◞
################################################################################


################################################################################
# Square Check Boxes
################################################################################
    CB1a    =>  "\x{25FD}", # ◽
    CB1b    =>  "\x{25FE}", # ◾
################################################################################
# Round Boxes
################################################################################
    CB2a    =>  "\x{25A2}", # ▢
    CB2b    =>  "\x{239A}", # ⎚
    u20E2   =>  "\x{20E2}", #  ⃢ 
################################################################################
# Special Boxes
################################################################################
    u20DE   =>  "\x{20DE}", #  ⃞
    u20E4   =>  "\x{20E4}", #  ⃤ 
    u20DF   =>  "\x{20DF}", #  ⃟
    u20DD   =>  "\x{20DD}", #  ⃝
    u20E0   =>  "\x{20E0}", #  ⃠
################################################################################
# Ruitjes
################################################################################
    ChBxCa  =>  "\x{25C6}", # ◆
    ChBxCb  =>  "\x{25C7}", # ◇
    ChBxCc  =>  "\x{25C8}", # ◈
    u22C4   =>  "\x{22C4}", # ⋄
################################################################################
# Square Boxes
################################################################################
    SB1a    =>  "\x{25A4}", # ▤
    SB2a    =>  "\x{25A7}", # ▧
    SB1b    =>  "\x{25A5}", # ▥
    SB2b    =>  "\x{25A8}", # ▨
    SB1c    =>  "\x{25A6}", # ▦
    SB2c    =>  "\x{25A9}", # ▩
################################################################################
    u2610   =>  "\x{2610}", # ☐
    u2611   =>  "\x{2611}", # ☑
    u2612   =>  "\x{2612}", # ☒
################################################################################
    u22A0   =>  "\x{22A0}", # ⊠
    u22A1   =>  "\x{22A1}", # ⊡
    u229E   =>  "\x{229E}", # ⊞
    u229F   =>  "\x{229F}", # ⊟
################################################################################
    CB4b    =>  "\x{25AB}", # ▫
    CB4a    =>  "\x{25AA}", # ▪
    CB3a    =>  "\x{25FB}", # ◻
    CB3b    =>  "\x{25FC}", # ◼
    ChBx4a  =>  "\x{25A1}", # □
    CB2b    =>  "\x{25A3}", # ▣
################################################################################
    ChBx4h  =>  "\x{25E7}", # ◧
    ChBx4i  =>  "\x{25E8}", # ◨
################################################################################
    ChBx4t  =>  "\x{25F3}", # ◳
    ChBx4u  =>  "\x{25EB}", # ◫
    ChBx4v  =>  "\x{25F1}", # ◱
    ChBx4w  =>  "\x{25F0}", # ◰
    ChBx4x  =>  "\x{25F2}", # ◲
################################################################################
    ChBx4p  =>  "\x{25F8}", # ◸
    ChBx4l  =>  "\x{25E4}", # ◤
    ChBx4j  =>  "\x{25E9}", # ◩
    ChBx4k  =>  "\x{25EA}", # ◪
    ChBx4n  =>  "\x{25E2}", # ◢
    ChBx4r  =>  "\x{25FF}", # ◿
################################################################################
    ChBx4q  =>  "\x{25F9}", # ◹
    ChBx4m  =>  "\x{25E5}", # ◥
    ChBx4s  =>  "\x{25FA}", # ◺
    ChBx4o  =>  "\x{25E3}", # ◣
################################################################################
    u22BF   =>  "\x{22BF}", # ⊿
    u274D   =>  "\x{274D}", # ❍
    u274F   =>  "\x{274F}", # ❏
    u2751   =>  "\x{2751}", # ❑
    u2750   =>  "\x{2750}", # ❐
    u2752   =>  "\x{2752}", # ❒
################################################################################


################################################################################
# Chess     ♔ ♕ ♖ ♗ ♘ ♙     ♚ ♛ ♜ ♝ ♞ ♟
    chess   =>  ["\x{2654}","\x{2655}","\x{2656}","\x{2657}","\x{2658}","\x{2659}","\x{265A}","\x{265B}","\x{265C}","\x{265D}","\x{265E}","\x{265F}"],
################################################################################
# Dice      ⚀ ⚁ ⚂ ⚃ ⚄ ⚅
    dice    =>  ["\x{2680}","\x{2681}","\x{2682}","\x{2683}","\x{2684}","\x{2685}"],
################################################################################
    u2618   =>  "\x{2618}",             # ☘
################################################################################
    u2660   =>  "\x{2660}",             # ♠
    u2664   =>  "\x{2664}",             # ♤
    u2665   =>  "\x{2665}",             # ♥
    u2661   =>  "\x{2661}",             # ♡
    u2666   =>  "\x{2666}",             # ♦
    u2662   =>  "\x{2662}",             # ♢
    u2663   =>  "\x{2663}",             # ♣
    u2667   =>  "\x{2667}",             # ♧
################################################################################

################################################################################
# 1F030 Domino Tiles 1F093
#   Horizontal tiles
#   1F030 🀰 DOMINO TILE HORIZONTAL BACK
    domino => {
        back => {   h=>"🀰", v=>"🁢"  },  # 1F030 🀰 1F062 🁢 DOMINO TILE HORIZONTAL,VERTICAL BACK
        #   Zeroes
        0 => {
            0 => {  h=>"🀱", v=>"🁣"  },  #   1F031 🀱 1F063 🁣 DOMINO TILE HORIZONTAL,VERTICAL-00-00
            1 => {  h=>"🀲", v=>"🁤"  },  #   1F032 🀲 1F064 🁤 DOMINO TILE HORIZONTAL,VERTICAL-00-01
            2 => {  h=>"🀳", v=>"🁥"  },  #   1F033 🀳 1F065 🁥 DOMINO TILE HORIZONTAL,VERTICAL-00-02
            3 => {  h=>"🀴", v=>"🁦"  },  #   1F034 🀴 1F066 🁦 DOMINO TILE HORIZONTAL,VERTICAL-00-03
            4 => {  h=>"🀵", v=>"🁧"  },  #   1F035 🀵 1F067 🁧 DOMINO TILE HORIZONTAL,VERTICAL-00-04
            5 => {  h=>"🀶", v=>"🁨"  },  #   1F036 🀶 1F068 🁨 DOMINO TILE HORIZONTAL,VERTICAL-00-05
            6 => {  h=>"🀷", v=>"🁩"  },  #   1F037 🀷 1F069 🁩 DOMINO TILE HORIZONTAL,VERTICAL-00-06
        },
        #   Ones
        1 => {
            0 => {  h=>"🀸", v=>"🁪"  },  #   1F038 🀸 1F06A 🁪 DOMINO TILE HORIZONTAL,VERTICAL-01-00
            1 => {  h=>"🀹", v=>"🁫"  },  #   1F039 🀹 1F06B 🁫 DOMINO TILE HORIZONTAL,VERTICAL-01-01
            2 => {  h=>"🀺", v=>"🁬"  },  #   1F03A 🀺 1F06C 🁬 DOMINO TILE HORIZONTAL,VERTICAL-01-02
            3 => {  h=>"🀻", v=>"🁭"  },  #   1F03B 🀻 1F06D 🁭 DOMINO TILE HORIZONTAL,VERTICAL-01-03
            4 => {  h=>"🀼", v=>"🁮"  },  #   1F03C 🀼 1F06E 🁮 DOMINO TILE HORIZONTAL,VERTICAL-01-04
            5 => {  h=>"🀽", v=>"🁯"  },  #   1F03D 🀽 1F06F 🁯 DOMINO TILE HORIZONTAL,VERTICAL-01-05
            6 => {  h=>"🀾", v=>"🁰"  },  #   1F03E 🀾 1F070 🁰 DOMINO TILE HORIZONTAL,VERTICAL-01-06
        },

#   Twos
#   1F03F 🀿 DOMINO TILE HORIZONTAL-02-00
#   1F040 🁀 DOMINO TILE HORIZONTAL-02-01
#   1F041 🁁 DOMINO TILE HORIZONTAL-02-02
#   1F042 🁂 DOMINO TILE HORIZONTAL-02-03
#   1F043 🁃 DOMINO TILE HORIZONTAL-02-04
#   1F044 🁄 DOMINO TILE HORIZONTAL-02-05
#   1F045 🁅 DOMINO TILE HORIZONTAL-02-06
#   Twos
#   1F071 🁱 DOMINO TILE VERTICAL-02-00
#   1F072 🁲 DOMINO TILE VERTICAL-02-01
#   1F073 🁳 DOMINO TILE VERTICAL-02-02
#   1F074 🁴 DOMINO TILE VERTICAL-02-03
#   1F075 🁵 DOMINO TILE VERTICAL-02-04
#   1F076 🁶 DOMINO TILE VERTICAL-02-05
#   1F077 🁷 DOMINO TILE VERTICAL-02-06

#   Threes
#   1F046 🁆 DOMINO TILE HORIZONTAL-03-00
#   1F047 🁇 DOMINO TILE HORIZONTAL-03-01
#   1F048 🁈 DOMINO TILE HORIZONTAL-03-02
#   1F049 🁉 DOMINO TILE HORIZONTAL-03-03
#   1F04A 🁊 DOMINO TILE HORIZONTAL-03-04
#   1F04B 🁋 DOMINO TILE HORIZONTAL-03-05
#   1F04C 🁌 DOMINO TILE HORIZONTAL-03-06
#   Threes
#   1F078 🁸 DOMINO TILE VERTICAL-03-00
#   1F079 🁹 DOMINO TILE VERTICAL-03-01
#   1F07A 🁺 DOMINO TILE VERTICAL-03-02
#   1F07B 🁻 DOMINO TILE VERTICAL-03-03
#   1F07C 🁼 DOMINO TILE VERTICAL-03-04
#   1F07D 🁽 DOMINO TILE VERTICAL-03-05
#   1F07E 🁾 DOMINO TILE VERTICAL-03-06

#   Fours
#   1F04D 🁍 DOMINO TILE HORIZONTAL-04-00
#   1F04E 🁎 DOMINO TILE HORIZONTAL-04-01
#   1F04F 🁏 DOMINO TILE HORIZONTAL-04-02
#   1F050 🁐 DOMINO TILE HORIZONTAL-04-03
#   1F051 🁑 DOMINO TILE HORIZONTAL-04-04
#   1F052 🁒 DOMINO TILE HORIZONTAL-04-05
#   1F053 🁓 DOMINO TILE HORIZONTAL-04-06
#   Fours
#   1F07F 🁿 DOMINO TILE VERTICAL-04-00
#   1F080 🂀 DOMINO TILE VERTICAL-04-01
#   1F081 🂁 DOMINO TILE VERTICAL-04-02
#   1F082 🂂 DOMINO TILE VERTICAL-04-03
#   1F083 🂃 DOMINO TILE VERTICAL-04-04
#   1F084 🂄 DOMINO TILE VERTICAL-04-05
#   1F085 🂅 DOMINO TILE VERTICAL-04-06

#   Fives
#   1F054 🁔 DOMINO TILE HORIZONTAL-05-00
#   1F055 🁕 DOMINO TILE HORIZONTAL-05-01
#   1F056 🁖 DOMINO TILE HORIZONTAL-05-02
#   1F057 🁗 DOMINO TILE HORIZONTAL-05-03
#   1F058 🁘 DOMINO TILE HORIZONTAL-05-04
#   1F059 🁙 DOMINO TILE HORIZONTAL-05-05
#   1F05A 🁚 DOMINO TILE HORIZONTAL-05-06
#   Fives
#   1F086 🂆 DOMINO TILE VERTICAL-05-00
#   1F087 🂇 DOMINO TILE VERTICAL-05-01
#   1F088 🂈 DOMINO TILE VERTICAL-05-02
#   1F089 🂉 DOMINO TILE VERTICAL-05-03
#   1F08A 🂊 DOMINO TILE VERTICAL-05-04
#   1F08B 🂋 DOMINO TILE VERTICAL-05-05
#   1F08C 🂌 DOMINO TILE VERTICAL-05-06

#   Sixes
#   1F05B 🁛 DOMINO TILE HORIZONTAL-06-00
#   1F05C 🁜 DOMINO TILE HORIZONTAL-06-01
#   1F05D 🁝 DOMINO TILE HORIZONTAL-06-02
#   1F05E 🁞 DOMINO TILE HORIZONTAL-06-03
#   1F05F 🁟 DOMINO TILE HORIZONTAL-06-04
#   1F060 🁠 DOMINO TILE HORIZONTAL-06-05
#   1F061 🁡 DOMINO TILE HORIZONTAL-06-06
#   Sixes
#   1F08D 🂍 DOMINO TILE VERTICAL-06-00
#   1F08E 🂎 DOMINO TILE VERTICAL-06-01
#   1F08F 🂏 DOMINO TILE VERTICAL-06-02
#   1F090 🂐 DOMINO TILE VERTICAL-06-03
#   1F091 🂑 DOMINO TILE VERTICAL-06-04
#   1F092 🂒 DOMINO TILE VERTICAL-06-05
#   1F093 🂓 DOMINO TILE VERTICAL-06-06
    },
################################################################################

################################################################################
# 1F0A0 Playing Cards 1F0FF
################################################################################
#   Back of card
#   1F0A0 🂠 PLAYING CARD BACK
################################################################################
#   Jokers
#   1F0BF 🂿     PLAYING CARD RED JOKER              • used as the third joker
#   1F0CF 🃏     PLAYING CARD BLACK JOKER
#   1F0DF 🃟     PLAYING CARD WHITE JOKER            • may also be red
################################################################################
#   Spades or swords
#   1F0A1 🂡 PLAYING CARD ACE OF SPADES
#   1F0A2 🂢 PLAYING CARD TWO OF SPADES
#   1F0A3 🂣 PLAYING CARD THREE OF SPADES
#   1F0A4 🂤 PLAYING CARD FOUR OF SPADES
#   1F0A5 🂥 PLAYING CARD FIVE OF SPADES
#   1F0A6 🂦 PLAYING CARD SIX OF SPADES
#   1F0A7 🂧 PLAYING CARD SEVEN OF SPADES
#   1F0A8 🂨 PLAYING CARD EIGHT OF SPADES
#   1F0A9 🂩 PLAYING CARD NINE OF SPADES
#   1F0AA 🂪 PLAYING CARD TEN OF SPADES
#   1F0AB 🂫 PLAYING CARD JACK OF SPADES         = valet, Bube, Unter, Page, fante = page of swords
#   1F0AC 🂬 PLAYING CARD KNIGHT OF SPADES       = chevalier, Ober, Ritter, cavall, cavaliere    = knight of swords
#   1F0AD 🂭 PLAYING CARD QUEEN OF SPADES        = dame, Dame, Königin, regina   = queen of swords
#   1F0AE 🂮 PLAYING CARD KING OF SPADES         = roi, König, re = king of swords
################################################################################
#   Hearts or cups
#   1F0B1 🂱 PLAYING CARD ACE OF HEARTS
#   1F0B2 🂲 PLAYING CARD TWO OF HEARTS
#   1F0B3 🂳 PLAYING CARD THREE OF HEARTS
#   1F0B4 🂴 PLAYING CARD FOUR OF HEARTS
#   1F0B5 🂵 PLAYING CARD FIVE OF HEARTS
#   1F0B6 🂶 PLAYING CARD SIX OF HEARTS
#   1F0B7 🂷 PLAYING CARD SEVEN OF HEARTS
#   1F0B8 🂸 PLAYING CARD EIGHT OF HEARTS
#   1F0B9 🂹 PLAYING CARD NINE OF HEARTS
#   1F0BA 🂺 PLAYING CARD TEN OF HEARTS
#   1F0BB 🂻 PLAYING CARD JACK OF HEARTS
#   1F0BC 🂼 PLAYING CARD KNIGHT OF HEARTS
#   1F0BD 🂽 PLAYING CARD QUEEN OF HEARTS
#   1F0BE 🂾 PLAYING CARD KING OF HEARTS
################################################################################
#   Diamonds or pentacles
#   1F0C1 🃁 PLAYING CARD ACE OF DIAMONDS
#   1F0C2 🃂 PLAYING CARD TWO OF DIAMONDS
#   1F0C3 🃃 PLAYING CARD THREE OF DIAMONDS
#   1F0C4 🃄 PLAYING CARD FOUR OF DIAMONDS
#   1F0C5 🃅 PLAYING CARD FIVE OF DIAMONDS
#   1F0C6 🃆 PLAYING CARD SIX OF DIAMONDS
#   1F0C7 🃇 PLAYING CARD SEVEN OF DIAMONDS
#   1F0C8 🃈 PLAYING CARD EIGHT OF DIAMONDS
#   1F0C9 🃉 PLAYING CARD NINE OF DIAMONDS
#   1F0CA 🃊 PLAYING CARD TEN OF DIAMONDS
#   1F0CB 🃋 PLAYING CARD JACK OF DIAMONDS
#   1F0CC 🃌 PLAYING CARD KNIGHT OF DIAMONDS
#   1F0CD 🃍 PLAYING CARD QUEEN OF DIAMONDS
#   1F0CE 🃎 PLAYING CARD KING OF DIAMONDS
################################################################################
#   Clubs or wands
#   1F0D1 🃑 PLAYING CARD ACE OF CLUBS
#   1F0D2 🃒 PLAYING CARD TWO OF CLUBS
#   1F0D3 🃓 PLAYING CARD THREE OF CLUBS
#   1F0D4 🃔 PLAYING CARD FOUR OF CLUBS
#   1F0D5 🃕 PLAYING CARD FIVE OF CLUBS
#   1F0D6 🃖 PLAYING CARD SIX OF CLUBS
#   1F0D7 🃗 PLAYING CARD SEVEN OF CLUBS
#   1F0D8 🃘 PLAYING CARD EIGHT OF CLUBS
#   1F0D9 🃙 PLAYING CARD NINE OF CLUBS
#   1F0DA 🃚 PLAYING CARD TEN OF CLUBS
#   1F0DB 🃛 PLAYING CARD JACK OF CLUBS
#   1F0DC 🃜 PLAYING CARD KNIGHT OF CLUBS
#   1F0DD 🃝 PLAYING CARD QUEEN OF CLUBS
#   1F0DE 🃞 PLAYING CARD KING OF CLUBS
################################################################################
#   Trumps
################################################################################
#   1F0E0 🃠 PLAYING CARD FOOL
#   1F0E1 🃡 PLAYING CARD TRUMP-1                • individual
#   1F0E2 🃢 PLAYING CARD TRUMP-2                • childhood
#   1F0E3 🃣 PLAYING CARD TRUMP-3                • youth
#   1F0E4 🃤 PLAYING CARD TRUMP-4                • maturity
#   1F0E5 🃥 PLAYING CARD TRUMP-5                • old age
#   1F0E6 🃦 PLAYING CARD TRUMP-6                • morning
#   1F0E7 🃧 PLAYING CARD TRUMP-7                • afternoon
#   1F0E8 🃨 PLAYING CARD TRUMP-8                • evening
#   1F0E9 🃩 PLAYING CARD TRUMP-9                • night
#   1F0EA 🃪 PLAYING CARD TRUMP-10               • earth and air
#   1F0EB 🃫 PLAYING CARD TRUMP-11               • water and fire
#   1F0EC 🃬 PLAYING CARD TRUMP-12               • dance
#   1F0ED 🃭 PLAYING CARD TRUMP-13               • shopping
#   1F0EE 🃮 PLAYING CARD TRUMP-14               • open air
#   1F0EF 🃯 PLAYING CARD TRUMP-15               • visual arts
#   1F0F0 🃰 PLAYING CARD TRUMP-16               • spring
#   1F0F1 🃱 PLAYING CARD TRUMP-17               • summer
#   1F0F2 🃲 PLAYING CARD TRUMP-18               • autumn
#   1F0F3 🃳 PLAYING CARD TRUMP-19               • winter
#   1F0F4 🃴 PLAYING CARD TRUMP-20               • the game
#   1F0F5 🃵 PLAYING CARD TRUMP-21               • collective
################################################################################

################################################################################
# Music Notes
    u2669   =>  "\x{2669}",             # ♩
    u266A   =>  "\x{266A}",             # ♪
    u266B   =>  "\x{266B}",             # ♫
    u266C   =>  "\x{266C}",             # ♬
    u266D   =>  "\x{266D}",             # ♭
    u266E   =>  "\x{266E}",             # ♮
    u266F   =>  "\x{266F}",             # ♯
################################################################################


################################################################################
# Icons
################################################################################
# Emotions
    emo_0   => "\x{2639}",              # ☹
    emo_1   => "\x{263A}",              # ☺ white smiling face
    emo_2   => "\x{263B}",              # ☻
    emo_3   => "😁",          #   3   😁 \x{F09F9881}  U+1F601     grinning face with smiling eyes
    emo_4   => "😂",          #   4   😂 \x{F09F9882}  U+1F602     face with tears of joy
    emo_5   => "😃",          #   5   😃 \x{F09F9883}  U+1F603     smiling face with open mouth
    emo_6   => "😄",          #   6   😄 \x{F09F9884}  U+1F604     smiling face with open mouth and smiling eyes
    emo_7   => "😅",          #   7   😅 \x{F09F9885}  U+1F605     smiling face with open mouth and cold sweat
    emo_8   => "😆",          #   8   😆 \x{F09F9886}  U+1F606     smiling face with open mouth and tightly-closed eyes
    emo_9   => "😉",          #   9   😉 \x{F09F9889}  U+1F609     winking face
    emo_10  => "😊",          #  10   😊 \x{F09F988A}  U+1F60A     smiling face with smiling eyes
    emo_11  => "😋",          #  11   😋 \x{F09F988B}  U+1F60B     face savouring delicious food
    emo_12  => "😌",          #  12   😌 \x{F09F988C}  U+1F60C     relieved face
    emo_13  => "😍",          #  13   😍 \x{F09F988D}  U+1F60D     smiling face with heart-shaped eyes
    emo_14  => "😏",          #  14   😏 \x{F09F988F}  U+1F60F     smirking face
    emo_15  => "😒",          #  15   😒 \x{F09F9892}  U+1F612     unamused face
    emo_16  => "😓",          #  16   😓 \x{F09F9893}  U+1F613     face with cold sweat
    emo_17  => "😔",          #  17   😔 \x{F09F9894}  U+1F614     pensive face
    emo_18  => "😖",          #  18   😖 \x{F09F9896}  U+1F616     confounded face
    emo_19  => "😘",          #  19   😘 \x{F09F9898}  U+1F618     face throwing a kiss
    emo_20  => "😚",          #  20   😚 \x{F09F989A}  U+1F61A     kissing face with closed eyes
    emo_21  => "😜",          #  21   😜 \x{F09F989C}  U+1F61C     face with stuck-out tongue and winking eye
    emo_22  => "😝",          #  22   😝 \x{F09F989D}  U+1F61D     face with stuck-out tongue and tightly-closed eyes
    emo_23  => "😞",          #  23   😞 \x{F09F989E}  U+1F61E     disappointed face
    emo_24  => "😠",          #  24   😠 \x{F09F98A0}  U+1F620     angry face
    emo_25  => "😡",          #  25   😡 \x{F09F98A1}  U+1F621     pouting face
    emo_26  => "😢",          #  26   😢 \x{F09F98A2}  U+1F622     crying face
    emo_27  => "😣",          #  27   😣 \x{F09F98A3}  U+1F623     persevering face
    emo_28  => "😤",          #  28   😤 \x{F09F98A4}  U+1F624     face with look of triumph
    emo_29  => "😥",          #  29   😥 \x{F09F98A5}  U+1F625     disappointed but relieved face
    emo_30  => "😨",          #  30   😨 \x{F09F98A8}  U+1F628     fearful face
    emo_31  => "😩",          #  31   😩 \x{F09F98A9}  U+1F629     weary face
    emo_32  => "😪",          #  32   😪 \x{F09F98AA}  U+1F62A     sleepy face
    emo_33  => "😫",          #  33   😫 \x{F09F98AB}  U+1F62B     tired face
    emo_34  => "😭",          #  34   😭 \x{F09F98AD}  U+1F62D     loudly crying face
    emo_35  => "😰",          #  35   😰 \x{F09F98B0}  U+1F630     face with open mouth and cold sweat
    emo_36  => "😱",          #  36   😱 \x{F09F98B1}  U+1F631     face screaming in fear
    emo_37  => "😲",          #  37   😲 \x{F09F98B2}  U+1F632     astonished face
    emo_38  => "😳",          #  38   😳 \x{F09F98B3}  U+1F633     flushed face
    emo_39  => "😵",          #  39   😵 \x{F09F98B5}  U+1F635     dizzy face
    emo_40  => "😷",          #  40   😷 \x{F09F98B7}  U+1F637     face with medical mask
    emo_41  => "😀",          #  41   😀 \x{F09F9880}  U+1F600     grinning face
    emo_42  => "😇",          #  42   😇 \x{F09F9887}  U+1F607     smiling face with halo
    emo_43  => "😈",          #  43   😈 \x{F09F9888}  U+1F608     smiling face with horns
    emo_44  => "😎",          #  44   😎 \x{F09F988E}  U+1F60E     smiling face with sunglasses
    emo_45  => "😐",          #  45   😐 \x{F09F9890}  U+1F610     neutral face
    emo_46  => "😑",          #  46   😑 \x{F09F9891}  U+1F611     expressionless face
    emo_47  => "😕",          #  47   😕 \x{F09F9895}  U+1F615     confused face
    emo_48  => "😗",          #  48   😗 \x{F09F9897}  U+1F617     kissing face
    emo_49  => "😙",          #  49   😙 \x{F09F9899}  U+1F619     kissing face with smiling eyes
    emo_50  => "😛",          #  50   😛 \x{F09F989B}  U+1F61B     face with stuck-out tongue
    emo_51  => "😟",          #  51   😟 \x{F09F989F}  U+1F61F     worried face
    emo_52  => "😦",          #  52   😦 \x{F09F98A6}  U+1F626     frowning face with open mouth
    emo_53  => "😧",          #  53   😧 \x{F09F98A7}  U+1F627     anguished face
    emo_54  => "😬",          #  54   😬 \x{F09F98AC}  U+1F62C     grimacing face
    emo_55  => "😮",          #  55   😮 \x{F09F98AE}  U+1F62E     face with open mouth
    emo_56  => "😯",          #  56   😯 \x{F09F98AF}  U+1F62F     hushed face
    emo_57  => "😴",          #  57   😴 \x{F09F98B4}  U+1F634     sleeping face
    emo_58  => "😶",          #  58   😶 \x{F09F98B6}  U+1F636     face without mouth
    emo_person_0    => "🙅",         #   0   🙅 \x{F09F9985}  U+1F645     face with no good gesture
    emo_person_1    => "🙆",         #   1   🙆 \x{F09F9986}  U+1F646     face with ok gesture
    emo_person_2    => "🙋",         #   2   🙋 \x{F09F998B}  U+1F64B     happy person raising one hand
    emo_person_3    => "🙍",         #   3   🙍 \x{F09F998D}  U+1F64D     person frowning
    emo_person_4    => "🙎",         #   4   🙎 \x{F09F998E}  U+1F64E     person with pouting face
    emo_person_5    => "🙇",         #   5   🙇 \x{F09F9987}  U+1F647     person bowing deeply
    emo_cat_0       => "😸",         #   0   😸 \x{F09F98B8}  U+1F638     grinning cat face with smiling eyes
    emo_cat_1       => "😹",         #   1   😹 \x{F09F98B9}  U+1F639     cat face with tears of joy
    emo_cat_2       => "😺",         #   2   😺 \x{F09F98BA}  U+1F63A     smiling cat face with open mouth
    emo_cat_3       => "😻",         #   3   😻 \x{F09F98BB}  U+1F63B     smiling cat face with heart-shaped eyes
    emo_cat_4       => "😼",         #   4   😼 \x{F09F98BC}  U+1F63C     cat face with wry smile
    emo_cat_5       => "😽",         #   5   😽 \x{F09F98BD}  U+1F63D     kissing cat face with closed eyes
    emo_cat_6       => "😾",         #   6   😾 \x{F09F98BE}  U+1F63E     pouting cat face
    emo_cat_7       => "😿",         #   7   😿 \x{F09F98BF}  U+1F63F     crying cat face
    emo_cat_8       => "🙀",         #   8   🙀 \x{F09F9980}  U+1F640     weary cat face
    emo_monkey_0    => "🙈",         #   0   🙈 \x{F09F9988}  U+1F648     see-no-evil monkey
    emo_monkey_1    => "🙉",         #   1   🙉 \x{F09F9989}  U+1F649     hear-no-evil monkey
    emo_monkey_2    => "🙊",         #   2   🙊 \x{F09F998A}  U+1F64A     speak-no-evil monkey
    hand_0          => "☝",             #   0   ☝ \x{261D}  U+261D      white up pointing index
    hand_1          => "✊",             #   1   ✊ \x{270A}  U+270A      raised fist
    hand_2          => "✋",             #   2   ✋ \x{270B}  U+270B      raised hand
    hand_3          => "✌",             #   3   ✌ \x{270C}  U+270C      victory hand
    hand_4          => "✍",             #   4   ✍ \x{270D}  U+270D      writing hand
    hand_5          => "🙌",         #   5   🙌 \x{F09F998C}  U+1F64C     person raising both hands in celebration
    hand_6          => "🙏",         #   6   🙏 \x{F09F998F}  U+1F64F     person with folded hands
    bords_0         => "🚧",         #  13   🚧 \x{F09F9AA7}  U+1F6A7     construction sign
    bords_1         => "🚸",         #  13   🚸 \x{F09F9AB8}  U+1F6B8     children crossing
    bords_2         => "🚫",         #  13   🚫 \x{F09F9AAB}  U+1F6AB     no entry sign
    bords_3         => "🚭",         #  13   🚭 \x{F09F9AAD}  U+1F6AD     no smoking symbol
    bords_4         => "🚯",         #  13   🚯 \x{F09F9AAF}  U+1F6AF     do not litter symbol
    bords_5         => "🚱",         #  13   🚱 \x{F09F9AB1}  U+1F6B1     non-potable water symbol
    bords_6         => "🚳",         #  13   🚳 \x{F09F9AB3}  U+1F6B3     no bicycles
    bords_7         => "🚷",         #  13   🚷 \x{F09F9AB7}  U+1F6B7     no pedestrians
    bords_8         => "🚾",         #  13   🚾 \x{F09F9ABE}  U+1F6BE     water closet
    bords_9         => "🚹",         #  13   🚹 \x{F09F9AB9}  U+1F6B9     mens symbol
    bords_10        => "🚺",         #  13   🚺 \x{F09F9ABA}  U+1F6BA     womens symbol
    bords_11        => "🚻",         #  13   🚻 \x{F09F9ABB}  U+1F6BB     restroom
    bords_12        => "🚼",         #  13   🚼 \x{F09F9ABC}  U+1F6BC     baby symbol
    bords_13        => "🚮",         #  13   🚮 \x{F09F9AAE}  U+1F6AE     put litter in its place symbol
    bords_14        => "🚰",         #  13   🚰 \x{F09F9AB0}  U+1F6B0     potable water symbol\
    bords_15        => "🛂",         #  13   🛂 \x{F09F9B82}  U+1F6C2     passport control
    bords_16        => "🛃",         #  13   🛃 \x{F09F9B83}  U+1F6C3     customs
    bords_17        => "🛄",         #  13   🛄 \x{F09F9B84}  U+1F6C4     baggage claim
    bords_18        => "🛅",         #  13   🛅 \x{F09F9B85}  U+1F6C5     left luggage
    trafic_0        => "🚀",         #  13   🚀 \x{F09F9A80}  U+1F680     rocket
    trafic_1        => "🚃",         #  13   🚃 \x{F09F9A83}  U+1F683     railway car
    trafic_2        => "🚄",         #  13   🚄 \x{F09F9A84}  U+1F684     high-speed train
    trafic_3        => "🚅",         #  13   🚅 \x{F09F9A85}  U+1F685     high-speed train with bullet nose
    trafic_4        => "🚇",         #  13   🚇 \x{F09F9A87}  U+1F687     metro
    trafic_5        => "🚉",         #  13   🚉 \x{F09F9A89}  U+1F689     station
    trafic_6        => "🚌",         #  13   🚌 \x{F09F9A8C}  U+1F68C     bus
    trafic_7        => "🚏",         #  13   🚏 \x{F09F9A8F}  U+1F68F     bus stop
    trafic_8        => "🚑",         #  13   🚑 \x{F09F9A91}  U+1F691     ambulance
    trafic_9        => "🚒",         #  13   🚒 \x{F09F9A92}  U+1F692     fire engine
    trafic_10       => "🚓",         #  13   🚓 \x{F09F9A93}  U+1F693     police car
    trafic_11       => "🚕",         #  13   🚕 \x{F09F9A95}  U+1F695     taxi
    trafic_12       => "🚗",         #  13   🚗 \x{F09F9A97}  U+1F697     automobile
    trafic_13       => "🚙",         #  13   🚙 \x{F09F9A99}  U+1F699     recreational vehicle
    trafic_14       => "🚚",         #  13   🚚 \x{F09F9A9A}  U+1F69A     delivery truck
    trafic_15       => "🚢",         #  13   🚢 \x{F09F9AA2}  U+1F6A2     ship
    trafic_16       => "🚤",         #  13   🚤 \x{F09F9AA4}  U+1F6A4     speedboat
    trafic_17       => "🚥",         #  13   🚥 \x{F09F9AA5}  U+1F6A5     horizontal traffic light
    trafic_18       => "🚨",         #  13   🚨 \x{F09F9AA8}  U+1F6A8     police cars revolving light
    trafic_19       => "🚩",         #  13   🚩 \x{F09F9AA9}  U+1F6A9     triangular flag on post
    symbol_0        => "🚪",         #  13   🚪 \x{F09F9AAA}  U+1F6AA     door
    symbol_1        => "🚲",         #  13   🚲 \x{F09F9AB2}  U+1F6B2     bicycle
    symbol_2        => "🚶",         #  13   🚶 \x{F09F9AB6}  U+1F6B6     pedestrian
    symbol_3        => "🚽",         #  13   🚽 \x{F09F9ABD}  U+1F6BD     toilet
    symbol_4        => "🛀",         #  13   🛀 \x{F09F9B80}  U+1F6C0     bath
    symbol_5        => "🚁",         #  13   🚁 \x{F09F9A81}  U+1F681     helicopter
    symbol_6        => "🚂",         #  13   🚂 \x{F09F9A82}  U+1F682     steam locomotive
    symbol_7        => "🚆",         #  13   🚆 \x{F09F9A86}  U+1F686     train
    symbol_8        => "🚈",         #  13   🚈 \x{F09F9A88}  U+1F688     light rail
    symbol_9        => "🚊",         #  13   🚊 \x{F09F9A8A}  U+1F68A     tram
    symbol_10       => "🚍",         #  13   🚍 \x{F09F9A8D}  U+1F68D     oncoming bus
    symbol_11       => "🚎",         #  13   🚎 \x{F09F9A8E}  U+1F68E     trolleybus
    symbol_12       => "🚐",         #  13   🚐 \x{F09F9A90}  U+1F690     minibus
    symbol_13       => "🚔",         #  13   🚔 \x{F09F9A94}  U+1F694     oncoming police car
    symbol_14       => "🚖",         #  13   🚖 \x{F09F9A96}  U+1F696     oncoming taxi
    symbol_15       => "🚘",         #  13   🚘 \x{F09F9A98}  U+1F698     oncoming automobile
    symbol_16       => "🚛",         #  13   🚛 \x{F09F9A9B}  U+1F69B     articulated lorry
    symbol_17       => "🚜",         #  13   🚜 \x{F09F9A9C}  U+1F69C     tractor
    symbol_18       => "🚝",         #  13   🚝 \x{F09F9A9D}  U+1F69D     monorail
    symbol_19       => "🚞",         #  13   🚞 \x{F09F9A9E}  U+1F69E     mountain railway
    symbol_20       => "🚟",         #  13   🚟 \x{F09F9A9F}  U+1F69F     suspension railway
    symbol_21       => "🚠",         #  13   🚠 \x{F09F9AA0}  U+1F6A0     mountain cableway
    symbol_22       => "🚡",         #  13   🚡 \x{F09F9AA1}  U+1F6A1     aerial tramway
    symbol_23       => "🚣",         #  13   🚣 \x{F09F9AA3}  U+1F6A3     rowboat
    symbol_24       => "🚦",         #  13   🚦 \x{F09F9AA6}  U+1F6A6     vertical traffic light
    symbol_25       => "🚴",         #  13   🚴 \x{F09F9AB4}  U+1F6B4     bicyclist
    symbol_26       => "🚵",         #  13   🚵 \x{F09F9AB5}  U+1F6B5     mountain bicyclist
    symbol_27       => "🚿",         #  13   🚿 \x{F09F9ABF}  U+1F6BF     shower
    symbol_28       => "🛁",         #  13   🛁 \x{F09F9B81}  U+1F6C1     bathtub

################################################################################
# Media Player Button
    media_forward   => "\x{23E9}",  # ⏩ 
    media_backward  => "\x{23EA}",  # ⏪ 
    media_upward    => "\x{23EB}",  # ⏫ 
    media_downward  => "\x{23EC}",  # ⏬ 
    media_last      => "\x{23ED}",  # ⏭ 
    media_first     => "\x{23EE}",  # ⏮ 
    media_playpause => "\x{23EF}",  # ⏯ 
    media_pause     => "\x{23F8}",  # ⏸ 
    media_stop      => "\x{23F9}",  # ⏹ 
    media_record    => "\x{23FA}",  # ⏺
################################################################################
    icon_copy       =>  "\x{2397}",             #   ⎗   copy
    icon_paste      =>  "\x{2398}",             #   ⎘   paste
    icon_print      =>  "\x{2399}",             #   ⎙   print
    icon_edit       =>  "\x{23CD}",             #   ⏍   edit
################################################################################
# \x{20E3} #  ⃣
# #⃣ 0⃣ 1⃣ 2⃣ 3⃣ 4⃣ 5⃣ 6⃣ 7⃣ 8⃣ 9⃣
    capture_letter => sub {                     # combining enclosing keycap # char <= 0xFF
        xchr(dechex(ord($_[0]),2)."E283A3")
    },
################################################################################
# Flags
#   🇳🇱  U+1F1E6(+26) U+1F1E6(+26)  regional indicator symbol letters a & z
    flag            => sub {                    # my ($code)=@_; E6 = 230
        join('',@{[ 
            map { 
                xchr("1F1".dechex(230+ord($_)-97,2) ) 
            } 
            @{[ split(//,lc($_[0])) ]}
        ]})
    },
################################################################################
################################################################################
# TERM_UNICODE_TABLE
################################################################################
# 0000 – 007F # C0 Controls and Basic Latin
#   C0 controls - Alias names are those for ISO/IEC 6429:1992. Commonly used alternative aliases are also shown.
    u0000       =>  "\x{0000}", #   =>  ["","<control>","= NULL"],
    u0001       =>  "\x{0001}", #   =>  ["","<control>","= START OF HEADING"],
    u0002       =>  "\x{0002}", #   =>  ["","<control>","= START OF TEXT"],
    u0003       =>  "\x{0003}", #   =>  ["","<control>","= END OF TEXT"],
    u0004       =>  "\x{0004}", #   =>  ["","<control>","= END OF TRANSMISSION"],
    u0005       =>  "\x{0005}", #   =>  ["","<control>","= ENQUIRY"],
    u0006       =>  "\x{0006}", #   =>  ["","<control>","= ACKNOWLEDGE"],
    u0007       =>  "\x{0007}", #   =>  ["","<control>","= BELL"],
    u0008       =>  "\x{0008}", #   =>  ["","<control>","= BACKSPACE"],
    u0009       =>  "\x{0009}", #   =>  ["","<control>","= CHARACTER TABULATION","= horizontal tabulation (HT), tab"],
    u000A       =>  "\x{000A}", #   =>  ["","<control>","= LINE FEED (LF)","= new line (NL), end of line (EOL)"],
    u000B       =>  "\x{000B}", #   =>  ["","<control>","= LINE TABULATION","= vertical tabulation (VT)"],
    u000C       =>  "\x{000C}", #   =>  ["","<control>","= FORM FEED (FF)"],
    u000D       =>  "\x{000D}", #   =>  ["","<control>","= CARRIAGE RETURN (CR)"],
    u000E       =>  "\x{000E}", #   =>  ["","<control>","= SHIFT OUT","• known as LOCKING-SHIFT ONE in 8-bit environments"],
    u000F       =>  "\x{000F}", #   =>  ["","<control>","= SHIFT IN","• known as LOCKING-SHIFT ZERO in 8-bit environments"],
    u0010       =>  "\x{0010}", #   =>  ["","<control>","= DATA LINK ESCAPE"],
    u0011       =>  "\x{0011}", #   =>  ["","<control>","= DEVICE CONTROL ONE"],
    u0012       =>  "\x{0012}", #   =>  ["","<control>","= DEVICE CONTROL TWO"],
    u0013       =>  "\x{0013}", #   =>  ["","<control>","= DEVICE CONTROL THREE"],
    u0014       =>  "\x{0014}", #   =>  ["","<control>","= DEVICE CONTROL FOUR"],
    u0015       =>  "\x{0015}", #   =>  ["","<control>","= NEGATIVE ACKNOWLEDGE"],
    u0016       =>  "\x{0016}", #   =>  ["","<control>","= SYNCHRONOUS IDLE"],
    u0017       =>  "\x{0017}", #   =>  ["","<control>","= END OF TRANSMISSION BLOCK"],
    u0018       =>  "\x{0018}", #   =>  ["","<control>","= CANCEL"],
    u0019       =>  "\x{0019}", #   =>  ["","<control>","= END OF MEDIUM"],
    u001A       =>  "\x{001A}", #   =>  ["","<control>","= SUBSTITUTE","→    replacement character"],
    u001B       =>  "\x{001B}", #   =>  ["","<control>","= ESCAPE"],
    u001C       =>  "\x{001C}", #   =>  ["","<control>","= INFORMATION SEPARATOR FOUR","= file separator (FS)"],
    u001D       =>  "\x{001D}", #   =>  ["","<control>","= INFORMATION SEPARATOR THREE","= group separator (GS)"],
    u001E       =>  "\x{001E}", #   =>  ["","<control>","= INFORMATION SEPARATOR TWO","= record separator (RS)"],
    u001F       =>  "\x{001F}", #   =>  ["","<control>","= INFORMATION SEPARATOR ONE","= unit separator (US)"],
#   ASCII punctuation and symbols - Based on ISO/IEC 646.
#    u0020       =>  "\x{0020}", #   =>  ["","SPACE","• sometimes considered a control code","• other space characters:   – ","→    no-break space","→    zero width space","→    word joiner","→    ideographic space","→    zero width no-break space"],
#    u0021       =>  "\x{0021}", #   =>  ["!","EXCLAMATION MARK","= factorial","= bang","→  ¡  inverted exclamation mark","→  ǃ  latin letter retroflex click","→  ‼  double exclamation mark","→  ‽  interrobang","→  ❢  heavy exclamation mark ornament"],
#    u0022       =>  "\x{0022}", #   =>  ['"',"QUOTATION MARK","• neutral (vertical), used as opening or closing quotation mark","• preferred characters in English for paired quotation marks are  “  &  ”","•  ״  is preferred for gershayim when writing Hebrew","→  ʺ  modifier letter double prime","→  $̋  combining double acute accent","→  $̎  combining double vertical line above","→  ״  hebrew punctuation gershayim","→  ″  double prime","→  〃  ditto mark"],
#    u0023       =>  "\x{0023}", #   =>  ["#","NUMBER SIGN","= pound sign, hash, crosshatch, octothorpe","→  ℔  l b bar symbol","→  ⌗  viewdata square","→  ♯  music sharp sign"],
#    u0024       =>  "\x{0024}", #   =>  ["$","DOLLAR SIGN","= milréis, escudo","• used for many peso currencies in Latin America and elsewhere","• glyph may have one or two vertical bars","• other currency symbol characters start at  ₠","→  ¤  currency sign","→  ₱  peso sign","→  💲  heavy dollar sign"],
#    u0025       =>  "\x{0025}", #   =>  ["%","PERCENT SIGN","→    arabic percent sign","→  ‰  per mille sign","→ ‱  per ten thousand sign","→  ⁒  commercial minus sign"],
#    u0026       =>  "\x{0026}", #   =>  ["&","AMPERSAND","→  ⁊  tironian sign et","→  ⅋  turned ampersand","→  🙴  heavy ampersand ornament"],
#    u0027       =>  "\x{0027}", #   =>  ["'","APOSTROPHE","= apostrophe-quote (1.0)","= APL quote","• neutral (vertical) glyph with mixed usage","•  ’  is preferred for apostrophe","• preferred characters in English for paired quotation marks are  ‘  &  ’","•  ׳  is preferred for geresh when writing Hebrew","→  ʹ  modifier letter prime","→  ʼ  modifier letter apostrophe","→  ˈ  modifier letter vertical line","→  $́  combining acute accent","→  ׳  hebrew punctuation geresh","→  ′  prime","→  ꞌ  latin small letter saltillo"],
#    u0028       =>  "\x{0028}", #   =>  ["(","LEFT PARENTHESIS","= opening parenthesis (1.0)"],
#    u0029       =>  "\x{0029}", #   =>  [")","RIGHT PARENTHESIS","= closing parenthesis (1.0)","• see discussion on semantics of paired bracketing characters"],
#    u002A       =>  "\x{002A}", #   =>  ["*","ASTERISK","= star (on phone keypads)","→    arabic five pointed star","→  ⁎  low asterisk","→  ∗  asterisk operator","→  ⚹  sextile","→  ✱  heavy asterisk"],
#    u002B       =>  "\x{002B}", #   =>  ["+","PLUS SIGN","→  ➕  heavy plus sign"],
#    u002C       =>  "\x{002C}", #   =>  [",","COMMA","= decimal separator","→    arabic comma","→  ‚  single low-9 quotation mark","→  ⹁  reversed comma","→  ⹌  medieval comma","→  、  ideographic comma"],
#    u002D       =>  "\x{002D}", #   =>  ["-","HYPHEN-MINUS","= hyphen or minus sign","• used for either hyphen or minus sign","→  ‐  hyphen","→    non-breaking hyphen","→  ‒  figure dash","→  –  en dash","→  ⁃  hyphen bullet","→  −  minus sign","→  𐆑  roman uncia sign"],
#    u002E       =>  "\x{002E}", #   =>  [".","FULL STOP","= period, dot, decimal point","• may be rendered as a raised decimal point in","old style numbers","→    arabic full stop","→  ⸼  stenographic full stop","→  。  ideographic full stop"],
#    u002F       =>  "\x{002F}", #   =>  ["/","SOLIDUS","= slash, virgule","→  ǀ  latin letter dental click","→  $̸  combining long solidus overlay","→  ⁄  fraction slash","→  ∕  division slash","→  ⹊  dotted solidus"],
#   ASCII digits
#    u0030       =>  "\x{0030}", #   =>  ["0","DIGIT ZERO","⁓   0  short diagonal stroke form"],
#    u0031       =>  "\x{0031}", #   =>  ["1","DIGIT ONE"],
#    u0032       =>  "\x{0032}", #   =>  ["2","DIGIT TWO"],
#    u0033       =>  "\x{0033}", #   =>  ["3","DIGIT THREE"],
#    u0034       =>  "\x{0034}", #   =>  ["4","DIGIT FOUR"],
#    u0035       =>  "\x{0035}", #   =>  ["5","DIGIT FIVE"],
#    u0036       =>  "\x{0036}", #   =>  ["6","DIGIT SIX"],
#    u0037       =>  "\x{0037}", #   =>  ["7","DIGIT SEVEN"],
#    u0038       =>  "\x{0038}", #   =>  ["8","DIGIT EIGHT"],
#    u0039       =>  "\x{0039}", #   =>  ["9","DIGIT NINE"],
#   ASCII punctuation and symbols
#    u003A       =>  "\x{003A}", #   =>  [":","COLON","• also used to denote division or scale; for that mathematical use  ∶  is preferred","→  ։  armenian full stop","→  ׃  hebrew punctuation sof pasuq","→  ∶  ratio","→  ꞉  modifier letter colon"],
#    u003B       =>  "\x{003B}", #   =>  [";","SEMICOLON","• this, and not  ; , is the preferred character for ’Greek question mark’","→  ;  greek question mark","→    arabic semicolon","→  ⁏  reversed semicolon"],
#    u003C       =>  "\x{003C}", #   =>  ["<","LESS-THAN SIGN","→  ‹  single left-pointing angle quotation mark","→  〈  left-pointing angle bracket","→  ⟨  mathematical left angle bracket","→  〈  left angle bracket"],
#    u003D       =>  "\x{003D}", #   =>  ["=","EQUALS SIGN","• other related characters:  ≁ – ≣","→  ≠  not equal to","→  ≡  identical to","→  ꞊  modifier letter short equals sign","→  𐆐  roman sextans sign"],
#    u003E       =>  "\x{003E}", #   =>  [">","GREATER-THAN SIGN","→  ›  single right-pointing angle quotation mark","→  〉  right-pointing angle bracket","→  ⟩  mathematical right angle bracket","→  〉  right angle bracket"],
#    u003F       =>  "\x{003F}", #   =>  ["?","QUESTION MARK","→  ¿  inverted question mark","→  ;  greek question mark","→    arabic question mark","→  ‽  interrobang","→  ⁈  question exclamation mark","→  ⁉  exclamation question mark"],
#    u0040       =>  "\x{0040}", #   =>  ["@","COMMERCIAL AT","= at sign"],
#   Uppercase Latin alphabet
#    u0041       =>  "\x{0041}", #   =>  ["A","LATIN CAPITAL LETTER A"],
#    u0042       =>  "\x{0042}", #   =>  ["B","LATIN CAPITAL LETTER B","→  ℬ  script capital b"],
#    u0043       =>  "\x{0043}", #   =>  ["C","LATIN CAPITAL LETTER C","→  ℂ  double-struck capital c","→  ℭ  black-letter capital c"],
#    u0044       =>  "\x{0044}", #   =>  ["D","LATIN CAPITAL LETTER D"],
#    u0045       =>  "\x{0045}", #   =>  ["E","LATIN CAPITAL LETTER E","→  ℇ  euler constant","→  ℰ  script capital e"],
#    u0046       =>  "\x{0046}", #   =>  ["F","LATIN CAPITAL LETTER F","→  ℱ  script capital f","→  Ⅎ  turned capital f"],
#    u0047       =>  "\x{0047}", #   =>  ["G","LATIN CAPITAL LETTER G"],
#    u0048       =>  "\x{0048}", #   =>  ["H","LATIN CAPITAL LETTER H","→  ℋ  script capital h","→  ℌ  black-letter capital h","→  ℍ  double-struck capital h"],
#    u0049       =>  "\x{0049}", #   =>  ["I","LATIN CAPITAL LETTER I","• Turkish and Azerbaijani use  ı  for lowercase","→  İ  latin capital letter i with dot above","→  І  cyrillic capital letter byelorussianukrainian i","→  Ӏ  cyrillic letter palochka","→  ℐ  script capital i","→  ℑ  black-letter capital i","→  Ⅰ  roman numeral one"],
#    u004A       =>  "\x{004A}", #   =>  ["J","LATIN CAPITAL LETTER J"],
#    u004B       =>  "\x{004B}", #   =>  ["K","LATIN CAPITAL LETTER K","→  K  kelvin sign"],
#    u004C       =>  "\x{004C}", #   =>  ["L","LATIN CAPITAL LETTER L","→  ℒ  script capital l"],
#    u004D       =>  "\x{004D}", #   =>  ["M","LATIN CAPITAL LETTER M","→  ℳ  script capital m"],
#    u004E       =>  "\x{004E}", #   =>  ["N","LATIN CAPITAL LETTER N","→  ℕ  double-struck capital n"],
#    u004F       =>  "\x{004F}", #   =>  ["O","LATIN CAPITAL LETTER O"],
#    u0050       =>  "\x{0050}", #   =>  ["P","LATIN CAPITAL LETTER P","→  ℙ  double-struck capital p"],
#    u0051       =>  "\x{0051}", #   =>  ["Q","LATIN CAPITAL LETTER Q","→  ℚ  double-struck capital q"],
#    u0052       =>  "\x{0052}", #   =>  ["R","LATIN CAPITAL LETTER R","→  ℛ  script capital r","→  ℜ  black-letter capital r","→  ℝ  double-struck capital r"],
#    u0053       =>  "\x{0053}", #   =>  ["S","LATIN CAPITAL LETTER S"],
#    u0054       =>  "\x{0054}", #   =>  ["T","LATIN CAPITAL LETTER T"],
#    u0055       =>  "\x{0055}", #   =>  ["U","LATIN CAPITAL LETTER U"],
#    u0056       =>  "\x{0056}", #   =>  ["V","LATIN CAPITAL LETTER V","→  Ⅴ  roman numeral five"],
#    u0057       =>  "\x{0057}", #   =>  ["W","LATIN CAPITAL LETTER W"],
#    u0058       =>  "\x{0058}", #   =>  ["X","LATIN CAPITAL LETTER X"],
#    u0059       =>  "\x{0059}", #   =>  ["Y","LATIN CAPITAL LETTER Y"],
#    u005A       =>  "\x{005A}", #   =>  ["Z","LATIN CAPITAL LETTER Z","→  ℤ  double-struck capital z","→  ℨ  black-letter capital z"],
#   ASCII punctuation and symbols
#    u005B       =>  "\x{005B}", #   =>  ["[","LEFT SQUARE BRACKET","= opening square bracket (1.0)","• other bracket characters:  ⟦ – ⟫ ,  ⦃ – ⦘ ,  〈 – 〛"],
#    u005C       =>  "\x{005C}", #   =>  ["\\","REVERSE SOLIDUS","= backslash","→  ⃥  combining reverse solidus overlay","→  ∖  set minus"],
#    u005D       =>  "\x{005D}", #   =>  ["]","RIGHT SQUARE BRACKET","= closing square bracket (1.0)"],
#    u005E       =>  "\x{005E}", #   =>  ["^","CIRCUMFLEX ACCENT","• this is a spacing character","→  ˄  modifier letter up arrowhead","→  ˆ  modifier letter circumflex accent","→  $̂  combining circumflex accent","→  ‸  caret","→  ⌃  up arrowhead"],
#    u005F       =>  "\x{005F}", #   =>  ["_","LOW LINE","= spacing underscore (1.0)","• this is a spacing character","→  ˍ  modifier letter low macron","→  $̱  combining macron below","→  $̲  combining low line","→  ‗  double low line"],
#    u0060       =>  "\x{0060}", #   =>  ["`","GRAVE ACCENT","• this is a spacing character","→  ˋ  modifier letter grave accent","→  $̀  combining grave accent","→  ‵  reversed prime"],
#   Lowercase Latin alphabet
#    u0061       =>  "\x{0061}", #   =>  ["a","LATIN SMALL LETTER A"],
#    u0062       =>  "\x{0062}", #   =>  ["b","LATIN SMALL LETTER B"],
#    u0063       =>  "\x{0063}", #   =>  ["c","LATIN SMALL LETTER C"],
#    u0064       =>  "\x{0064}", #   =>  ["d","LATIN SMALL LETTER D"],
#    u0065       =>  "\x{0065}", #   =>  ["e","LATIN SMALL LETTER E","→  ℮  estimated symbol","→  ℯ  script small e"],
#    u0066       =>  "\x{0066}", #   =>  ["f","LATIN SMALL LETTER F"],
#    u0067       =>  "\x{0067}", #   =>  ["g","LATIN SMALL LETTER G","→  ɡ  latin small letter script g","→  ℊ  script small g"],
#    u0068       =>  "\x{0068}", #   =>  ["h","LATIN SMALL LETTER H","→  һ  cyrillic small letter shha","→  ℎ  planck constant"],
#    u0069       =>  "\x{0069}", #   =>  ["i","LATIN SMALL LETTER I","• Turkish and Azerbaijani use  İ  for uppercase","→  ı  latin small letter dotless i","→  𝚤  mathematical italic small dotless i"],
#    u006A       =>  "\x{006A}", #   =>  ["j","LATIN SMALL LETTER J","→  ȷ  latin small letter dotless j","→  𝚥  mathematical italic small dotless j"],
#    u006B       =>  "\x{006B}", #   =>  ["k","LATIN SMALL LETTER K"],
#    u006C       =>  "\x{006C}", #   =>  ["l","LATIN SMALL LETTER L","→  ℓ  script small l","→  𝓁  mathematical script small l"],
#    u006D       =>  "\x{006D}", #   =>  ["m","LATIN SMALL LETTER M"],
#    u006E       =>  "\x{006E}", #   =>  ["n","LATIN SMALL LETTER N","→  ⁿ  superscript latin small letter n"],
#    u006F       =>  "\x{006F}", #   =>  ["o","LATIN SMALL LETTER O","→  ℴ  script small o"],
#    u0070       =>  "\x{0070}", #   =>  ["p","LATIN SMALL LETTER P"],
#    u0071       =>  "\x{0071}", #   =>  ["q","LATIN SMALL LETTER Q"],
#    u0072       =>  "\x{0072}", #   =>  ["r","LATIN SMALL LETTER R"],
#    u0073       =>  "\x{0073}", #   =>  ["s","LATIN SMALL LETTER S"],
#    u0074       =>  "\x{0074}", #   =>  ["t","LATIN SMALL LETTER T"],
#    u0075       =>  "\x{0075}", #   =>  ["u","LATIN SMALL LETTER U"],
#    u0076       =>  "\x{0076}", #   =>  ["v","LATIN SMALL LETTER V"],
#    u0077       =>  "\x{0077}", #   =>  ["w","LATIN SMALL LETTER W"],
#    u0078       =>  "\x{0078}", #   =>  ["x","LATIN SMALL LETTER X"],
#    u0079       =>  "\x{0079}", #   =>  ["y","LATIN SMALL LETTER Y"],
#    u007A       =>  "\x{007A}", #   =>  ["z","LATIN SMALL LETTER Z","→  ƶ  latin small letter z with stroke ASCII punctuation and symbols"],
#    u007B       =>  "\x{007B}", #   =>  ["{","LEFT CURLY BRACKET","= opening curly bracket (1.0)","= left brace"],
#    u007C       =>  "\x{007C}", #   =>  ["|","VERTICAL LINE","= vertical bar","• used in pairs to indicate absolute value","→  ǀ  latin letter dental click","→  ׀  hebrew punctuation paseq","→  ∣  divides","→  ❘  light vertical bar"],
#    u007D       =>  "\x{007D}", #   =>  ["}","RIGHT CURLY BRACKET","= closing curly bracket (1.0)","= right brace"],
#    u007E       =>  "\x{007E}", #   =>  ["~","TILDE","• this is a spacing character","→  ˜  small tilde","→  $̃  combining tilde","→  ⁓  swung dash","→  ∼  tilde operator","→  ～  fullwidth tilde"],
#   Control character
#    u007F       =>  "\x{007F}", #   =>  ["","<control>","= DELETE"],
################################################################################
# 0080 – 00FF # C1 Controls and Latin-1 Supplement
################################################################################
# C1 controls - Alias names are those for ISO/IEC 6429:1992.
    u0080       =>  "\x{0080}", #   =>  ["","<control>"], 
    u0081       =>  "\x{0081}", #   =>  ["","<control>"],
    u0082       =>  "\x{0082}", #   =>  ["","<control>","= BREAK PERMITTED HERE","→    zero width space"],
    u0083       =>  "\x{0083}", #   =>  ["","<control>","= NO BREAK HERE","→    word joiner"],
    u0084       =>  "\x{0084}", #   =>  ["","<control>","• formerly known as INDEX"],
    u0085       =>  "\x{0085}", #   =>  ["","<control>","= NEXT LINE (NEL)"],
    u0086       =>  "\x{0086}", #   =>  ["","<control>","= START OF SELECTED AREA"],
    u0087       =>  "\x{0087}", #   =>  ["","<control>","= END OF SELECTED AREA"],
    u0088       =>  "\x{0088}", #   =>  ["","<control>","= CHARACTER TABULATION SET"],
    u0089       =>  "\x{0089}", #   =>  ["","<control>","= CHARACTER TABULATION WITH JUSTIFICATION"],
    u008A       =>  "\x{008A}", #   =>  ["","<control>","= LINE TABULATION SET"],
    u008B       =>  "\x{008B}", #   =>  ["","<control>","= PARTIAL LINE FORWARD"],
    u008C       =>  "\x{008C}", #   =>  ["","<control>","= PARTIAL LINE BACKWARD"],
    u008D       =>  "\x{008D}", #   =>  ["","<control>","= REVERSE LINE FEED"],
    u008E       =>  "\x{008E}", #   =>  ["","<control>","= SINGLE SHIFT TWO"],
    u008F       =>  "\x{008F}", #   =>  ["","<control>","= SINGLE SHIFT THREE"],
    u0090       =>  "\x{0090}", #   =>  ["","<control>","= DEVICE CONTROL STRING"],
    u0091       =>  "\x{0091}", #   =>  ["","<control>","= PRIVATE USE ONE"],
    u0092       =>  "\x{0092}", #   =>  ["","<control>","= PRIVATE USE TWO"],
    u0093       =>  "\x{0093}", #   =>  ["","<control>","= SET TRANSMIT STATE"],
    u0094       =>  "\x{0094}", #   =>  ["","<control>","= CANCEL CHARACTER"],
    u0095       =>  "\x{0095}", #   =>  ["","<control>","= MESSAGE WAITING"],
    u0096       =>  "\x{0096}", #   =>  ["","<control>","= START OF GUARDED AREA"],
    u0097       =>  "\x{0097}", #   =>  ["","<control>","= END OF GUARDED AREA"],
    u0098       =>  "\x{0098}", #   =>  ["","<control>","= START OF STRING"],
    u0099       =>  "\x{0099}", #   =>  ["","<control>"],
    u009A       =>  "\x{009A}", #   =>  ["","<control>","= SINGLE CHARACTER INTRODUCER"],
    u009B       =>  "\x{009B}", #   =>  ["","<control>","= CONTROL SEQUENCE INTRODUCER"],
    u009C       =>  "\x{009C}", #   =>  ["","<control>","= STRING TERMINATOR"],
    u009D       =>  "\x{009D}", #   =>  ["","<control>","= OPERATING SYSTEM COMMAND"],
    u009E       =>  "\x{009E}", #   =>  ["","<control>","= PRIVACY MESSAGE"],
    u009F       =>  "\x{009F}", #   =>  ["","<control>","= APPLICATION PROGRAM COMMAND"],
################################################################################
# Latin-1 punctuation and symbols - Based on ISO/IEC 8859-1 (aka Latin-1) from here.
    u00A0       =>  "\x{00A0}", #   =>  ["","NO-BREAK SPACE","• commonly abbreviated as NBSP","→    space","→    figure space","→    narrow no-break space","→    word joiner","→    zero width no-break space","≈ <noBreak>  "],
    u00A1       =>  "\x{00A1}", #   =>  ["¡","INVERTED EXCLAMATION MARK","• Spanish, Asturian, Galician","→  !  exclamation mark"],
    u00A2       =>  "\x{00A2}", #   =>  ["¢","CENT SIGN"],
    u00A3       =>  "\x{00A3}", #   =>  ["£","POUND SIGN","= pound sterling, Irish punt, Italian lira, Turkish","lira, etc.","→  ₤  lira sign","→  ₺  turkish lira sign","→  𐆒  roman semuncia sign"],
    u00A4       =>  "\x{00A4}", #   =>  ["¤","CURRENCY SIGN","• other currency symbol characters:"," ₠ – ₿","→  $  dollar sign"],
    u00A5       =>  "\x{00A5}", #   =>  ["¥","YEN SIGN","= yuan sign","• glyph may have one or two crossbars, but","official symbol in Japan and China has two"],
    u00A6       =>  "\x{00A6}", #   =>  ["¦","BROKEN BAR","= broken vertical bar (1.0)","= parted rule (in typography)"],
    u00A7       =>  "\x{00A7}", #   =>  ["§","SECTION SIGN","• paragraph sign in some European usage"],
    u00A8       =>  "\x{00A8}", #   =>  ["¨","DIAERESIS","• this is a spacing character","→  $̈  combining diaeresis","≈     $̈"],
    u00A9       =>  "\x{00A9}", #   =>  ["©","COPYRIGHT SIGN","→  ℗  sound recording copyright","→  Ⓒ  circled latin capital letter c","→  🄯  copyleft symbol"],
    u00AA       =>  "\x{00AA}", #   =>  ["ª","FEMININE ORDINAL INDICATOR","• Spanish","≈ <super>  a"],
    u00AB       =>  "\x{00AB}", #   =>  ["«","LEFT-POINTING DOUBLE ANGLE QUOTATION MARK","= left guillemet","= chevrons (in typography)","• usually opening, sometimes closing","→  ≪  much less-than","→  《  left double angle bracket"],
    u00AC       =>  "\x{00AC}", #   =>  ["¬","NOT SIGN","= angled dash (in typography)","→  ⌐  reversed not sign"],
    u00AD       =>  "\x{00AD}", #   =>  ["","SOFT HYPHEN","= discretionary hyphen","• commonly abbreviated as SHY"],
    u00AE       =>  "\x{00AE}", #   =>  ["®","REGISTERED SIGN","= registered trade mark sign (1.0)","→  Ⓡ  circled latin capital letter r"],
    u00AF       =>  "\x{00AF}", #   =>  ["¯","MACRON","= overline, APL overbar","• this is a spacing character","→  ˉ  modifier letter macron","→  $̄  combining macron","→  $̅  combining overline","≈     $̄"],
    u00B0       =>  "\x{00B0}", #   =>  ["°","DEGREE SIGN","• this is a spacing character","→  ˚  ring above","→  $̊  combining ring above","→  ⁰  superscript zero","→  ∘  ring operator"],
    u00B1       =>  "\x{00B1}", #   =>  ["±","PLUS-MINUS SIGN","→  ∓  minus-or-plus sign"],
    u00B2       =>  "\x{00B2}", #   =>  ["²","SUPERSCRIPT TWO","= squared","• other superscript digit characters:"," ⁰ – ⁹","→  ¹  superscript one","≈ <super>  2"],
    u00B3       =>  "\x{00B3}", #   =>  ["³","SUPERSCRIPT THREE","= cubed","→  ¹  superscript one","≈ <super>  3"],
    u00B4       =>  "\x{00B4}", #   =>  ["´","ACUTE ACCENT","• this is a spacing character","→  ʹ  modifier letter prime","→  ˊ  modifier letter acute accent","→  $́  combining acute accent","→  ′  prime","≈     $́"],
    u00B5       =>  "\x{00B5}", #   =>  ["μ","MICRO SIGN","≈  μ  greek small letter mu"],
    u00B6       =>  "\x{00B6}", #   =>  ["¶","PILCROW SIGN","= paragraph sign","• section sign in some European usage","→  ⁋  reversed pilcrow sign","→  ❡  curved stem paragraph sign","ornament","→  ⸿  capitulum"],
    u00B7       =>  "\x{00B7}", #   =>  ["·","MIDDLE DOT","= midpoint (in typography)","= Georgian comma","= Greek middle dot (ano teleia)","• also used as a raised decimal point or to denote","multiplication; for multiplication  ⋅  is","preferred","→  ·  greek ano teleia","→  ᛫  runic single punctuation","→  •  bullet","→  ․  one dot leader","→  ‧  hyphenation point","→  ∙  bullet operator","→  ⋅  dot operator","→  ⸱  word separator middle dot","→  ⸳  raised dot","→  ・  katakana middle dot","→  ꞏ  latin letter sinological dot"],
    u00B8       =>  "\x{00B8}", #   =>  ["¸","CEDILLA","• this is a spacing character","• other spacing accent characters:"," ˘ – ˛","→  $̧  combining cedilla","≈     $̧"],
    u00B9       =>  "\x{00B9}", #   =>  ["¹","SUPERSCRIPT ONE","→  ²  superscript two","→  ³  superscript three","≈ <super>  1"],
    u00BA       =>  "\x{00BA}", #   =>  ["º","MASCULINE ORDINAL INDICATOR","• Spanish","≈ <super>  o"],
    u00BB       =>  "\x{00BB}", #   =>  ["»","RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK","= right guillemet","• usually closing, sometimes opening","→  ≫  much greater-than","→  》  right double angle bracket"],
################################################################################
# Vulgar fractions - The fraction bar for these may be rendered horizontally or at a slant. For other fraction characters, see 2150-215E.
    u00BC       =>  "\x{00BC}", #   =>  ["¼","VULGAR FRACTION ONE QUARTER","≈ <fraction>  1   ⁄   4"],
    u00BD       =>  "\x{00BD}", #   =>  ["½","VULGAR FRACTION ONE HALF","≈ <fraction>  1   ⁄   2"],
    u00BE       =>  "\x{00BE}", #   =>  ["¾","VULGAR FRACTION THREE QUARTERS","≈ <fraction>  3   ⁄   4"],
################################################################################
# Punctuation
    u00BF       =>  "\x{00BF}", #   =>  ["¿","INVERTED QUESTION MARK","= turned question mark","• Spanish","→  ?  question mark","→  ⸮  reversed question mark"],
################################################################################
# Letters
#    u00C0       =>  "\x{00C0}", #   =>  ["À","LATIN CAPITAL LETTER A WITH GRAVE","≡  A   $̀"],
#    u00C1       =>  "\x{00C1}", #   =>  ["Á","LATIN CAPITAL LETTER A WITH ACUTE","≡  A   $́"],
#    u00C2       =>  "\x{00C2}", #   =>  ["Â","LATIN CAPITAL LETTER A WITH CIRCUMFLEX","≡  A   $̂"],
#    u00C3       =>  "\x{00C3}", #   =>  ["Ã","LATIN CAPITAL LETTER A WITH TILDE","≡  A   $̃"],
#    u00C4       =>  "\x{00C4}", #   =>  ["Ä","LATIN CAPITAL LETTER A WITH DIAERESIS","≡  A   $̈"],
#    u00C5       =>  "\x{00C5}", #   =>  ["Å","LATIN CAPITAL LETTER A WITH RING ABOVE","→  Å  angstrom sign","≡  A   $̊"],
#    u00C6       =>  "\x{00C6}", #   =>  ["Æ","LATIN CAPITAL LETTER AE","= latin capital ligature ae (1.1)"],
#    u00C7       =>  "\x{00C7}", #   =>  ["Ç","LATIN CAPITAL LETTER C WITH CEDILLA","≡  C   $̧"],
#    u00C8       =>  "\x{00C8}", #   =>  ["È","LATIN CAPITAL LETTER E WITH GRAVE","≡  E   $̀"],
#    u00C9       =>  "\x{00C9}", #   =>  ["É","LATIN CAPITAL LETTER E WITH ACUTE","≡  E   $́"],
#    u00CA       =>  "\x{00CA}", #   =>  ["Ê","LATIN CAPITAL LETTER E WITH CIRCUMFLEX","≡  E   $̂"],
#    u00CB       =>  "\x{00CB}", #   =>  ["Ë","LATIN CAPITAL LETTER E WITH DIAERESIS","≡  E   $"],
#    u00CC       =>  "\x{00CC}", #   =>  ["Ì","LATIN CAPITAL LETTER I WITH GRAVE","≡  I   $̀"],
#    u00CD       =>  "\x{00CD}", #   =>  ["Í","LATIN CAPITAL LETTER I WITH ACUTE","≡  I   $́"],
#    u00CE       =>  "\x{00CE}", #   =>  ["Î","LATIN CAPITAL LETTER I WITH CIRCUMFLEX","≡  I   $̂"],
#    u00CF       =>  "\x{00CF}", #   =>  ["Ï","LATIN CAPITAL LETTER I WITH DIAERESIS","≡  I   $̈"],
#    u00D0       =>  "\x{00D0}", #   =>  ["Ð","LATIN CAPITAL LETTER ETH","• lowercase is  ð","→  Đ  latin capital letter d with stroke","→  Ɖ  latin capital letter african d"],
#    u00D1       =>  "\x{00D1}", #   =>  ["Ñ","LATIN CAPITAL LETTER N WITH TILDE","≡  N   $̃"],
#    u00D2       =>  "\x{00D2}", #   =>  ["Ò","LATIN CAPITAL LETTER O WITH GRAVE","≡  O   $̀"],
#    u00D3       =>  "\x{00D3}", #   =>  ["Ó","LATIN CAPITAL LETTER O WITH ACUTE","≡  O   $́"],
#    u00D4       =>  "\x{00D4}", #   =>  ["Ô","LATIN CAPITAL LETTER O WITH CIRCUMFLEX","≡  O   $̂"],
#    u00D5       =>  "\x{00D5}", #   =>  ["Õ","LATIN CAPITAL LETTER O WITH TILDE","≡  O   $̃"],
#    u00D6       =>  "\x{00D6}", #   =>  ["Ö","LATIN CAPITAL LETTER O WITH DIAERESIS","≡  O   $̈"],
################################################################################
# Mathematical operator
#    u00D7       =>  "\x{00D7}", #   =>  ["×","MULTIPLICATION SIGN","= z notation Cartesian product","→  ✕  multiplication x","→  ❌  cross mark","→  ⨯  vector or cross product"],
################################################################################
# Letters
#    u00D8       =>  "\x{00D8}", #   =>  ["Ø","LATIN CAPITAL LETTER O WITH STROKE","= o slash","→  ∅  empty set"],
#    u00D9       =>  "\x{00D9}", #   =>  ["Ù","LATIN CAPITAL LETTER U WITH GRAVE","≡  U   $̀"],
#    u00DA       =>  "\x{00DA}", #   =>  ["Ú","LATIN CAPITAL LETTER U WITH ACUTE","≡  U   $́"],
#    u00DB       =>  "\x{00DB}", #   =>  ["Û","LATIN CAPITAL LETTER U WITH CIRCUMFLEX","≡  U   $̂"],
#    u00DC       =>  "\x{00DC}", #   =>  ["Ü","LATIN CAPITAL LETTER U WITH DIAERESIS","≡  U   $̈"],
#    u00DD       =>  "\x{00DD}", #   =>  ["Ý","LATIN CAPITAL LETTER Y WITH ACUTE","≡  Y   $́"],
#    u00DE       =>  "\x{00DE}", #   =>  ["Þ","LATIN CAPITAL LETTER THORN"],
#    u00DF       =>  "\x{00DF}", #   =>  ["ß","LATIN SMALL LETTER SHARP S","= Eszett","• German","• not used in Swiss High German","• uppercase is “SS” or  ẞ","• typographically the glyph for this character can be based on a ligature of  ſ  with either  s  or with an old-style glyph for  z (the latter similar in appearance to  ʒ ). Both forms exist interchangeably today.","→  β  greek small letter beta"],
#    u00E0       =>  "\x{00E0}", #   =>  ["à","LATIN SMALL LETTER A WITH GRAVE","≡  a   $̀"],
#    u00E1       =>  "\x{00E1}", #   =>  ["á","LATIN SMALL LETTER A WITH ACUTE","≡  a   $́"],
#    u00E2       =>  "\x{00E2}", #   =>  ["â","LATIN SMALL LETTER A WITH CIRCUMFLEX","≡  a   $"],
#    u00E3       =>  "\x{00E3}", #   =>  ["ã","LATIN SMALL LETTER A WITH TILDE","• Portuguese","≡  a   $̃"],
#    u00E4       =>  "\x{00E4}", #   =>  ["ä","LATIN SMALL LETTER A WITH DIAERESIS","≡  a   $̈"],
#    u00E5       =>  "\x{00E5}", #   =>  ["å","LATIN SMALL LETTER A WITH RING ABOVE","• Danish, Norwegian, Swedish, Walloon","≡  a   $̊"],
#    u00E6       =>  "\x{00E6}", #   =>  ["æ","LATIN SMALL LETTER AE","= latin small ligature ae (1.1)","= ash (from Old English æsc)","• Danish, Norwegian, Icelandic, Faroese, Old English, French, IPA","→  œ  latin small ligature oe","→  ӕ  cyrillic small ligature a ie"],
#    u00E7       =>  "\x{00E7}", #   =>  ["ç","LATIN SMALL LETTER C WITH CEDILLA","≡  c   $̧"],
#    u00E8       =>  "\x{00E8}", #   =>  ["è","LATIN SMALL LETTER E WITH GRAVE","≡  e   $̀"],
#    u00E9       =>  "\x{00E9}", #   =>  ["é","LATIN SMALL LETTER E WITH ACUTE","≡  e   $́"],
#    u00EA       =>  "\x{00EA}", #   =>  ["ê","LATIN SMALL LETTER E WITH CIRCUMFLEX","≡  e   $̂"],
#    u00EB       =>  "\x{00EB}", #   =>  ["ë","LATIN SMALL LETTER E WITH DIAERESIS","≡  e   $̈"],
#    u00EC       =>  "\x{00EC}", #   =>  ["ì","LATIN SMALL LETTER I WITH GRAVE","• Italian, Malagasy","≡  i   $̀"],
#    u00ED       =>  "\x{00ED}", #   =>  ["í","LATIN SMALL LETTER I WITH ACUTE","≡  i   $́"],
#    u00EE       =>  "\x{00EE}", #   =>  ["î","LATIN SMALL LETTER I WITH CIRCUMFLEX","≡  i   $̂"],
#    u00EF       =>  "\x{00EF}", #   =>  ["ï","LATIN SMALL LETTER I WITH DIAERESIS","≡  i   $̈"],
#    u00F0       =>  "\x{00F0}", #   =>  ["ð","LATIN SMALL LETTER ETH","• Icelandic, Faroese, Old English, IPA","• uppercase is  Ð","→  δ  greek small letter delta","→  ∂  partial differential"],
#    u00F1       =>  "\x{00F1}", #   =>  ["ñ","LATIN SMALL LETTER N WITH TILDE","≡  n   $̃"],
#    u00F2       =>  "\x{00F2}", #   =>  ["ò","LATIN SMALL LETTER O WITH GRAVE","≡  o   $̀"],
#    u00F3       =>  "\x{00F3}", #   =>  ["ó","LATIN SMALL LETTER O WITH ACUTE","≡  o   $́"],
#    u00F4       =>  "\x{00F4}", #   =>  ["ô","LATIN SMALL LETTER O WITH CIRCUMFLEX","≡  o   $̂"],
#    u00F5       =>  "\x{00F5}", #   =>  ["õ","LATIN SMALL LETTER O WITH TILDE","• Portuguese, Estonian, Livonian","≡  o   $̃"],
#    u00F6       =>  "\x{00F6}", #   =>  ["ö","LATIN SMALL LETTER O WITH DIAERESIS","≡  o   $̈"],
################################################################################
# Mathematical operator
#    u00F7       =>  "\x{00F7}", #   =>  ["÷","DIVISION SIGN","= obelus","• occasionally used as an alternate, more visually distinct version of  −  or    in some contexts","• historically used as a punctuation mark to denote questionable passages in manuscripts","→  ܋  syriac harklean obelus","→  ⁒  commercial minus sign","→  −  minus sign","→  ∕  division slash","→  ∣  divides","→  ∶  ratio","→  ➗  heavy division sign"],
################################################################################
# Letters
#    u00F8       =>  "\x{00F8}", #   =>  ["ø","LATIN SMALL LETTER O WITH STROKE","= o slash","• Danish, Norwegian, Faroese, IPA","→  ⌀  diameter sign"],
#    u00F9       =>  "\x{00F9}", #   =>  ["ù","LATIN SMALL LETTER U WITH GRAVE","• French, Italian","≡  u   $̀"],
#    u00FA       =>  "\x{00FA}", #   =>  ["ú","LATIN SMALL LETTER U WITH ACUTE","≡  u   $́"],
#    u00FB       =>  "\x{00FB}", #   =>  ["û","LATIN SMALL LETTER U WITH CIRCUMFLEX","≡  u   $̂"],
#    u00FC       =>  "\x{00FC}", #   =>  ["ü","LATIN SMALL LETTER U WITH DIAERESIS","≡  u   $̈"],
#    u00FD       =>  "\x{00FD}", #   =>  ["ý","LATIN SMALL LETTER Y WITH ACUTE","• Czech, Slovak, Icelandic, Faroese, Welsh, Malagasy","≡  y   $́"],
#    u00FE       =>  "\x{00FE}", #   =>  ["þ","LATIN SMALL LETTER THORN","• Icelandic, Old English, phonetics","• Runic letter borrowed into Latin script","→  ᚦ  runic letter thurisaz thurs thorn"],
#    u00FF       =>  "\x{00FF}", #   =>  ["ÿ","LATIN SMALL LETTER Y WITH DIAERESIS","• French, medieval Hungarian orthography","• uppercase is  Ÿ","≡  y   $"],
################################################################################

};
################################################################################
# VT100 Special Key Codes
# These are sent from the terminal back to the computer when the particular key is pressed.
# Note that the numeric keypad keys send different codes in numeric mode than in alternate mode.
# See escape codes above to change keypad mode. Function Keys:
################################################################################
# ANSI Escape sequences (ANSI Escape codes)
# ANSI Escape sequences  |  VT100 / VT52 ANSI escape sequences  |  VT100 User Guide
# These sequences define functions that change display graphics, control cursor 
# movement, and reassign keys.
# ANSI escape sequence is a sequence of ASCII characters, the first two of which
# are the ASCII "Escape" character 27 (1Bh) and the left-bracket character " [ " (5Bh).
# The character or characters following the escape and left-bracket characters
# specify an alphanumeric code that controls a keyboard or display function.
# ANSI escape sequences distinguish between uppercase and lowercase letters.
# Information is also available on VT100 / VT52 ANSI escape sequences.
################################################################################
# EOF gterm::data::term.cntrl (C) 2020 OnEhIppY, Groningen, Domero
################################################################################
```

---


- `gterm/cntrl.pm` :
```perl
#!/usr/bin/perl
#########################################################################
# ╔═══════════════════════════════════════════════════════════════════╗ #
# ║     Domero Terminal Ascii Control                                 ║ #
# ╠─┄┄┄┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈┈╣ #
# ║     (C) 2020 OnEhIppY, Groningen, Domero                          ║ #
# ╚═══════════════════════════════════════════════════════════════════╝ #
package gterm::cntrl;
# ╔════════════════════════╤══════════════════════════════════════════╗ #
# ║  Class                 │  domero/gterm/cntrl.pm                   ║ #
# ╠════════════════════════╪══════════════════════════════════════════╣ #
# ║  Version               │  1.0.1                                   ║ #
# ╠════════════════════════╪══════════════════════════════════════════╣ #
# ║  Upgrade               │  1                                       ║ #
# ╠════════════════════════╪══════════════════════════════════════════╣ #
# ║  Update                │  0                                       ║ #
# ╠════════════════════════╪══════════════════════════════════════════╣ #
# ║  Debug                 │  1                                       ║ #
# ╚════════════════════════╧══════════════════════════════════════════╝ #
#########################################################################
# ╔═══════════════════════════════════════════════════════════════════╗ #
# ║                                                                   ║ #

use strict; no strict 'refs';
use warnings; no warnings qw<uninitialized>;
use Exporter;
use vars qw($VERSION @ISA @EXPORT @EXPORT_OK);
use gfio;
use glib qw(xchr echr dechex strlength);
use Term::Cap;
use Term::Size::Any qw(chars);
use utf8;
use Encode;

$VERSION     = '1.0.1';
@ISA         = qw(Exporter);
@EXPORT      = qw(term_ctrl tc size cols rows pr prat barat hbar vbar);
@EXPORT_OK   = qw();

# ║                                                                                                                                   ║ #
# ╚═══════════════════════════════════════════════════════════════════╝ #
#########################################################################
# ╔═══════════════════════════════════════════════════════════════════╗ #
# ║ ASCII CONTROL DATA FILE LOCATION                                  ║ #
# ╠═══════════════════════════════════════════════════════════════════╣ #
my $gtermcntrl='gterm/cntrl.pm';
#print STDOUT "[LIB]".$INC{$gtermcntrl}."[/LIB]\n";
my $_gtermcntrl = (defined $INC{$gtermcntrl} && $INC{$gtermcntrl} =~ /^(.+\/)cntrl\.pm$/gs ? $1.'data/term.cntrl' : "/perl/domero/gterm/data/term.cntrl");
our $cangtermcntrl=-f $_gtermcntrl; if (!$cangtermcntrl) { print STDOUT "\n\n[gterm::cntrl][$gtermcntrl][not found]\n" }
$::GTCNTRL_LIB = $_gtermcntrl; #                                                                                                      ║ #
if ($^O =~ /win/gsi) { $::GTCNTRL_LIB =~ s/\//\\/gs }
# ╚═══════════════════════════════════════════════════════════════════╝ #
#########################################################################
# ╔═══════════════════════════════════════════════════════════════════╗ #
# ║ Terminal size : [Columns, Rows]                                   ║ #
# ╠═══════════════════════════════════════════════════════════════════╣ #
sub size { return chars() }
sub cols { return @{[chars()]}[0] }
sub rows { return @{[chars()]}[1] }
# ╚═══════════════════════════════════════════════════════════════════╝ #
#########################################################################
sub pr {
    my (@S)=@_;
    binmode STDOUT, ":encoding(UTF-8)";
    #for (my $i=0;$i<=$#S;$i++) { 
        #$S[$i]=utf8($S[$i]);
        #Encode::_utf8_on($S[$i]);
    #}
    print STDOUT join('',@S);
    binmode(STDOUT);
}
sub prat {
    my($x,$y,$t,$w,$c)=@_;
    pr(tc('cursor_save_attr').tc('cursor_pos',$x,$y).$t.($w && strlength($t)-$w > 0 ? (($c||" ")x(strlength($t)-$w)):"") .tc('cursor_restore_attr'));
}

sub barat {
    my ($x,$y,$w,$h,$fg,$bg,$t,$center)=@_;    #pr("\n\n\nBARAT[$x,$y,$w,$h,$fg,$bg,$t,$center]\n");
    my $tw=int(length($t));                    #pr("TW[$tw]\n");
    my $l=($w-$tw)>>1;                         #pr("L[$l]\n");
    my $r=($w-$tw-$l);                         #pr("R[$r]\n");
    if ($l<0 || $l>$w) { $l="" }else{ $l=" "x$l }
    if ($r<0 || $r>$w) { $r="" }else{ $r=" "x$r }
    if ($w<0) { $b="" }else{ $b=" "x$w }
    for my $yy (0..($h-1)) {
        if ($yy!=($h>>1)) {
            prat ($x,$y+$yy,tc($fg).tc("on_$bg").$b);
        } else {
            prat ($x,$y+$yy,tc($fg).tc("on_$bg").(
                !defined $center || $center==1 ? $l.$t.$r :
                $center==2 ? $l.$r.$t :
                $t.$l.$r
            ))
        }
    }
}

sub hbar {
    my ($w,$prc)=@_;
    my $p=($w/100)*$prc;
    my $lp=$p;
    my $ip=int($lp);
    my $dp=$lp-$ip;
    my $cw=int(8*$dp);
    if ($cw>=0 && $cw<=8 ) { $ip-- }
    my $ln=[];
    for my $i (0..$ip) { push @$ln, tc('hbar_8'); $w-- }
    if ($cw >=0 && $cw <=8 && $w>1 ) { push @$ln, tc('hbar_'.$cw); $w-- }
    while ($w>0) { push @$ln, ' '; $w-- }
    return $ln
}

sub vbar {
    my ($w,$prc)=@_;
    my $p=($w/100)*$prc;
    my $lp=$p;
    my $ip=int($lp);
    my $dp=abs($lp-$ip);
    my $cw=int(8*$dp);
    if ($cw>=0 && $cw<=8 ) { $ip-- }
    my $ln=[];
    for my $i (0..$ip) { push @$ln, tc('vbar_8'); $w-- }
    if ($cw>=0 && $cw<=8 ) { push @$ln, tc('vbar_'.$cw); $w-- }
    while ($w>0) { push @$ln, ' '; $w-- }
    return $ln
}

#########################################################################
# ╔═══════════════════════════════════════════════════════════════════╗ #
# ║ Terminal Control Codes                                            ║ #
# ╠═══════════════════════════════════════════════════════════════════╣ #
sub tc { 
# ╔═══════════════════════════════════════════════════════════════════╗ #
# ║ Initalize to be able to check for CharStrings. Load the           ║ #
# ║ term.cntrl library file & create byte search maps for gterm::key  ║ #
# ╠═══════════════════════════════════════════════════════════════════╣ #
#########################################################################
    if (-f $::GTCNTRL_LIB && !defined $::GTCNTRL) {
        #print STDOUT "Open Term Lib [$::GTCNTRL_LIB]\n";
        eval('$::GTCNTRL = '.gfio::content($::GTCNTRL_LIB));
        $::GTCNTRL_ID = {}; 
        for my $nm (keys %{$::GTCNTRL}) { 
            my $chrs=$::GTCNTRL->{$nm};
            if (ref($chrs) ne 'CODE') { $::GTCNTRL_ID->{$chrs} = $nm } 
        }
    }
#########################################################################
# ╚═══════════════════════════════════════════════════════════════════╝ #
#########################################################################
    term_ctrl(@_) 
}    # (alias)
################################################################################
sub term_ctrl { 
    my $name = shift();
    if (!defined $name) { die "Name is not defined term_cntrl call" }
    if (!defined $::GTCNTRL) { die ("TERM CNTRL Librabry Not Loaded,\n  missing ".(!-d $::DOMERO_LIB ? "DOMERO_LIB directory : [$::DOMERO_LIB]" : !-f $::GTCNTRL_LIB ? "GTCNTRL_LIB file : [$::GTCNTRL_LIB] " : " what??")) }
    if (ref($::GTCNTRL) ne 'HASH') { die ("TERM CNTRL Librabry Not a HASH Referece") }
    if ($name =~ /\,/gsi) { return tc(split(/\,/,$name),@_) }
    if (!defined $::GTCNTRL->{$name}) { die "Name [$name] is not defined in term.cntrl" }
    return value_cntrl($::GTCNTRL->{$name},@_)
}
# ║                                                                                                                                   ║ #
# ╚═══════════════════════════════════════════════════════════════════╝ #
#########################################################################
# ╔═══════════════════════════════════════════════════════════════════╗ #
# ║ Terminal Control Codes Reference control                          ║ #
# ╠═══════════════════════════════════════════════════════════════════╣ #
sub value_cntrl {
    my $o = shift();
    if (ref($o) eq 'CODE') { return &{$o}(@_) }
    if (ref($o) eq 'HASH') { return hash_cntrl($o,@_) }
    if (ref($o) eq 'ARRAY') { return array_cntrl($o,@_) }
    return $o
}

sub hash_cntrl {
    my $hash = shift();
    my $key = shift();
    if (!defined $key) { return $hash }
    if (!defined $hash->{$key}) { error ("Ref ($key) Not Defined in HASH: $@ $!"); exit }
    return value_cntrl($hash->{$key},@_)
}

sub array_cntrl {
    my $array = shift();
    my $index = shift();
    if (!defined $index) { return $array }
    if (!defined $array->[$index]) { error ("Index ($index) Not Defined in ARRAY: $@ $!"); exit }
    return value_cntrl($array->[$index],@_)
}
# ║                                                                   ║ #
# ╚═══════════════════════════════════════════════════════════════════╝ #
#########################################################################

1

#########################################################################
# ╔═══════════════════════════════════════════════════════════════════╗ #
# ║ EOF (C) 2020 OnEhIppY, Groningen, Domero                          ║ #
# ╚═══════════════════════════════════════════════════════════════════╝ #
#########################################################################
```

---

- `gterm/key.pm`:
```perl
#!/usr/bin/perl
################################################################################
# FULL-NON-BLOCKING !!
# FULL BLOCKING & NON-BLOCKING !!

package gterm::key;

################################################################################

use strict; no strict 'refs';  no strict 'subs';
use warnings;
use Exporter; use vars qw($VERSION @ISA @EXPORT @EXPORT_OK);

$VERSION     = '1.0.1';
@ISA         = qw(Exporter);
@EXPORT      = qw();
@EXPORT_OK   = qw();

################################################################################

use utf8 qw(decode_utf8); no utf8; use bytes;
use Term::TermKey qw(FLAG_UTF8 RES_KEY RES_AGAIN RES_EOF RES_NONE FORMAT_VIM);
use Term::Size::Any;
use Term::ReadKey;
use gerr;
use gfio; 
use glib qw(dechex octhex clonecopy);
use gterm::cntrl qw(tc);


################################################################################

$::GTKEY        = undef;
my $ESC         = tc("escape");
my $CTRLESC     = tc("escape_esc");
my $ESCMOUSE    = tc('altesc_mouse');
my $ENTER       = tc("carriage_return");
my $CTRLENTER   = tc("carriage_return_esc");

################################################################################

sub new {
    my ($class)=@_;
    if (defined $::GTKEY){ return $::GTKEY }
    $::GTKEY={ eventlist    => [], buttons  => []};
    bless $::GTKEY;
    # IO HANDLING
    gio->new('gtkey-std',\*STDIN,undef,undef,0);
    # ensure perl and libtermkey agree on Unicode handling
    if (!defined $::GTKEY->{tk}) { $::GTKEY->{tk}=Term::TermKey->new(\*STDIN) }
    #binmode( STDOUT, $::GTKEY->{tk}->get_flags() && FLAG_UTF8 ? ":encoding(UTF-8)" : undef );
    $::GTKEY->flush();
    return $::GTKEY
}

################################################################################
# IO:Select
################################################################################
sub set_io      {  # read write exception timeout
    my $self = shift();
    gio->init('gtkey-std',@_);
    return $self
}
################################################################################
sub takeloop { 
    my ($self)=@_;
    select(STDIN);
    #binmode( STDOUT, $::GTKEY->{tk}->get_flags() && FLAG_UTF8 ? ":encoding(UTF-8)" : undef );
    # STDIN ReadBuffer
    $self->{buff}       = [];
    # SCREEN Size
    my $size            = [ defined $::DESK_COLS && defined $::DESK_ROWS ? ($::DESK_COLS,$::DESK_ROWS) : size() ];
    # on Resize Event
    if (defined $self->{size} && ($self->{size}[0] != $size->[0] || $self->{size}[1] != $size->[1])) {
        $self->{size}=$size;
        push @{$self->{eventlist}}, { type => 'size', columns => $size->[0], rows => $size->[1] };
    }
    # Init Size
    else {
        $self->{size}=$size;
    }
    return $self->keys_rd()->key_ctrl()
}

################################################################################
# BLOCKING LINE INPUT WITH NON-BLOCKING LOOPBACK CALLER & INPUT CALLER
# ENTER for line input & ESC for canceling
sub getline {
    my ($self,$callback,$loopcall)=@_;
    if (!$self->{getline}) { # protect against recursive looping
        $self->takeloop(); # flush to normal input loop
        $self->{getline} = 1;
        my $inp = ""; my $lastinp;
        while ( 1 ) {
            $self->takeloop();
            while (defined (my $event=shift(@{$self->{eventlist}}))) {
                $lastinp = substr($event->{inp},-1);
                if ($lastinp eq $ENTER || $lastinp eq $CTRLENTER) {
                    $inp .= substr($event->{inp},0,-1);
                    $self->{event} = {
                        type    => "line",
                        event   => "input",
                        inp     => $inp,
                        key     => "ENTER",
                    };
                    if (defined $callback && ref($callback) eq 'CODE') { &{$callback}($self->{event}) }
                    return $self->{event}
                }
                elsif ($lastinp eq $ESC || $lastinp eq $CTRLESC) {
                    $inp .= substr($event->{inp},0,-1);
                    $self->{event} = {
                        type    => "line",
                        event   => "input",
                        inp     => $inp,
                        key     => "ESC",
                    };
                    if (defined $callback && ref($callback) eq 'CODE') { &{$callback}($self->{event}) }
                    return $self->{event}
                }
                else {
                    $inp .= $self->{event}{inp};
                }
            }
            if (defined $loopcall && ref($loopcall) eq 'CODE') { &{$loopcall}() }
        }
    }
    return {error=>"Nothing Happend Correctly??"}
}

################################################################################

sub reset_mouse {
    my ($self)=@_;
    if (defined $self->{down}) { delete $self->{down} }
    if (defined $self->{drag}) { delete $self->{drag} }
    return $self
}

################################################################################

sub size { return Term::Size::Any::chars() }    # : Columns, Rows

sub flush { my $self=shift(); $self->cbreak_md(); while (defined $self->nonblocked_rd()) { } return $self->restore_md() }

################################################################################

sub key_ctrl {
    my ($self)=@_;
    while ($#{$self->{buff}} > -1) {
        $self->read_ctrl()
    }
    select(STDOUT);
    return $self
}

################################################################################

sub read_buff { my ($self)=@_; return shift(@{$self->{buff}}) }

sub read_ctrl {
    my ($self)=@_;
    while ($#{$self->{buff}} > -1) {
        $self->{event}={inp => $self->read_buff()};
        $self->{event}{chr} = join(",",@{[map { defined $_ ? ord($_) : -1 } split(//,$self->{event}{inp})]});
        $self->{event}{hex} = join(":",@{[map { defined $_ ? octhex($_) : '--' } split(//,$self->{event}{inp})]});
        my ($key,$col,$row)=tc('mouse_event',$self->{event}{inp});
        if (defined $key) {
            $self->{event}{type} = "mouse";
            $self->{event}{event} = $key;
            $self->{event}{key} = $key;
            $self->{event}{col} = $col-1;
            $self->{event}{row} = $row-1;
            $self->{event}{moved} = 1;
        }
        elsif (substr($self->{event}{inp},0,3) eq $ESCMOUSE) {
            $self->{event}{type} = "mouse"; my @m=split(//,$self->{event}{inp});
            my $baseinp=join("",$m[0],$m[1],$m[2],$m[3]);
            if (defined $::GTCNTRL_ID->{$self->{event}{inp}}) {
                $self->{event}{key} = $::GTCNTRL_ID->{$self->{event}{inp}};
            }
            elsif (defined $::GTCNTRL_ID->{$baseinp}) {
                $self->{event}{key} = $::GTCNTRL_ID->{$baseinp};
                $self->{event}{crd} = substr($self->{event}{inp},length($baseinp));
                $self->{event}{x} = (defined $m[4] ? ord($m[4]) : -1);
                $self->{event}{y} = (defined $m[5] ? ord($m[5]) : -1);
                $self->{event}{col} = ($self->{event}{x} < 33 ?  $self->{event}{x} < 3 ? $self->{size}[0] + $self->{event}{x} - 15 : 0 : $self->{event}{x} - 33);
                $self->{event}{row} = ($self->{event}{y} < 33 ?  $self->{event}{y} < 3 ? $self->{size}[1] + $self->{event}{y} - 15 : 0 : $self->{event}{y} - 33);
                $self->{event}{moved} = 1;
                #print STDOUT "POS[$self->{event}{key}: $self->{event}{x},$self->{event}{y}]\r";
            }
            # Figure out what we don't have
            else {
                $self->{event}{type} = "key";
                $self->{event}{key} = "keypress";
            }
            $self->{event}{event} = $self->{event}{key};
        }
            #########################################################
            # TERMINAL CALL & RESPONSE
            #########################################################
            #
            # ECMA-48 Status Report Commands
            # ESC [ 5 n
            # Device status report (DSR): Answer is ESC [ 0 n (Terminal OK).
            # ESC [ 6 n
            # Cursor position report (CPR): Answer is ESC [ y ; x R, where x,y is the cursor location.
            #
            #########################################################
            #    identify                                =>  "\e[c",   
            #    terminal_type                           =>  "\e[0c",  
            #########################################################
            #    terminal_type_response                  =>  sub {     
            #        if ($_[0] =~ /^\e\[\?1\;(.+)0c$/){ return $1 }
            #        return undef
            #    },                                                  
            #########################################################
        elsif (defined $::GTCNTRL_ID->{$self->{event}{inp}}) {
            $self->{event}{key} = $::GTCNTRL_ID->{$self->{event}{inp}};
            if ($self->{event}{key} eq 'terminal_ok') {
            }
        }
        elsif ($self->{event}{inp} =~ /^.\[(.+)0c$/gs ) {
            $self->{event}{type} = "term";
            $self->{event}{event} = "response";
            my $rc=$1;
            #########################################################
            # TERMINAL RESPONSE CODES
            #########################################################
            if (defined $::GTCNTRL_ID->{$self->{event}{inp}}) {
                $self->{event}{key} = $::GTCNTRL_ID->{$self->{event}{inp}};
            }
            #    terminal_ok                             =>  "\e0n", 
            #    terminal_notok                          =>  "\e3n", 
            #########################################################
            #    terminal_identify                       =>  "\eZ",  
            #    terminal_vt52                           =>  "\e/Z", 
            #########################################################
            #    terminal_device_status_report           =>  "\e5n", 
            #########################################################
        } else {
            $self->{event}{type} = "key";
            $self->{event}{event} = "keypress";
            $self->{event}{key} = (defined $::GTCNTRL_ID->{$self->{event}{inp}} ? $::GTCNTRL_ID->{$self->{event}{inp}} : "<[$self->{event}{inp}]>");
        }
        return $self->event_ctrl()
    }
    return $self
}

################################################################################

sub event_ctrl {
    my ($self)=@_;
    $self->{event}{controls} =  $self->{event}{key};
    $self->{event}{controls} =~ s/\_down//gsi;
    $self->{event}{controls} =~ s/\_up//gsi;
    # is Mouse Event ?
    if (defined $self->{event}){
        if (defined $self->{event}{type}){
            if ($self->{event}{type} eq 'mouse') {
                if (defined($self->{event}{button} = (
                    $self->{event}{key} =~ /mouse\_up/ ? $self->{buttons}[$#{$self->{buttons}}] :
                    $self->{event}{key} =~ /left\_/ ? 'left' :
                    $self->{event}{key} =~ /middle\_/ ? 'middle' :
                    $self->{event}{key} =~ /right\_/ ? 'right' :
                    undef
                ))) {
                    eval('$self->{event}{controls} =~ s/\\_'.$self->{event}{button}.'//gsi;');
                }
                if ($self->{event}{key} =~ /\_up/) { $self->on_mouse_up() }
                elsif ($self->{event}{key} =~ /\_down/) { $self->on_mouse_down() }
                else  { $self->on_mouse_move() }
            }
        } else {
            $self->{event}{type} = "key";
            $self->{event}{event} = "keypress";
        }
    }
    return $self->listener_ctrl()
}

################################################################################

sub listener_ctrl {
    my ($self)=@_;
    if (1
        #( $self->{event}{type} eq 'mouse' && ($self->{event}{key} =~ /move/ || $self->{event}{key} =~ /drag/)) ?
        #( !defined $self->{lastpos} || $self->{lastpos}{col}!=$self->{event}{col} || $self->{lastpos}{row}!=$self->{event}{row} ) && 
        #( ref($self->{lastpos}={col=>$self->{event}{col},row=>$self->{event}{row}}) eq 'HASH' ) 
        #? 
        #1 : 0 : 1
    ) {
        push @{$self->{eventlist}}, clonecopy($self->{event})
    }
    return $self
}

################################################################################

sub on_mouse_down {
    my ($self)=@_;
    if (defined $self->{drag}) { delete $self->{drag} }
    my $button=$self->{event}{button};
    if ($self->{event}{key} =~ /wheel\_/) {
        $self->{event}{scroll} = -1
    } else {
        $self->{down} = {
            col => $self->{event}{col},
            row => $self->{event}{row}
        };
        $self->set_area( $self->{down}{col}, $self->{down}{row}, $self->{event}{col}, $self->{event}{row} );
        $self->{event}{area}=$self->{area};
        push @{$self->{buttons}}, $button;
    }
}

sub on_mouse_move {
    my ($self)=@_;
    if (defined $self->{down}) {
        $self->{drag} = {
            col => $self->{event}{col},
            row => $self->{event}{row}
        };
        $self->set_area( $self->{down}{col}, $self->{down}{row}, $self->{event}{col}, $self->{event}{row} );
        $self->{event}{area}=$self->{area};
    } else {
        $self->{move} = {
            col => $self->{event}{col},
            row => $self->{event}{row}
        };
    }
}


sub on_mouse_up {
    my ($self)=@_;
    my $button=$self->{event}{button};
    if ($self->{event}{key} =~ /wheel\_/) {
        $self->{event}{scroll} = 1
    } else {
        $button = shift(@{$self->{buttons}});
        $self->{event}{up} = {  col => $self->{event}{col}, row => $self->{event}{row} };
        $self->set_area( $self->{down}{col}, $self->{down}{row}, $self->{event}{col}, $self->{event}{row} );
        $self->{event}{area}=$self->{area};
        if ($self->{drag}) {
            $self->{event}{down} = {    col => $self->{down}{col},  row => $self->{down}{row}   };
            $self->{event}{drop} = {    col => $self->{drag}{col},  row => $self->{drag}{row}   };
            $self->{event}{event} =~ s/mouse_up/$button\_drop/gsi;
            $self->{event}{event} =~ s/_up$/\_drop/gsi;
        } else {
            $self->{event}{event} =~ s/mouse_up/$button\_click/gsi;
            $self->{event}{event} =~ s/_up$/\_click/gsi;
        }
    }
}

sub set_area {
    my ($self,$sx,$sy,$ex,$ey)=@_;
    my $l=$sx;
    my $r=$ex;
    my $t=$sy;
    my $b=$ey;
    my $w=abs($r-$l);
    my $h=abs($b-$t);
    if ($l > $r) { my $x=$r; $r=$l; $l=$x }
    if ($t > $b) { my $y=$b; $b=$t; $t=$y }
    $self->{area}={
        l => $l,
        t => $t,
        r => $r,
        b => $b,
        w => $w,
        h => $h,
        size => [$w,$h],
        hc => ($l+($w>>1)),
        vc => ($t+($h>>1)),
        sx => $sx, sy => $sy, ex => $ex, ey => $ey,
        box => [$l, $t, $r, $b],
        inbox => [$l+1, $t+1, $r-1, $b-1],
        outbox => [$l-1, $t-1, $r+1, $b+1],
        from => [$sx, $sy],
        to => [$ex, $ey]
    };
    return $self
}


################################################################################
# ReadMode MODE [, Filehandle]
#
#   Takes an integer argument or a string synonym (case insensitive),
#   which can currently be one of the following values :
#
#   INT   SYNONYM    DESCRIPTION
#   0    'restore'   Restore original settings.
#   1    'normal'    Change to what is commonly the default mode,
#                    echo on, buffered, signals enabled, Xon/Xoff
#                    possibly enabled, and 8-bit mode possibly disabled.
#   2    'noecho'    Same as 1, just with echo off. Nice for
#                    reading passwords.
#   3    'cbreak'    Echo off, unbuffered, signals enabled, Xon/Xoff
#                    possibly enabled, and 8-bit mode possibly enabled.
#   4    'raw'       Echo off, unbuffered, signals disabled, Xon/Xoff
#                    disabled, and 8-bit mode possibly disabled.
#   5    'ultra-raw' Echo off, unbuffered, signals disabled, Xon/Xoff 
#                    disabled, 8-bit mode enabled if parity permits,
#                    and CR to CR/LF translation turned off.
################################################################################
sub restore_md      { my $self = shift; ReadMode(0); return $self }
sub normal_md       { my $self = shift; ReadMode(1); return $self }
sub noecho_md       { my $self = shift; ReadMode(2); return $self }
sub cbreak_md       { my $self = shift; ReadMode(3); return $self }
sub raw_md          { my $self = shift; ReadMode(4); return $self }
sub uraw_md         { my $self = shift; ReadMode(5); return $self }
################################################################################

################################################################################
# ReadKey MODE [, Filehandle]
#
#   Takes an integer argument, which can currently be one of the following values:
#
#   0    Perform a normal read using getc
#   -1   Perform a non-blocked read
#   >0   Perform a timed read
#
#   If the filehandle is not supplied, it will default to STDIN. If there is nothing 
#   waiting in the buffer during a non-blocked read, then undef will be returned. 
#   In most situations, you will probably want to use ReadKey -1.
#
#   NOTE that if the OS does not provide any known mechanism for non-blocking reads, 
#   then a ReadKey -1 can die with a fatal error. This will hopefully not be common.
#
#   If MODE is greater then zero, then ReadKey will use it as a timeout value in 
#   seconds (fractional seconds are allowed), and won't return undef until that time expires.
#
#   NOTE, again, that some OS's may not support this timeout behaviour.
#
#   If MODE is less then zero, then this is treated as a timeout of zero, and thus 
#   will return immediately if no character is waiting. A MODE of zero, however, 
#   will act like a normal getc.
#
#   NOTE, there are currently some limitations with this call under Windows. It 
#   may be possible that non-blocking reads will fail when reading repeating keys
#   from more then one console.
#
################################################################################
sub nonblocked_rd   { my $self = shift; return ReadKey(-1) }
sub normal_rd       { my $self = shift; return ReadKey(0) }
sub timed_rd        { my $self = shift; return ReadKey(@_) }
################################################################################
sub takeloop_rd     { my ($self) = @_; $self->{key_buff}=""; while ( defined($self->{key_in} = $self->nonblocked_rd()) ) { $self->{key_buff}.=$self->{key_in} }; return $self }
################################################################################
sub key_rd          { my ($self) = @_; return $self->uraw_md()->takeloop_rd()->restore_md()->{key_buff} }
sub keys_rd         { my ($self) = @_;
#   if ($::GIO->can_rd('gtkey-std')) {
#       $::GIO->save_select('gtkey-std');
        while ($self->key_rd() ne "") { 
            my $buf="";
            for my $c (split(//,$self->{key_buff})) {
                if (ord($c) == 27 && length($buf)) { push @{$self->{buff}}, $buf; $buf = $c } 
                else { $buf .= $c }
            }
            if (length($buf)) { push @{$self->{buff}}, $buf }
        }
#       $::GIO->restore_select()
#   }
    return $self
}
################################################################################

################################################################################
1 # EOF gterm::key.pm (C) 2020 OnEhIppY, Groningen, Domero
################################################################################


################################################################################
# ReadLine MODE [, Filehandle]
# Takes an integer argument, which can currently be one of the following values:
#0    Perform a normal read using scalar(<FileHandle>)
#-1   Perform a non-blocked read
#>0   Perform a timed read
#If there is nothing waiting in the buffer during a non-blocked read, then undef will be returned.
#
#NOTE, that if the OS does not provide any known mechanism for non-blocking reads, then a ReadLine 1 can die with a fatal error. This will hopefully not be common.
#
#NOTE that a non-blocking test is only performed for the first character in the line, not the entire line. This call will probably not do what you assume, especially with ReadMode MODE values higher then 1. For example, pressing Space and then Backspace would appear to leave you where you started, but any timeouts would now be suspended.
#
#This call is currently not available under Windows.
#
################################################################################

################################################################################
#GetTerminalSize [Filehandle]
# Returns either an empty array if this operation is unsupported, or a four
# element array containing: the width of the terminal in characters, the height
# of the terminal in character, the width in pixels, and the height in pixels.
# (The pixel size will only be valid in some environments.)
#
# NOTE, under Windows, this function must be called with an output filehandle,
# such as STDOUT, or a handle opened to CONOUT$.
#
################################################################################

################################################################################
#SetTerminalSize WIDTH,HEIGHT,XPIX,YPIX [, Filehandle]
# Return -1 on failure, 0 otherwise.
#
# NOTE that this terminal size is only for informative value, and changing the
# size via this mechanism will not change the size of the screen. For example,
# XTerm uses a call like this when it resizes the screen. If any of the new
# measurements vary from the old, the OS will probably send a SIGWINCH signal
# to anything reading that tty or pty.
#
# This call does not work under Windows.
#
################################################################################

################################################################################
#GetSpeed [, Filehandle]
# Returns either an empty array if the operation is unsupported, or a two value
# array containing the terminal in and out speeds, in decimal. E.g, an in speed
# of 9600 baud and an out speed of 4800 baud would be returned as (9600,4800).
# Note that currently the in and out speeds will always be identical in some OS's.
#
# No speeds are reported under Windows.
#
################################################################################

################################################################################
#GetControlChars [, Filehandle]
# Returns an array containing key/value pairs suitable for a hash. The pairs
# consist of a key, the name of the control character/signal, and the value of
# that character, as a single character.
#
# This call does nothing under Windows.
#
# Each key will be an entry from the following list:
#
# DISCARD
# DSUSPEND
# EOF
# EOL
# EOL2
# ERASE
# ERASEWORD
# INTERRUPT
# KILL
# MIN
# QUIT
# QUOTENEXT
# REPRINT
# START
# STATUS
# STOP
# SUSPEND
# SWITCH
# TIME
#
# Thus, the following will always return the current interrupt character, regardless of platform.
#
# %keys = GetControlChars;
# $int = $keys{INTERRUPT};
################################################################################

################################################################################
#SetControlChars [, Filehandle]
# Takes an array containing key/value pairs, as a hash will produce. The pairs
# should consist of a key that is the name of a legal control character/signal,
# and the value should be either a single character, or a number in the range
# 0-255. SetControlChars will die with a runtime error if an invalid character
# name is passed or there is an error changing the settings. The list of valid
# names is easily available via
#
#%cchars = GetControlChars();
#@cnames = keys %cchars;
#This call does nothing under Windows.
################################################################################


#########################################################################
# ╔═══════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════╗ #
# ║ EOF (C) 2020 OnEhIppY, Groningen, Domero                                                                                          ║ #
# ╚═══════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════╝ #
#########################################################################
```

---

- `gterm/box.pm`:
```perl
#!/usr/bin/perl
################################################################################

################################################################################
#
#   use gterm::cntrl;
#   use gterm::box;
#
#   my $row=gterm::box::row->new( e => 'dotted', c => 'green', l=>0, t=>0, w=>cols(), h=>rows() );
#   $row->line(0," Text Line ");
#
################################################################################

package gterm::box;

use gerr;
use gterm::cntrl;

################################################################################

sub new {
    my ($class,$parent)=@_;
    my $box={p=>$parent,l=>[]};
    bless $box;
    return $box->init();
}

sub init {
    my ($self)=@_;
    # Box Edge
    if ($self->{p}{e}) {
        $self->{p}{il}=$self->{p}{l}+1;
        $self->{p}{iw}=$self->{p}{w}-2;
        $self->{p}{it}=$self->{p}{t}+1;
        $self->{p}{ih}=$self->{p}{h}-2;
    }else{
        $self->{p}{il}=$self->{p}{l};
        $self->{p}{iw}=$self->{p}{w};
        $self->{p}{it}=$self->{p}{t};
        $self->{p}{ih}=$self->{p}{h};
    }
    # Right Bottom Position
    $self->{p}{r}=$self->{p}{l}+$self->{p}{w};
    $self->{p}{b}=$self->{p}{t}+$self->{p}{h};
    # Column Rows
    $self->{p}{childs}=[];
    return $self->draw()
}

################################################################################

sub draw {
    my ($box)=@_;
    drawbox($box->{p}{e},$box->{p}{l},$box->{p}{t},$box->{p}{w},$box->{p}{h},$box->{p}{c},1);
    if ($box->{p}{e} && $box->{p}{c}) {$box->title()}
    return $box->write()
}

sub title {
    my ($box)=@_;
    if ($box->{p}{title}) {
        prat($box->{p}{il},$box->{p}{t},tc($box->{p}{c}[0]).tc('on_'.$box->{p}{c}[1])."[ $box->{p}{title} ]".tc('reset'));
    }
    return $box
}

sub write {
    my ($box)=@_;
    for my $line (0..$#{$box->{l}}) { $box->write_line($line) }
    return $box
}

sub write_line {
    my ($box,$line)=@_;
    if ($line < $box->{p}{ih} && defined $box->{l}[$line]) {
        prat(
            $box->{p}{il},
            $box->{p}{it} + $line,
            ($box->{p}{c} ? tc('on_'.$box->{p}{c}[1]) :'') . $box->{l}[$line],
            $box->{p}{iw}
        );
    }
    return $box
}

sub line { my ($box,$line,$text)=@_; $box->{l}[$line]=$text; return $box->write_line($line) }

sub vline {
    my ($self,$col,$prc,$color)=@_;
    my $size=$self->{p}{ih};
    #print STDOUT tc('clear_screen').tc('restore_terminal').gparse::str({size=>$size,prc=>$prc,,args=>[@_]});
    #exit 1;
    my $vbar = vbar($size,$prc);
    for my $line (0..($size-1)) {
        prat(
            $self->{p}{il} + $col,
            $self->{p}{it} + ( $self->{p}{ih} - 1 - $line ),
            $color . $vbar->[$line] . tc('reset')
        );
    }
}

sub hline {}


################################################################################
################################################################################

sub row {
    my ($self,%options)=@_;
    my $row=gterm::box::row->new(parent=>$self->{p},%options);
    push @{$self->{p}{childs}}, $row;
    return $row
}

sub col {
    my ($self,%options)=@_;
    my $col=gterm::box::col->new(parent=>$self->{p},%options);
    push @{$self->{p}{childs}}, $col;
    return $col
}

sub table {
    my ($self,%options)=@_;
    my $table=gterm::box::table->new(parent=>$self->{p},%options);
    push @{$self->{p}{childs}}, $table;
    return $table
}

################################################################################
################################################################################

package gterm::box::row;

use gterm::cntrl qw(cols);

################################################################################

sub new {
    my ($class,%options)=@_;
    my $self=\%options;
    bless $self;
    # Init Row
    $self->{l} = $self->{l} || (!$self->{parent} ? 0 : $self->{parent}{il});
    $self->{t} >>=0;
    $self->{w} = $self->{w} || (!$self->{parent} ? cols() : $self->{parent}{iw});
    $self->{h} >>=0;
    # Row Box & Lines
    $self->{box}=gterm::box->new($self);

    return $self
}

sub box { my ($self)=@_; return $self->{box} }

################################################################################
################################################################################

package gterm::box::col;

use gterm::cntrl qw(rows);

################################################################################

sub new {
    my ($class,%options)=@_;
    my $self=\%options;
    bless $self;
    # Init Column
    $self->{l} >>= 0;
    $self->{t} = $self->{t} || (!$self->{parent} ? 0 : $self->{parent}{it});
    $self->{w} >>= 0;
    $self->{h} = $self->{h} || (!$self->{parent} ? rows() : $self->{parent}{ih});
    # Box Edge
    $self->{box} = gterm::box->new($self);
    return $self
}

sub box { my ($self)=@_; return $self->{box} }

################################################################################
################################################################################

package gterm::box::table;

use gterm::cntrl qw(rows cols);

################################################################################

sub new {
    my ($class,%options)=@_;
    my $self=\%options;
    bless $self;
    # Init Table
    $self->{l} = defined $self->{l} ? $self->{l}>>0 : !$self->{parent} ? 1 : $self->{parent}{il}+1;
    $self->{w} = defined $self->{w} ? $self->{w}>>0 : !$self->{parent} ? cols()-2 : $self->{parent}{iw}-2;
    $self->{t} = defined $self->{t} ? $self->{t}>>0 : !$self->{parent} ? 0 : $self->{parent}{it};
    $self->{h} = defined $self->{h} ? $self->{h}>>0 : !$self->{parent} ? rows() : $self->{parent}{ih};
    # Column Box & Lines
    $self->{box}=gterm::box->new($self);
    return $self
}

sub box { my ($self)=@_; return $self->{box} }

# $col->table->data( [ [ text, text, .. ], [ .. ], .. ] )

sub data {
    my ($self,$data) = @_;
    my $nr = ($#{$data}+1);
    my $rn = 0;
    for my $r (@{$data}) {
        if ($rn < $self->{ih}) {
            my $row = $self->{childs}[$rn] || $self->box->row(
                l => $self->{il},
                w => $self->{iw},
                t => $self->{it}+$rn,
                h => 1
            );
            my $cn = 0;
            my $nc = ($#{$r}+1);
            my $cw = ($self->{iw} / $nc)>>0;
            for my $c (@{$r}) {
                my $col = $row->{childs}[$cn] || $row->box->col(
                    t => $row->{it},
                    h => $row->{ih},
                    l => $row->{il}+($cn*$cw),
                    w => $cw
                );
                $col->box->line(0,$c);
                $cn++
            }
        }
        $rn++
    }
}

################################################################################
################################################################################
1 # EOF gterm::box (C) 2022 OnEhIppY, Domero, Groningen
```
